/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.actions;

import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.health.Health;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.AddCacheDependencyAction;
import org.infinispan.security.actions.AddCacheManagerListenerAction;
import org.infinispan.security.actions.AddCacheManagerListenerAsyncAction;
import org.infinispan.security.actions.AddLoggerListenerAsyncAction;
import org.infinispan.security.actions.CacheContainsKeyAsyncAction;
import org.infinispan.security.actions.DefineConfigurationAction;
import org.infinispan.security.actions.GetCacheAction;
import org.infinispan.security.actions.GetCacheConfigurationFromManagerAction;
import org.infinispan.security.actions.GetCacheEntryAction;
import org.infinispan.security.actions.GetCacheEntryAsyncAction;
import org.infinispan.security.actions.GetCacheManagerHealthAction;
import org.infinispan.security.actions.GetClusterExecutorAction;
import org.infinispan.security.actions.GetEmbeddedCacheManagerAction;
import org.infinispan.security.actions.GetOrCreateTemplateAction;
import org.infinispan.security.actions.GetPersistenceManagerAction;
import org.infinispan.security.actions.GetUnwrappedCacheAction;
import org.infinispan.security.actions.GetUnwrappedNameCacheAction;
import org.infinispan.security.actions.RemoveListenerAsyncAction;
import org.infinispan.security.actions.UndefineConfigurationAction;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.security.impl.SecureCacheImpl;

public class SecurityActions {
    public static EmbeddedCacheManager getEmbeddedCacheManager(AdvancedCache<?, ?> cache) {
        return Security.doPrivileged(new GetEmbeddedCacheManagerAction(cache));
    }

    public static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return Security.doPrivileged(cacheManager::getGlobalComponentRegistry);
    }

    public static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager cacheManager) {
        return Security.doPrivileged(cacheManager::getCacheManagerConfiguration);
    }

    public static <A extends Cache<K, V>, K, V> A getUnwrappedCache(Cache<K, V> cache) {
        return (A)((Cache)Security.doPrivileged(new GetUnwrappedCacheAction(cache)));
    }

    public static <A extends Cache<K, V>, K, V> A getUnwrappedCache(EmbeddedCacheManager cacheManager, String cacheName) {
        return (A)((Cache)Security.doPrivileged(new GetUnwrappedNameCacheAction(cacheManager, cacheName)));
    }

    public static void defineConfiguration(EmbeddedCacheManager cacheManager, String cacheName, Configuration configurationOverride) {
        Security.doPrivileged(new DefineConfigurationAction(cacheManager, cacheName, configurationOverride));
    }

    public static <A extends Cache<K, V>, K, V> A getCache(EmbeddedCacheManager cacheManager, String cacheName) {
        return (A)((Cache)Security.doPrivileged(new GetCacheAction(cacheManager, cacheName)));
    }

    public static Configuration getCacheConfiguration(EmbeddedCacheManager cacheManager, String name) {
        return Security.doPrivileged(new GetCacheConfigurationFromManagerAction(cacheManager, name));
    }

    public static void stopCache(Cache<?, ?> cache) {
        Security.doPrivileged(() -> {
            cache.stop();
            return null;
        });
    }

    public static ClusterExecutor getClusterExecutor(Cache<?, ?> cache) {
        GetClusterExecutorAction action = new GetClusterExecutorAction(cache);
        return Security.doPrivileged(action);
    }

    public static ClusterExecutor getClusterExecutor(EmbeddedCacheManager cacheManager) {
        GetClusterExecutorAction action = new GetClusterExecutorAction(cacheManager);
        return Security.doPrivileged(action);
    }

    public static void checkPermission(EmbeddedCacheManager cacheManager, AuthorizationPermission permission) {
        Authorizer authorizer = SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(Authorizer.class);
        authorizer.checkPermission(permission);
    }

    public static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> advancedCache) {
        return Security.doPrivileged(advancedCache::getComponentRegistry);
    }

    public static void undefineConfiguration(EmbeddedCacheManager cacheManager, String name) {
        UndefineConfigurationAction action = new UndefineConfigurationAction(cacheManager, name);
        Security.doPrivileged(action);
    }

    public static AuthorizationManager getCacheAuthorizationManager(AdvancedCache<?, ?> cache) {
        return Security.doPrivileged(cache::getAuthorizationManager);
    }

    public static void addListener(EmbeddedCacheManager cacheManager, Object listener) {
        Security.doPrivileged(new AddCacheManagerListenerAction(cacheManager, listener));
    }

    public static CompletionStage<Void> removeListenerAsync(Listenable listenable, Object listener) {
        RemoveListenerAsyncAction action = new RemoveListenerAsyncAction(listenable, listener);
        return Security.doPrivileged(action);
    }

    public static <K, V> CompletionStage<CacheEntry<K, V>> getCacheEntryAsync(AdvancedCache<K, V> cache, K key) {
        GetCacheEntryAsyncAction action = new GetCacheEntryAsyncAction(cache, key);
        return (CompletionStage)Security.doPrivileged(action);
    }

    public static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        return Security.doPrivileged(cache::getCacheConfiguration);
    }

    public static <K> CompletionStage<Boolean> cacheContainsKeyAsync(AdvancedCache<K, ?> ac, K key) {
        return Security.doPrivileged(new CacheContainsKeyAsyncAction<K>(ac, key));
    }

    public static void addCacheDependency(EmbeddedCacheManager cacheManager, String from, String to) {
        Security.doPrivileged(new AddCacheDependencyAction(cacheManager, from, to));
    }

    public static PersistenceManager getPersistenceManager(EmbeddedCacheManager cacheManager, String cacheName) {
        GetPersistenceManagerAction action = new GetPersistenceManagerAction(cacheManager, cacheName);
        return Security.doPrivileged(action);
    }

    public static Health getHealth(EmbeddedCacheManager cacheManager) {
        GetCacheManagerHealthAction action = new GetCacheManagerHealthAction(cacheManager);
        return Security.doPrivileged(action);
    }

    public static CompletionStage<Void> addLoggerListenerAsync(EmbeddedCacheManager ecm, Object listener) {
        return Security.doPrivileged(new AddLoggerListenerAsyncAction(ecm, listener));
    }

    public static CompletionStage<Void> addListenerAsync(EmbeddedCacheManager cacheManager, Object listener) {
        return Security.doPrivileged(new AddCacheManagerListenerAsyncAction(cacheManager, listener));
    }

    public static CacheEntry<String, String> getCacheEntry(AdvancedCache<String, String> cache, String key) {
        return (CacheEntry)Security.doPrivileged(new GetCacheEntryAction(cache, key));
    }

    public static DistributionManager getDistributionManager(AdvancedCache<?, ?> cache) {
        return Security.doPrivileged(cache::getDistributionManager);
    }

    public static <K, V> AdvancedCache<K, V> anonymizeSecureCache(AdvancedCache<K, V> cache) {
        return Security.doPrivileged(() -> cache.transform(SecurityActions::unsetSubject));
    }

    private static <K, V> AdvancedCache<K, V> unsetSubject(AdvancedCache<K, V> cache) {
        if (cache instanceof SecureCacheImpl) {
            return new SecureCacheImpl((AdvancedCache)SecurityActions.getUnwrappedCache(cache));
        }
        return cache;
    }

    public static Configuration getOrCreateTemplate(EmbeddedCacheManager cm, String configName, Configuration cfg) {
        GetOrCreateTemplateAction action = new GetOrCreateTemplateAction(cm, configName, cfg);
        return Security.doPrivileged(action);
    }

    public static void stopManager(EmbeddedCacheManager cacheManager) {
        Security.doPrivileged(() -> {
            cacheManager.stop();
            return null;
        });
    }
}

