/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalTracingConfiguration;
import org.infinispan.configuration.global.TracingExporterProtocol;
import org.infinispan.util.logging.Log;

public class GlobalTracingConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalTracingConfiguration> {
    private final AttributeSet attributes = GlobalTracingConfiguration.attributeDefinitionSet();

    public GlobalTracingConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public GlobalTracingConfigurationBuilder collectorEndpoint(String collectorEndpoint) {
        this.attributes.attribute(GlobalTracingConfiguration.COLLECTOR_ENDPOINT).set((Object)collectorEndpoint);
        return this;
    }

    public boolean enabled() {
        return this.attributes.attribute(GlobalTracingConfiguration.COLLECTOR_ENDPOINT).get() != null && (Boolean)this.attributes.attribute(GlobalTracingConfiguration.ENABLED).get() != false;
    }

    public GlobalTracingConfigurationBuilder enable() {
        this.attributes.attribute(GlobalTracingConfiguration.ENABLED).set((Object)true);
        return this;
    }

    public GlobalTracingConfigurationBuilder disable() {
        this.attributes.attribute(GlobalTracingConfiguration.ENABLED).set((Object)false);
        return this;
    }

    public GlobalTracingConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(GlobalTracingConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public GlobalTracingConfigurationBuilder exporterProtocol(TracingExporterProtocol exporterProtocol) {
        this.attributes.attribute(GlobalTracingConfiguration.EXPORTER_PROTOCOL).set((Object)exporterProtocol);
        return this;
    }

    public GlobalTracingConfigurationBuilder serviceName(String serviceName) {
        this.attributes.attribute(GlobalTracingConfiguration.SERVICE_NAME).set((Object)serviceName);
        return this;
    }

    public GlobalTracingConfiguration create() {
        return new GlobalTracingConfiguration(this.attributes.protect());
    }

    public Builder<?> read(GlobalTracingConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "GlobalTracingConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + "]";
    }

    public void validate() {
        String collectorEndpoint = (String)this.attributes.attribute(GlobalTracingConfiguration.COLLECTOR_ENDPOINT).get();
        if (collectorEndpoint == null) {
            return;
        }
        try {
            new URL(collectorEndpoint).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw Log.CONFIG.invalidTracingCollectorEndpoint(collectorEndpoint, e);
        }
    }
}

