/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeParser;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.TracingConfigurationBuilder;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.telemetry.SpanCategory;

public class TracingConfiguration
extends ConfigurationElement<TracingConfiguration> {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)true, Boolean.class).build();
    public static final AttributeDefinition<Set<SpanCategory>> CATEGORIES = AttributeDefinition.builder((Enum)Attribute.CATEGORIES, new LinkedHashSet<SpanCategory>(Collections.singleton(SpanCategory.CONTAINER)), Set.class).initializer(LinkedHashSet::new).serializer(AttributeSerializer.ENUM_SET).parser((AttributeParser)TracingConfigurationBuilder.CategoriesAttributeParser.INSTANCE).build();

    static AttributeSet attributeDefinitionSet() {
        AttributeSet attributeSet = new AttributeSet(TracingConfiguration.class, new AttributeDefinition[]{ENABLED, CATEGORIES});
        attributeSet.attribute(CATEGORIES).set(new LinkedHashSet<SpanCategory>(Collections.singleton(SpanCategory.CONTAINER)));
        return attributeSet;
    }

    protected TracingConfiguration(AttributeSet attributes) {
        super((Enum)Element.TRACING, attributes, new ConfigurationElement[0]);
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(ENABLED).get();
    }

    public Set<SpanCategory> categories() {
        return (Set)this.attributes.attribute(CATEGORIES).get();
    }

    public boolean enabled(SpanCategory category) {
        if (!this.enabled()) {
            return false;
        }
        return ((Set)this.attributes.attribute(CATEGORIES).get()).contains((Object)category);
    }
}

