/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractClusterExecutor;
import org.infinispan.manager.impl.ClusterExecutors;
import org.infinispan.manager.impl.ReplicableManagerFunctionCommand;
import org.infinispan.manager.impl.ReplicableRunnableCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.PassthroughMapResponseCollector;
import org.infinispan.remoting.transport.impl.PassthroughSingleResponseCollector;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.security.Security;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class AllClusterExecutor
extends AbstractClusterExecutor<AllClusterExecutor> {
    private static final Log log = LogFactory.getLog(AllClusterExecutor.class);

    AllClusterExecutor(Predicate<? super Address> predicate, EmbeddedCacheManager manager, Transport transport, long time, TimeUnit unit, Executor localExecutor, ScheduledExecutorService timeoutExecutor) {
        super(predicate, manager, transport, time, unit, localExecutor, timeoutExecutor);
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    protected AllClusterExecutor sameClusterExecutor(Predicate<? super Address> predicate, long time, TimeUnit unit) {
        return new AllClusterExecutor(predicate, this.manager, this.transport, time, unit, this.localExecutor, this.timeoutExecutor);
    }

    private <T> CompletableFuture<Void> startLocalInvocation(Function<? super EmbeddedCacheManager, ? extends T> callable, TriConsumer<? super Address, ? super T, ? super Throwable> triConsumer) {
        if (this.me == null || this.predicate == null || this.predicate.test(this.me)) {
            if (log.isTraceEnabled()) {
                log.trace("Submitting callable to local node on executor thread! - Usually remote command thread pool");
            }
            return super.submitConsumer(callable, triConsumer);
        }
        return null;
    }

    protected CompletableFuture<Void> startLocalInvocation(Runnable runnable) {
        if (this.me == null || this.predicate == null || this.predicate.test(this.me)) {
            if (log.isTraceEnabled()) {
                log.trace("Submitting runnable to local node on executor thread! - Usually remote command thread pool");
            }
            return super.submit(runnable);
        }
        return null;
    }

    @Override
    public void execute(Runnable runnable) {
        this.executeRunnable(runnable);
    }

    private CompletableFuture<?> executeRunnable(Runnable runnable) {
        CompletableFuture remoteFuture;
        CompletableFuture<Void> localFuture = this.startLocalInvocation(runnable);
        List<Address> targets = this.getRealTargets(false);
        int size = targets.size();
        if (size == 1) {
            Address target = targets.get(0);
            if (log.isTraceEnabled()) {
                log.tracef("Submitting runnable to single remote node - JGroups Address %s", target);
            }
            remoteFuture = new CompletableFuture();
            ReplicableRunnableCommand command = new ReplicableRunnableCommand(runnable);
            CompletionStage<Response> request = this.transport.invokeCommand(target, (ReplicableCommand)command, PassthroughSingleResponseCollector.INSTANCE, DeliverOrder.NONE, this.time, this.unit);
            request.handle((r, t) -> {
                if (t != null) {
                    remoteFuture.completeExceptionally((Throwable)t);
                } else {
                    this.consumeResponse((Response)r, target, remoteFuture::completeExceptionally);
                    remoteFuture.complete(null);
                }
                return null;
            });
        } else if (size > 1) {
            remoteFuture = new CompletableFuture();
            ReplicableRunnableCommand command = new ReplicableRunnableCommand(runnable);
            PassthroughMapResponseCollector collector = new PassthroughMapResponseCollector(targets.size());
            CompletionStage<Map<Address, Response>> request = this.transport.invokeCommand(targets, (ReplicableCommand)command, collector, DeliverOrder.NONE, this.time, this.unit);
            request.handle((r, t) -> {
                if (t != null) {
                    remoteFuture.completeExceptionally((Throwable)t);
                } else {
                    r.forEach((key, value) -> this.consumeResponse((Response)value, (Address)key, remoteFuture::completeExceptionally));
                    remoteFuture.complete(null);
                }
                return null;
            });
        } else {
            if (localFuture != null) {
                return localFuture;
            }
            return CompletableFuture.failedFuture((Throwable)((Object)new SuspectException("No available nodes!")));
        }
        if (localFuture != null) {
            CompletableFuture future = new CompletableFuture();
            CompletableFuture.allOf(localFuture, remoteFuture).whenComplete((v, t) -> {
                if (t != null) {
                    if (t instanceof CompletionException) {
                        future.completeExceptionally(t.getCause());
                    } else {
                        future.completeExceptionally((Throwable)t);
                    }
                } else {
                    future.complete(null);
                }
            });
            return future;
        }
        return remoteFuture;
    }

    @Override
    public CompletableFuture<Void> submit(Runnable command) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executeRunnable(command).handle((r, t) -> {
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            }
            future.complete(null);
            return null;
        });
        return future;
    }

    @Override
    public <V> CompletableFuture<Void> submitConsumer(Function<? super EmbeddedCacheManager, ? extends V> function, TriConsumer<? super Address, ? super V, ? super Throwable> triConsumer) {
        CompletableFuture<Void> localFuture = this.startLocalInvocation(function, triConsumer);
        List<Address> targets = this.getRealTargets(false);
        int size = targets.size();
        if (size > 0) {
            CompletableFuture[] futures;
            if (localFuture != null) {
                futures = new CompletableFuture[size + 1];
                futures[size] = localFuture;
            } else {
                futures = new CompletableFuture[size];
            }
            for (int i = 0; i < size; ++i) {
                Address target = targets.get(i);
                if (log.isTraceEnabled()) {
                    log.tracef("Submitting consumer to single remote node - address=%s, subject=%s", target, Security.getSubject());
                }
                ReplicableManagerFunctionCommand command = new ReplicableManagerFunctionCommand(function, Security.getSubject());
                CompletionStage<Response> request = this.transport.invokeCommand(target, (ReplicableCommand)command, PassthroughSingleResponseCollector.INSTANCE, DeliverOrder.NONE, this.time, this.unit);
                futures[i] = request.toCompletableFuture().whenComplete((r, t) -> {
                    if (t != null) {
                        if (t instanceof TimeoutException) {
                            throw CompletableFutures.asCompletionException((Throwable)t);
                        }
                        triConsumer.accept(target, (Object)null, (Throwable)t);
                    } else {
                        this.consumeResponse((Response)r, target, v -> triConsumer.accept(target, (Object)v, (Throwable)null), throwable -> triConsumer.accept(target, (Object)null, (Throwable)throwable));
                    }
                });
            }
            CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
            CompletableFuture<Void> allFuture = CompletableFuture.allOf(futures);
            allFuture.whenComplete((v, t) -> {
                if (t != null) {
                    if (t instanceof CompletionException) {
                        resultFuture.completeExceptionally(t.getCause());
                    } else {
                        resultFuture.completeExceptionally((Throwable)t);
                    }
                } else {
                    resultFuture.complete(null);
                }
            });
            return resultFuture;
        }
        if (localFuture != null) {
            return localFuture;
        }
        return CompletableFuture.failedFuture((Throwable)((Object)new SuspectException("No available nodes!")));
    }

    @Override
    public ClusterExecutor singleNodeSubmission() {
        return ClusterExecutors.singleNodeSubmissionExecutor(this.predicate, this.manager, this.transport, this.time, this.unit, this.localExecutor, this.timeoutExecutor, 0);
    }

    @Override
    public ClusterExecutor singleNodeSubmission(int failOverCount) {
        return ClusterExecutors.singleNodeSubmissionExecutor(this.predicate, this.manager, this.transport, this.time, this.unit, this.localExecutor, this.timeoutExecutor, failOverCount);
    }

    @Override
    public ClusterExecutor allNodeSubmission() {
        return this;
    }
}

