/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolvers;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.internal.BlockHoundUtil;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.InternalCacheFactory;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.health.Health;
import org.infinispan.health.impl.HealthImpl;
import org.infinispan.health.impl.jmx.HealthJMXExposerImpl;
import org.infinispan.health.jmx.HealthJMXExposer;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.DefaultCacheManagerAdmin;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.manager.ModuleRepository;
import org.infinispan.manager.impl.ClusterExecutors;
import org.infinispan.manager.impl.InternalCacheManager;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.GlobalSecurityManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.security.impl.AuthorizationManagerImpl;
import org.infinispan.security.impl.AuthorizationMapperContextImpl;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.security.impl.SecureCacheImpl;
import org.infinispan.stats.CacheContainerStats;
import org.infinispan.stats.impl.CacheContainerStatsImpl;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.CyclicDependencyException;
import org.infinispan.util.DependencyGraph;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
@MBean(objectName="CacheManager", description="Component that acts as a manager, factory and container for caches in the system.")
public class DefaultCacheManager
extends InternalCacheManager {
    public static final String OBJECT_NAME = "CacheManager";
    private static final Log log = LogFactory.getLog(DefaultCacheManager.class);
    private final ConcurrentMap<String, CompletableFuture<Cache<?, ?>>> caches = new ConcurrentHashMap();
    private final GlobalComponentRegistry globalComponentRegistry;
    private final Authorizer authorizer;
    private final DependencyGraph<String> cacheDependencyGraph = new DependencyGraph();
    private final CacheContainerStats stats;
    private final Health health;
    private final ConfigurationManager configurationManager;
    private final String defaultCacheName;
    private final Lock lifecycleLock = new ReentrantLock();
    private final Condition lifecycleCondition = this.lifecycleLock.newCondition();
    private volatile ComponentStatus status = ComponentStatus.INSTANTIATED;
    private final DefaultCacheManagerAdmin cacheManagerAdmin;
    private final ClassAllowList classAllowList;
    private final CacheManagerInfo cacheManagerInfo;
    private volatile Transport transport;
    private static ThreadLocal<String> getCacheBlockingCheck;

    public DefaultCacheManager() {
        this(null, null, true);
    }

    public DefaultCacheManager(boolean start) {
        this(null, null, start);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public DefaultCacheManager(Configuration defaultConfiguration) {
        this(null, defaultConfiguration, true);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public DefaultCacheManager(Configuration defaultConfiguration, boolean start) {
        this(null, defaultConfiguration, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration) {
        this(globalConfiguration, null, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, boolean start) {
        this(globalConfiguration, null, start);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
        this(globalConfiguration, defaultConfiguration, true);
    }

    @Deprecated(forRemoval=true, since="11.0")
    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration, boolean start) {
        globalConfiguration = globalConfiguration == null ? new GlobalConfigurationBuilder().build() : globalConfiguration;
        this.configurationManager = new ConfigurationManager(globalConfiguration);
        if (defaultConfiguration != null) {
            if (!globalConfiguration.defaultCacheName().isPresent()) {
                throw Log.CONFIG.defaultCacheConfigurationWithoutName();
            }
            this.defaultCacheName = globalConfiguration.defaultCacheName().get();
            this.configurationManager.putConfiguration(this.defaultCacheName, defaultConfiguration);
        } else {
            if (globalConfiguration.defaultCacheName().isPresent()) {
                throw Log.CONFIG.missingDefaultCacheDeclaration(globalConfiguration.defaultCacheName().get());
            }
            this.defaultCacheName = null;
        }
        ModuleRepository moduleRepository = ModuleRepository.newModuleRepository(globalConfiguration.classLoader(), globalConfiguration);
        this.classAllowList = globalConfiguration.serialization().allowList().create();
        this.globalComponentRegistry = new GlobalComponentRegistry(globalConfiguration, this, this.caches.keySet(), moduleRepository, this.configurationManager);
        InternalCacheRegistry internalCacheRegistry = this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        this.globalComponentRegistry.registerComponent(this.cacheDependencyGraph, "org.infinispan.CacheDependencyGraph", false);
        this.authorizer = new Authorizer(globalConfiguration.security(), AuditContext.CACHEMANAGER, globalConfiguration.cacheManagerName(), null);
        this.globalComponentRegistry.registerComponent((Object)this.authorizer, Authorizer.class);
        this.stats = new CacheContainerStatsImpl(this);
        this.globalComponentRegistry.registerComponent((Object)this.stats, CacheContainerStats.class);
        this.health = new HealthImpl(this, this.globalComponentRegistry.getComponent(InternalCacheRegistry.class));
        this.cacheManagerInfo = new CacheManagerInfo(this, this.configurationManager, internalCacheRegistry, this.globalComponentRegistry.getComponent(LocalTopologyManager.class));
        this.globalComponentRegistry.registerComponent((Object)new HealthJMXExposerImpl(this.health), HealthJMXExposer.class);
        this.cacheManagerAdmin = new DefaultCacheManagerAdmin(this, this.authorizer, EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class), null, this.globalComponentRegistry.getComponent(GlobalConfigurationManager.class));
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(String configurationFile) throws IOException {
        this(configurationFile, true);
    }

    public DefaultCacheManager(String configurationFile, boolean start) throws IOException {
        this(FileLookupFactory.newInstance().lookupFileStrict(configurationFile, Thread.currentThread().getContextClassLoader()), start);
    }

    public DefaultCacheManager(InputStream configurationStream) throws IOException {
        this(configurationStream, true);
    }

    public DefaultCacheManager(InputStream configurationStream, boolean start) throws IOException {
        this(new ParserRegistry().parse(configurationStream, ConfigurationResourceResolvers.DEFAULT, MediaType.APPLICATION_XML), start);
    }

    public DefaultCacheManager(URL configurationURL, boolean start) throws IOException {
        this(new ParserRegistry().parse(configurationURL), start);
    }

    public DefaultCacheManager(ConfigurationBuilderHolder holder, boolean start) {
        try {
            this.configurationManager = new ConfigurationManager(holder);
            GlobalConfiguration globalConfiguration = this.configurationManager.getGlobalConfiguration();
            this.classAllowList = globalConfiguration.serialization().allowList().create();
            this.defaultCacheName = globalConfiguration.defaultCacheName().orElse(null);
            ModuleRepository moduleRepository = ModuleRepository.newModuleRepository(globalConfiguration.classLoader(), globalConfiguration);
            this.globalComponentRegistry = new GlobalComponentRegistry(globalConfiguration, this, this.caches.keySet(), moduleRepository, this.configurationManager);
            InternalCacheRegistry internalCacheRegistry = this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
            this.globalComponentRegistry.registerComponent(this.cacheDependencyGraph, "org.infinispan.CacheDependencyGraph", false);
            this.stats = new CacheContainerStatsImpl(this);
            this.globalComponentRegistry.registerComponent((Object)this.stats, CacheContainerStats.class);
            this.health = new HealthImpl(this, internalCacheRegistry);
            this.cacheManagerInfo = new CacheManagerInfo(this, this.getConfigurationManager(), internalCacheRegistry, this.globalComponentRegistry.getComponent(LocalTopologyManager.class));
            this.globalComponentRegistry.registerComponent((Object)new HealthJMXExposerImpl(this.health), HealthJMXExposer.class);
            this.authorizer = new Authorizer(globalConfiguration.security(), AuditContext.CACHEMANAGER, globalConfiguration.cacheManagerName(), null);
            this.globalComponentRegistry.registerComponent((Object)this.authorizer, Authorizer.class);
            this.cacheManagerAdmin = new DefaultCacheManagerAdmin(this, this.authorizer, EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class), null, this.globalComponentRegistry.getComponent(GlobalConfigurationManager.class));
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw new CacheConfigurationException((Exception)re);
        }
        if (start) {
            this.start();
        }
    }

    private DefaultCacheManager(DefaultCacheManager original) {
        this.authorizer = original.authorizer;
        this.cacheManagerInfo = original.cacheManagerInfo;
        this.cacheManagerAdmin = original.cacheManagerAdmin;
        this.classAllowList = original.classAllowList;
        this.defaultCacheName = original.defaultCacheName;
        this.configurationManager = original.configurationManager;
        this.globalComponentRegistry = original.globalComponentRegistry;
        this.health = original.health;
        this.stats = original.stats;
        this.status = original.status;
        this.transport = original.transport;
    }

    @Override
    public Configuration defineConfiguration(String name, Configuration configuration) {
        return this.doDefineConfiguration(name, configuration);
    }

    @Override
    public Configuration defineConfiguration(String name, String template, Configuration configurationOverride) {
        if (template != null) {
            Configuration c = this.configurationManager.getConfiguration(template, true);
            if (c == null) {
                throw Log.CONFIG.undeclaredConfiguration(template, name);
            }
            if (configurationOverride == null) {
                return this.doDefineConfiguration(name, c);
            }
            return this.doDefineConfiguration(name, c, configurationOverride);
        }
        return this.doDefineConfiguration(name, configurationOverride);
    }

    private Configuration doDefineConfiguration(String name, Configuration ... configurations) {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.ADMIN);
        this.assertIsNotTerminated();
        if (name == null || configurations == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if (!ByteString.isValid(name)) {
            throw Log.CONFIG.invalidNameSize(name);
        }
        Configuration existing = this.configurationManager.getConfiguration(name, false);
        if (existing != null) {
            throw Log.CONFIG.configAlreadyDefined(name);
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        boolean template = true;
        for (Configuration configuration : configurations) {
            if (configuration == null) {
                throw new NullPointerException("Null arguments not allowed");
            }
            builder.read(configuration, Combine.DEFAULT);
            template = template && configuration.isTemplate();
        }
        builder.template(template);
        return this.configurationManager.putConfiguration(name, builder);
    }

    @Override
    public void undefineConfiguration(String configurationName) {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.ADMIN);
        Configuration existing = this.configurationManager.getConfiguration(configurationName, false);
        if (existing != null) {
            for (CompletableFuture cacheFuture : this.caches.values()) {
                Cache cache = (Cache)((CompletableFuture)cacheFuture.exceptionally(t -> null)).join();
                if (cache == null || cache.getCacheConfiguration() != existing || cache.getStatus() == ComponentStatus.TERMINATED) continue;
                throw Log.CONFIG.configurationInUse(configurationName);
            }
            this.configurationManager.removeConfiguration(configurationName);
            this.globalComponentRegistry.removeCache(configurationName);
        }
    }

    @Override
    public <K, V> Cache<K, V> createCache(String name, Configuration configuration) {
        this.defineConfiguration(name, configuration);
        return this.getCache(name);
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        if (this.defaultCacheName == null) {
            throw Log.CONFIG.noDefaultCache();
        }
        return this.internalGetCache(this.defaultCacheName);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.internalGetCache(cacheName);
    }

    private <K, V> Cache<K, V> internalGetCache(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        this.assertIsNotTerminated();
        if (getCacheBlockingCheck != null) {
            if (cacheName.equals(getCacheBlockingCheck.get())) {
                getCacheBlockingCheck.set(null);
            } else {
                BlockHoundUtil.pretendBlock();
            }
        }
        this.internalStart(false);
        CompletableFuture cacheFuture = (CompletableFuture)this.caches.get(cacheName);
        if (cacheFuture != null) {
            try {
                return (Cache)cacheFuture.join();
            }
            catch (CompletionException e) {
                this.caches.computeIfPresent(cacheName, (k, v) -> {
                    if (v == cacheFuture) {
                        return null;
                    }
                    return v;
                });
            }
        }
        return this.createCache(cacheName);
    }

    @Override
    public boolean cacheExists(String cacheName) {
        return this.caches.containsKey(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName, boolean createIfAbsent) {
        boolean cacheExists = this.cacheExists(cacheName);
        if (!cacheExists && !createIfAbsent) {
            return null;
        }
        return this.internalGetCache(cacheName);
    }

    @Override
    public EmbeddedCacheManager startCaches(String ... cacheNames) {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.LIFECYCLE);
        this.internalStart(false);
        HashMap<String, 1> threads = new HashMap<String, 1>(cacheNames.length);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        for (final String cacheName : cacheNames) {
            if (threads.containsKey(cacheName)) continue;
            String threadName = "CacheStartThread," + this.identifierString() + "," + cacheName;
            Thread thread = new Thread(threadName){

                @Override
                public void run() {
                    try {
                        DefaultCacheManager.this.createCache(cacheName);
                    }
                    catch (RuntimeException e) {
                        exception.set(e);
                    }
                    catch (Throwable t) {
                        exception.set(new RuntimeException(t));
                    }
                }
            };
            thread.start();
            threads.put(cacheName, thread);
        }
        try {
            for (Thread thread : threads.values()) {
                thread.join();
            }
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted while waiting for the caches to start");
        }
        RuntimeException runtimeException = exception.get();
        if (runtimeException != null) {
            throw runtimeException;
        }
        return this;
    }

    @Override
    public List<Address> getMembers() {
        Transport t = this.getTransport();
        return t == null ? null : t.getMembers();
    }

    @Override
    public Address getAddress() {
        Transport t = this.getTransport();
        return t == null ? null : t.getAddress();
    }

    @Override
    public Address getCoordinator() {
        Transport t = this.getTransport();
        return t == null ? null : t.getCoordinator();
    }

    @ManagedAttribute(description="The logical address of the cluster's coordinator", displayName="Coordinator address")
    public String getCoordinatorAddress() {
        return this.cacheManagerInfo.getCoordinatorAddress();
    }

    @Override
    @ManagedAttribute(description="Indicates whether this node is coordinator", displayName="Is coordinator?")
    public boolean isCoordinator() {
        return this.cacheManagerInfo.isCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Cache<K, V> createCache(String cacheName) {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(cacheName, trace);
        try {
            Cache<K, V> cache = this.wireAndStartCache(cacheName);
            return cache;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    private <K, V> Cache<K, V> wireAndStartCache(String cacheName) {
        Configuration c = this.configurationManager.getConfiguration(cacheName);
        if (c == null) {
            throw Log.CONFIG.noSuchCacheConfiguration(cacheName);
        }
        if (c.security().authorization().enabled()) {
            this.authorizer.checkPermission(c.security().authorization(), this.getSubject(), AuthorizationPermission.LIFECYCLE, null);
        }
        if (c.isTemplate()) {
            throw Log.CONFIG.templateConfigurationStartAttempt(cacheName);
        }
        CompletableFuture cacheFuture = new CompletableFuture();
        CompletableFuture oldFuture = this.caches.computeIfAbsent(cacheName, name -> {
            this.assertIsNotTerminated();
            return cacheFuture;
        });
        Cache cache = null;
        try {
            if (oldFuture != cacheFuture && !(cache = (Cache)oldFuture.join()).getStatus().isTerminated()) {
                return cache;
            }
        }
        catch (CompletionException ce) {
            throw (CacheException)ce.getCause();
        }
        try {
            boolean needToNotifyCacheStarted;
            ComponentRegistry cr;
            log.debugf("Creating cache %s on %s", cacheName, this.identifierString());
            if (cache == null && (cache = new InternalCacheFactory().createCache(c, this.globalComponentRegistry, cacheName)).getAdvancedCache().getAuthorizationManager() != null) {
                cache = new SecureCacheImpl(cache.getAdvancedCache());
            }
            boolean notStartedYet = (cr = ComponentRegistry.of(SecurityActions.getUnwrappedCache(cache))).getStatus() != ComponentStatus.RUNNING && cr.getStatus() != ComponentStatus.INITIALIZING;
            cache.start();
            cacheFuture.complete(cache);
            boolean bl = needToNotifyCacheStarted = notStartedYet && cr.getStatus() == ComponentStatus.RUNNING;
            if (needToNotifyCacheStarted) {
                this.globalComponentRegistry.notifyCacheStarted(cacheName);
            }
            log.tracef("Cache %s is ready", cacheName);
            return cache;
        }
        catch (CacheException e) {
            cacheFuture.completeExceptionally(e);
            throw e;
        }
        catch (Throwable t) {
            cacheFuture.completeExceptionally(new CacheException(t));
            throw t;
        }
    }

    public void start() {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.LIFECYCLE);
        this.internalStart(true);
    }

    private void internalStart(boolean block) {
        if (this.status == ComponentStatus.RUNNING) {
            return;
        }
        GlobalConfiguration globalConfiguration = this.configurationManager.getGlobalConfiguration();
        this.lifecycleLock.lock();
        try {
            while (block && this.status == ComponentStatus.INITIALIZING) {
                this.lifecycleCondition.await();
            }
            if (this.status != ComponentStatus.INSTANTIATED) {
                return;
            }
            log.debugf("Starting cache manager %s", this.identifierString());
            this.initializeSecurity(globalConfiguration);
            this.updateStatus(ComponentStatus.INITIALIZING);
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted waiting for the cache manager to start");
        }
        finally {
            this.lifecycleLock.unlock();
        }
        try {
            this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).start();
            this.globalComponentRegistry.start();
            log.debugf("Started cache manager %s", this.identifierString());
        }
        catch (Exception e) {
            throw new EmbeddedCacheManagerStartupException(e);
        }
        finally {
            this.updateStatus(this.globalComponentRegistry.getStatus());
        }
    }

    private void initializeSecurity(GlobalConfiguration globalConfiguration) {
        GlobalAuthorizationConfiguration authorizationConfig = globalConfiguration.security().authorization();
        if (authorizationConfig.enabled()) {
            AuthorizationMapperContextImpl context = new AuthorizationMapperContextImpl(this);
            authorizationConfig.principalRoleMapper().setContext(context);
            authorizationConfig.rolePermissionMapper().setContext(context);
        }
    }

    private void updateStatus(ComponentStatus status) {
        this.lifecycleLock.lock();
        try {
            this.status = status;
            this.lifecycleCondition.signalAll();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    private void terminate(String cacheName) {
        CompletableFuture cacheFuture = (CompletableFuture)this.caches.get(cacheName);
        if (cacheFuture != null) {
            Cache cache = (Cache)cacheFuture.join();
            if (cache.getStatus().isTerminated()) {
                log.tracef("Ignoring cache %s, it is already terminated.", cacheName);
                return;
            }
            cache.stop();
        }
    }

    public void shutdownAllCaches() {
        log.tracef("Attempting to shutdown cache manager: " + String.valueOf(this.getAddress()), new Object[0]);
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.LIFECYCLE);
        LinkedHashSet<String> cachesToShutdown = new LinkedHashSet<String>(this.caches.size());
        try {
            List<String> ordered = this.cacheDependencyGraph.topologicalSort();
            cachesToShutdown.addAll(ordered);
        }
        catch (CyclicDependencyException e) {
            Log.CONTAINER.stopOrderIgnored();
        }
        cachesToShutdown.addAll(this.caches.keySet());
        log.tracef("Cache shutdown order: %s", cachesToShutdown);
        for (String cacheName : cachesToShutdown) {
            try {
                CompletableFuture cacheFuture = (CompletableFuture)this.caches.get(cacheName);
                if (cacheFuture == null) continue;
                Cache cache = (Cache)cacheFuture.join();
                if (cache.getStatus().isTerminated()) {
                    log.tracef("Ignoring cache %s, it is already terminated.", cacheName);
                    continue;
                }
                cache.shutdown();
            }
            catch (Throwable t) {
                Log.CONTAINER.componentFailedToStop(t);
            }
        }
    }

    public void stop() {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.LIFECYCLE);
        this.internalStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStop() {
        this.lifecycleLock.lock();
        String identifierString = this.identifierString();
        try {
            while (this.status == ComponentStatus.STOPPING) {
                this.lifecycleCondition.await();
            }
            if (!this.status.stopAllowed()) {
                log.trace("Ignore call to stop as the cache manager is not running");
                return;
            }
            log.debugf("Stopping cache manager %s", identifierString);
            this.updateStatus(ComponentStatus.STOPPING);
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted waiting for the cache manager to stop");
        }
        finally {
            this.lifecycleLock.unlock();
        }
        try {
            log.debugf("Starting shutdown of caches at %s", identifierString);
            this.stopCaches();
        }
        catch (Throwable t) {
            log.errorf(t, "Exception during shutdown of caches. Proceeding...", new Object[0]);
        }
        try {
            log.debugf("Starting JMX shutdown at %s", identifierString);
            this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).stop();
        }
        catch (Throwable t) {
            log.errorf(t, "Exception during JMX shutdown. Proceeding...", new Object[0]);
        }
        try {
            this.globalComponentRegistry.stop();
            log.debugf("Stopped cache manager %s", identifierString);
        }
        finally {
            this.updateStatus(ComponentStatus.TERMINATED);
        }
    }

    private void stopCaches() {
        LinkedHashSet<String> cachesToStop = new LinkedHashSet<String>(this.caches.size());
        try {
            List<String> ordered = this.cacheDependencyGraph.topologicalSort();
            cachesToStop.addAll(ordered);
        }
        catch (CyclicDependencyException e) {
            Log.CONTAINER.stopOrderIgnored();
        }
        cachesToStop.addAll(this.caches.keySet());
        log.tracef("Cache stop order: %s", cachesToStop);
        for (String cacheName : cachesToStop) {
            try {
                this.terminate(cacheName);
            }
            catch (Throwable t) {
                Log.CONTAINER.componentFailedToStop(t);
            }
        }
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener) {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.LISTEN);
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        return notifier.addListenerAsync(listener);
    }

    @Override
    public CompletionStage<Void> removeListenerAsync(Object listener) {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.LISTEN);
        try {
            CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
            return notifier.removeListenerAsync(listener);
        }
        catch (IllegalLifecycleStateException e) {
            return CompletableFutures.completedNull();
        }
    }

    @Override
    public ComponentStatus getStatus() {
        return this.status;
    }

    @Override
    public GlobalConfiguration getCacheManagerConfiguration() {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.ADMIN);
        return this.configurationManager.getGlobalConfiguration();
    }

    @Override
    public Configuration getDefaultCacheConfiguration() {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.ADMIN);
        if (this.defaultCacheName != null) {
            return this.configurationManager.getConfiguration(this.defaultCacheName, true);
        }
        return null;
    }

    @Override
    public Configuration getCacheConfiguration(String name) {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.ADMIN);
        Configuration configuration = this.configurationManager.getConfiguration(name, true);
        if (configuration == null && this.cacheExists(name)) {
            return this.getDefaultCacheConfiguration();
        }
        return configuration;
    }

    public Set<String> getCacheNames() {
        TreeSet<String> names = new TreeSet<String>(this.configurationManager.getDefinedCaches());
        names.addAll(this.caches.keySet());
        InternalCacheRegistry internalCacheRegistry = this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.filterPrivateCaches(names);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    @Override
    public Set<String> getAccessibleCacheNames() {
        if (this.configurationManager.getGlobalConfiguration().security().authorization().enabled()) {
            TreeSet<String> names = new TreeSet<String>();
            GlobalSecurityManager gsm = this.globalComponentRegistry.getComponent(GlobalSecurityManager.class);
            for (String name : this.configurationManager.getDefinedCaches()) {
                Configuration cfg = this.configurationManager.getConfiguration(name);
                AuthorizationManagerImpl am = new AuthorizationManagerImpl();
                am.init(name, this.configurationManager.getGlobalConfiguration(), cfg, gsm);
                if (am.getPermissions(Security.getSubject()).isEmpty()) continue;
                names.add(name);
            }
            InternalCacheRegistry internalCacheRegistry = this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
            internalCacheRegistry.filterPrivateCaches(names);
            return names;
        }
        return this.getCacheNames();
    }

    @Override
    public Set<String> getCacheConfigurationNames() {
        return this.cacheManagerInfo.getCacheConfigurationNames();
    }

    @Override
    public boolean isRunning(String cacheName) {
        CompletableFuture cacheFuture;
        if (getCacheBlockingCheck != null) {
            getCacheBlockingCheck.set(cacheName);
        }
        boolean started = (cacheFuture = (CompletableFuture)this.caches.get(cacheName)) != null && cacheFuture.isDone() && !cacheFuture.isCompletedExceptionally();
        return started && ((Cache)cacheFuture.join()).getStatus() == ComponentStatus.RUNNING;
    }

    @Override
    public boolean isDefaultRunning() {
        Optional<String> defaultCacheName = this.configurationManager.getGlobalConfiguration().defaultCacheName();
        return defaultCacheName.isPresent() && this.isRunning(defaultCacheName.get());
    }

    @ManagedAttribute(description="The status of the cache manager instance.", displayName="Cache manager status", dataType=DataType.TRAIT)
    public String getCacheManagerStatus() {
        return this.cacheManagerInfo.getCacheManagerStatus();
    }

    @ManagedAttribute(description="The defined cache names and their statuses.  The default cache is not included in this representation.", displayName="List of defined caches", dataType=DataType.TRAIT)
    public String getDefinedCacheNames() {
        StringJoiner stringJoiner = new StringJoiner("", "[", "]");
        this.cacheManagerInfo.getDefinedCaches().forEach(c -> stringJoiner.add(c.name).add(c.isStarted() ? "(created)" : "(not created)"));
        return stringJoiner.toString();
    }

    @ManagedAttribute(description="The defined cache configuration names.", displayName="List of defined cache configurations", dataType=DataType.TRAIT)
    public String getDefinedCacheConfigurationNames() {
        StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
        this.cacheManagerInfo.getCacheConfigurationNames().forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    @ManagedAttribute(description="The total number of defined cache configurations.", displayName="Number of caches defined")
    public String getDefinedCacheCount() {
        return String.valueOf(this.getNumberOfCacheConfigurations());
    }

    @ManagedAttribute(description="The total number of defined cache configurations.", displayName="Number of caches defined")
    public int getNumberOfCacheConfigurations() {
        return this.getCacheConfigurationNames().size();
    }

    @ManagedAttribute(description="The total number of created caches, including the default cache.", displayName="Number of caches created")
    public String getCreatedCacheCount() {
        return String.valueOf(this.getNumberOfCreatedCaches());
    }

    @ManagedAttribute(description="The total number of created caches, including the default cache.", displayName="Number of caches created")
    public long getNumberOfCreatedCaches() {
        return this.cacheManagerInfo.getCreatedCacheCount();
    }

    @ManagedAttribute(description="The total number of running caches, including the default cache.", displayName="Number of running caches")
    public String getRunningCacheCount() {
        return String.valueOf(this.getNumberOfRunningCaches());
    }

    @ManagedAttribute(description="The total number of running caches, including the default cache.", displayName="Number of running caches")
    public long getNumberOfRunningCaches() {
        return this.cacheManagerInfo.getRunningCacheCount();
    }

    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT)
    public String getVersion() {
        return this.cacheManagerInfo.getVersion();
    }

    @ManagedAttribute(description="The name of this cache manager", displayName="Cache manager name", dataType=DataType.TRAIT)
    public String getName() {
        return this.cacheManagerInfo.getName();
    }

    @ManagedOperation(description="Starts the default cache associated with this cache manager", displayName="Starts the default cache")
    public void startCache() {
        if (this.defaultCacheName == null) {
            throw Log.CONFIG.noDefaultCache();
        }
        this.startCache(this.defaultCacheName);
    }

    @ManagedOperation(description="Starts a named cache from this cache manager", name="startCache", displayName="Starts a cache with the given name")
    public void startCache(@Parameter(name="cacheName", description="Name of cache to start") String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        this.assertIsNotTerminated();
        this.internalStart(false);
        CompletableFuture cacheFuture = (CompletableFuture)this.caches.get(cacheName);
        if (cacheFuture != null) {
            try {
                Cache cache = (Cache)cacheFuture.join();
                if (!cache.getStatus().isTerminated()) {
                    return;
                }
            }
            catch (CompletionException e) {
                throw (CacheException)e.getCause();
            }
        }
        this.createCache(cacheName);
    }

    @ManagedAttribute(description="The network address associated with this instance", displayName="Network address", dataType=DataType.TRAIT)
    public String getNodeAddress() {
        return this.cacheManagerInfo.getNodeAddress();
    }

    @ManagedAttribute(description="The physical network addresses associated with this instance", displayName="Physical network addresses", dataType=DataType.TRAIT)
    public String getPhysicalAddresses() {
        return this.cacheManagerInfo.getPhysicalAddresses();
    }

    @ManagedAttribute(description="List of members in the cluster", displayName="Cluster members", dataType=DataType.TRAIT)
    public String getClusterMembers() {
        List<String> clusterMembers = this.cacheManagerInfo.getClusterMembers();
        return clusterMembers.size() == 1 ? clusterMembers.iterator().next() : clusterMembers.toString();
    }

    @ManagedAttribute(description="List of members in the cluster", displayName="Cluster members", dataType=DataType.TRAIT)
    public String getClusterMembersPhysicalAddresses() {
        return this.cacheManagerInfo.getClusterMembersPhysicalAddresses().toString();
    }

    @ManagedAttribute(description="Size of the cluster in number of nodes", displayName="Cluster size")
    public int getClusterSize() {
        return this.cacheManagerInfo.getClusterSize();
    }

    @Override
    @ManagedAttribute(description="Cluster name", displayName="Cluster name", dataType=DataType.TRAIT)
    public String getClusterName() {
        return this.cacheManagerInfo.getClusterName();
    }

    @ManagedAttribute(description="Returns the local site name", displayName="Local site name", dataType=DataType.TRAIT)
    public String getSite() {
        return this.cacheManagerInfo.getLocalSite();
    }

    @ManagedAttribute(description="Lists all online sites", displayName="Online Sites", dataType=DataType.TRAIT)
    public String getSiteView() {
        return String.valueOf(this.cacheManagerInfo.getSites());
    }

    @ManagedAttribute(description="Indicates whether this node is a relay node", displayName="Is relay node?", dataType=DataType.TRAIT)
    public boolean isRelayNode() {
        return this.cacheManagerInfo.isRelayNode();
    }

    @ManagedAttribute(description="Lists relay nodes in the local site", displayName="Relay nodes", dataType=DataType.TRAIT)
    public String getRelayNodesAddress() {
        return String.valueOf(this.cacheManagerInfo.getRelayNodesAddress());
    }

    String getLogicalAddressString() {
        return this.getAddress() == null ? "local" : this.getAddress().toString();
    }

    private void assertIsNotTerminated() {
        if (this.status == ComponentStatus.STOPPING || this.status == ComponentStatus.TERMINATED || this.status == ComponentStatus.FAILED) {
            throw new IllegalLifecycleStateException("Cache container has been stopped and cannot be reused. Recreate the cache container.");
        }
    }

    private Transport getTransport() {
        if (this.transport == null) {
            this.lifecycleLock.lock();
            try {
                if (this.transport == null && (this.status == ComponentStatus.RUNNING || this.status == ComponentStatus.INITIALIZING)) {
                    this.transport = this.globalComponentRegistry.getComponent(Transport.class);
                }
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
        return this.transport;
    }

    @Override
    public void addCacheDependency(String from, String to) {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.ADMIN);
        this.cacheDependencyGraph.addDependency(from, to);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.identifierString();
    }

    private String identifierString() {
        if (this.getAddress() != null) {
            return this.getAddress().toString();
        }
        if (this.configurationManager.getGlobalConfiguration().transport().nodeName() != null) {
            return this.configurationManager.getGlobalConfiguration().transport().nodeName();
        }
        return this.configurationManager.getGlobalConfiguration().cacheManagerName();
    }

    @ManagedAttribute(description="Global configuration properties", displayName="Global configuration properties", dataType=DataType.TRAIT)
    public Properties getGlobalConfigurationAsProperties() {
        return new PropertyFormatter().format(this.configurationManager.getGlobalConfiguration());
    }

    @Override
    public CacheContainerStats getStats() {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.MONITOR);
        return this.stats;
    }

    @Override
    public Health getHealth() {
        return this.health;
    }

    @Override
    public CacheManagerInfo getCacheManagerInfo() {
        return this.cacheManagerInfo;
    }

    @Override
    public ClusterExecutor executor() {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.EXEC);
        if (this.globalComponentRegistry.getStatus() != ComponentStatus.RUNNING && this.globalComponentRegistry.getStatus() != ComponentStatus.INITIALIZING) {
            throw new IllegalStateException("CacheManager must be started before retrieving a ClusterExecutor!");
        }
        Executor blockingExecutor = this.globalComponentRegistry.getComponent(ExecutorService.class, "org.infinispan.executors.blocking");
        Transport transport = this.globalComponentRegistry.getComponent(BasicComponentRegistry.class).getComponent(Transport.class).running();
        if (transport != null) {
            long time = this.configurationManager.getGlobalConfiguration().transport().distributedSyncTimeout();
            return ClusterExecutors.allSubmissionExecutor(null, this, transport, time, TimeUnit.MILLISECONDS, blockingExecutor, this.globalComponentRegistry.getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout"));
        }
        return ClusterExecutors.allSubmissionExecutor(null, this, null, (Long)TransportConfiguration.DISTRIBUTED_SYNC_TIMEOUT.getDefaultValue(), TimeUnit.MILLISECONDS, blockingExecutor, this.globalComponentRegistry.getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout"));
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    @Override
    public ClassAllowList getClassWhiteList() {
        return this.getClassAllowList();
    }

    @Override
    public ClassAllowList getClassAllowList() {
        return this.classAllowList;
    }

    @Override
    public EmbeddedCacheManagerAdmin administration() {
        return this.cacheManagerAdmin;
    }

    ConcurrentMap<String, CompletableFuture<Cache<?, ?>>> getCaches() {
        return this.caches;
    }

    ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    @Override
    public Subject getSubject() {
        return null;
    }

    @Override
    public EmbeddedCacheManager withSubject(final Subject subject) {
        if (subject == null) {
            return this;
        }
        return new DefaultCacheManager(this){

            @Override
            public EmbeddedCacheManager withSubject(Subject subject2) {
                throw new IllegalArgumentException("Cannot set a Subject on an EmbeddedCacheManager more than once");
            }

            @Override
            public Subject getSubject() {
                return subject;
            }
        };
    }

    @Override
    protected GlobalComponentRegistry globalComponentRegistry() {
        this.authorizer.checkPermission(this.getSubject(), AuthorizationPermission.ADMIN);
        return this.globalComponentRegistry;
    }

    static void enableGetCacheBlockingCheck() {
        getCacheBlockingCheck = new ThreadLocal();
    }
}

