/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.FlagContainer;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AtomicHashMapProxy<K, V>
extends AutoBatchSupport
implements AtomicMap<K, V> {
    private static final Log log = LogFactory.getLog(AtomicHashMapProxy.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final Object deltaMapKey;
    protected final AdvancedCache cache;
    protected volatile boolean startedReadingMap = false;
    protected final FlagContainer flagContainer;
    protected TransactionTable transactionTable;
    protected TransactionManager transactionManager;

    AtomicHashMapProxy(AdvancedCache<?, ?> cache, Object deltaMapKey) {
        this(cache, deltaMapKey, null);
    }

    AtomicHashMapProxy(AdvancedCache<?, ?> cache, Object deltaMapKey, FlagContainer flagContainer) {
        this.cache = cache;
        this.deltaMapKey = deltaMapKey;
        this.batchContainer = cache.getBatchContainer();
        this.flagContainer = flagContainer;
        this.transactionTable = cache.getComponentRegistry().getComponent(TransactionTable.class);
        this.transactionManager = cache.getTransactionManager();
    }

    protected AtomicHashMap<K, V> toMap(Object object) {
        Object map = object instanceof MarshalledValue ? ((MarshalledValue)object).get() : object;
        return (AtomicHashMap)map;
    }

    protected AtomicHashMap<K, V> getDeltaMapForRead() {
        AtomicHashMap<K, V> ahm = this.toMap(this.cache.get(this.deltaMapKey));
        if (ahm != null && !this.startedReadingMap) {
            this.startedReadingMap = true;
        }
        this.assertValid(ahm);
        return ahm;
    }

    protected CacheEntry lookupEntryFromCurrentTransaction() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            LocalTransaction localTransaction = tx == null ? null : this.transactionTable.getLocalTransaction(tx);
            return localTransaction == null ? null : localTransaction.lookupEntry(this.deltaMapKey);
        }
        catch (SystemException e) {
            return null;
        }
    }

    protected AtomicHashMap<K, V> getDeltaMapForWrite() {
        AtomicHashMap<K, V> map;
        boolean suppressLocks;
        boolean lockedAndCopied;
        CacheEntry lookedUpEntry = this.lookupEntryFromCurrentTransaction();
        boolean bl = lockedAndCopied = lookedUpEntry != null && lookedUpEntry.isChanged() && this.toMap((Object)lookedUpEntry.getValue()).copied;
        if (lockedAndCopied) {
            return this.getDeltaMapForRead();
        }
        boolean bl2 = suppressLocks = this.flagContainer != null && this.flagContainer.hasFlag(Flag.SKIP_LOCKING);
        if (!suppressLocks && this.flagContainer != null) {
            this.flagContainer.setFlags(Flag.FORCE_WRITE_LOCK);
        }
        if (trace) {
            if (suppressLocks) {
                log.trace("Skip locking flag used.  Skipping locking.");
            } else {
                log.trace("Forcing write lock even for reads");
            }
        }
        if (suppressLocks) {
            this.flagContainer.setFlags(Flag.SKIP_LOCKING);
        }
        AtomicHashMap<K, V> copy = (map = this.getDeltaMapForRead()) == null ? new AtomicHashMap<K, V>(true) : map.copyForWrite();
        copy.initForWriting();
        this.cache.put(this.deltaMapKey, copy);
        return copy;
    }

    protected void assertValid(AtomicHashMap<?, ?> map) {
        if (this.startedReadingMap && (map == null || map.removed)) {
            throw new IllegalStateException("AtomicMap stored under key " + this.deltaMapKey + " has been concurrently removed!");
        }
    }

    @Override
    public Set<K> keySet() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Override
    public Collection<V> values() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? Collections.emptySet() : map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? Collections.emptySet() : map.entrySet();
    }

    @Override
    public int size() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? 0 : map.size();
    }

    @Override
    public boolean isEmpty() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null || map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map != null && map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map != null && map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? null : (V)map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        try {
            this.startAtomic();
            AtomicHashMap<K, V> deltaMapForWrite = this.getDeltaMapForWrite();
            V v = deltaMapForWrite.put(key, value);
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        try {
            this.startAtomic();
            AtomicHashMap<K, V> deltaMapForWrite = this.getDeltaMapForWrite();
            V v = deltaMapForWrite.remove(key);
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        try {
            this.startAtomic();
            AtomicHashMap<? extends K, ? extends V> deltaMapForWrite = this.getDeltaMapForWrite();
            deltaMapForWrite.putAll(m);
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.startAtomic();
            AtomicHashMap<K, V> deltaMapForWrite = this.getDeltaMapForWrite();
            deltaMapForWrite.clear();
        }
        finally {
            this.endAtomic();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AtomicHashMapProxy{deltaMapKey=");
        sb.append(this.deltaMapKey);
        sb.append("}");
        return sb.toString();
    }
}

