/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cacheviews;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.CacheException;
import org.infinispan.cacheviews.CacheView;
import org.infinispan.cacheviews.CacheViewInfo;
import org.infinispan.cacheviews.CacheViewListener;
import org.infinispan.cacheviews.CacheViewsManager;
import org.infinispan.cacheviews.PendingCacheViewChanges;
import org.infinispan.commands.control.CacheViewControlCommand;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.MembershipArithmetic;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheViewsManagerImpl
implements CacheViewsManager {
    private static final Log log = LogFactory.getLog(CacheViewsManagerImpl.class);
    public static final String DUMMY_CACHE_NAME_FOR_GLOBAL_COMMANDS = "__dummy_cache_name_for_global_commands__";
    private CacheManagerNotifier cacheManagerNotifier;
    private Transport transport;
    private volatile boolean running = false;
    private volatile List<Address> members;
    private volatile Address self;
    private volatile Address coordinator;
    private volatile boolean isCoordinator;
    private volatile boolean shouldRecoverViews;
    private final ConcurrentMap<String, CacheViewInfo> viewsInfo = new ConcurrentHashMap<String, CacheViewInfo>();
    private long timeout = 10000L;
    private long viewChangeCooldown = 1000L;
    private ViewListener listener = new ViewListener();
    private ViewTriggerThread viewTriggerThread;
    private ExecutorService cacheViewInstallerExecutor;
    private ExecutorService asyncTransportExecutor;

    @Inject
    public void init(CacheManagerNotifier cacheManagerNotifier, Transport transport, @ComponentName(value="org.infinispan.executors.transport") ExecutorService e, GlobalConfiguration globalConfiguration) {
        this.cacheManagerNotifier = cacheManagerNotifier;
        this.transport = transport;
        this.asyncTransportExecutor = e;
        this.timeout = globalConfiguration.getDistributedSyncTimeout();
    }

    @Start(priority=11)
    public void start() throws Exception {
        if (this.transport == null) {
            throw new ConfigurationException("CacheViewManager only works in clustered caches");
        }
        this.self = this.transport.getAddress();
        this.running = true;
        ThreadFactory tfViewInstaller = new ThreadFactory(){
            private volatile AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "CacheViewInstaller-" + this.count.incrementAndGet() + "," + CacheViewsManagerImpl.this.self);
            }
        };
        this.cacheViewInstallerExecutor = Executors.newCachedThreadPool(tfViewInstaller);
        this.viewTriggerThread = new ViewTriggerThread();
        this.cacheManagerNotifier.addListener(this.listener);
        this.handleNewView(this.transport.getMembers(), false, true);
    }

    @Stop(priority=0)
    public void stop() {
        this.cacheManagerNotifier.removeListener(this.listener);
        this.running = false;
        this.viewTriggerThread.interrupt();
        this.cacheViewInstallerExecutor.shutdown();
        try {
            this.viewTriggerThread.join(this.timeout);
            if (this.viewTriggerThread.isAlive()) {
                log.debugf("The cache view trigger thread did not stop in %d millis", this.timeout);
            }
            this.viewTriggerThread = null;
            this.cacheViewInstallerExecutor.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CacheView getCommittedView(String cacheName) {
        return ((CacheViewInfo)this.viewsInfo.get(cacheName)).getCommittedView();
    }

    @Override
    public CacheView getPendingView(String cacheName) {
        return ((CacheViewInfo)this.viewsInfo.get(cacheName)).getPendingView();
    }

    @Override
    public Set<Address> getLeavers(String cacheName) {
        return ((CacheViewInfo)this.viewsInfo.get(cacheName)).getPendingChanges().getLeavers();
    }

    @Override
    public void join(String cacheName, CacheViewListener listener) throws Exception {
        CacheViewInfo cacheViewInfo = this.getCacheViewInfo(cacheName);
        cacheViewInfo.setListener(listener);
        this.handleRequestJoin(this.self, cacheName);
        if (!this.isCoordinator) {
            CacheViewControlCommand cmd = new CacheViewControlCommand(cacheName, CacheViewControlCommand.Type.REQUEST_JOIN, this.self);
            Map<Address, Response> rspList = this.transport.invokeRemotely(Collections.singleton(this.coordinator), cmd, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, this.timeout, false, null, false);
            this.checkRemoteResponse(cacheName, cmd, rspList);
        }
    }

    @Override
    public void leave(String cacheName) {
        log.tracef("Stopping local cache %s", cacheName);
        try {
            ((CacheViewInfo)this.viewsInfo.get(cacheName)).setListener(null);
            this.handleRequestLeave(this.self, cacheName);
            CacheViewControlCommand cmd = new CacheViewControlCommand(cacheName, CacheViewControlCommand.Type.REQUEST_LEAVE, this.self);
            this.transport.invokeRemotely(this.members, cmd, ResponseMode.ASYNCHRONOUS, this.timeout, false, null, false);
        }
        catch (Exception e) {
            log.debugf(e, "%s: Error while leaving cache view", cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clusterInstallView(String cacheName, CacheView newView) throws Exception {
        CacheViewInfo cacheViewInfo = (CacheViewInfo)this.viewsInfo.get(cacheName);
        boolean success = false;
        try {
            log.debugf("Installing new view %s for cache %s", newView, cacheName);
            this.clusterPrepareView(cacheName, newView);
            success = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            log.cacheViewPrepareFailure(t, newView, cacheName, cacheViewInfo.getCommittedView());
        }
        finally {
            if (!this.isRunning()) {
                return false;
            }
            if (success) {
                this.clusterCommitView(cacheName, newView.getViewId(), newView.getMembers(), true);
                log.debugf("Successfully installed view %s for cache %s", newView, cacheName);
            } else {
                CacheView previousCommittedView = cacheViewInfo.getCommittedView();
                this.clusterRollbackView(cacheName, previousCommittedView.getViewId(), newView.getMembers(), true);
                log.debugf("Rolled back to view %s for cache %s", previousCommittedView, cacheName);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheView clusterPrepareView(String cacheName, final CacheView pendingView) throws Exception {
        CacheViewInfo cacheViewInfo = (CacheViewInfo)this.viewsInfo.get(cacheName);
        CacheView committedView = cacheViewInfo.getCommittedView();
        log.tracef("%s: Preparing view %d on members %s", cacheName, pendingView.getViewId(), pendingView.getMembers());
        final CacheViewControlCommand cmd = new CacheViewControlCommand(cacheName, CacheViewControlCommand.Type.PREPARE_VIEW, this.self, pendingView.getViewId(), pendingView.getMembers(), committedView.getViewId(), committedView.getMembers());
        Set<Address> leavers = cacheViewInfo.getPendingChanges().getLeavers();
        if (pendingView.containsAny(leavers)) {
            throw new IllegalStateException("Cannot prepare view " + pendingView + ", some nodes already left the cluster: " + leavers);
        }
        Future<Map<Address, Response>> future = this.asyncTransportExecutor.submit(new Callable<Map<Address, Response>>(){

            @Override
            public Map<Address, Response> call() throws Exception {
                Map<Address, Response> rspList = CacheViewsManagerImpl.this.transport.invokeRemotely(pendingView.getMembers(), cmd, ResponseMode.SYNCHRONOUS, CacheViewsManagerImpl.this.timeout, false, null, false);
                return rspList;
            }
        });
        try {
            this.handlePrepareView(cacheName, pendingView, committedView);
        }
        finally {
            Map<Address, Response> rspList = future.get(this.timeout, TimeUnit.MILLISECONDS);
            this.checkRemoteResponse(cacheName, cmd, rspList);
        }
        return pendingView;
    }

    private void clusterRollbackView(String cacheName, int committedViewId, List<Address> targets, boolean includeCoordinator) {
        CacheViewInfo cacheViewInfo = (CacheViewInfo)this.viewsInfo.get(cacheName);
        int newViewId = cacheViewInfo.getPendingChanges().getRollbackViewId();
        ArrayList<Address> validTargets = new ArrayList<Address>(targets);
        validTargets.removeAll(cacheViewInfo.getPendingChanges().getLeavers());
        log.tracef("%s: Rolling back to cache view %d on members %s, new view id is %d", new Object[]{cacheName, committedViewId, validTargets, newViewId});
        try {
            CacheViewControlCommand cmd = new CacheViewControlCommand(cacheName, CacheViewControlCommand.Type.ROLLBACK_VIEW, this.self, newViewId, null, committedViewId, null);
            Map<Address, Response> rspList = this.transport.invokeRemotely(validTargets, cmd, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, this.timeout, false, null, false);
            this.checkRemoteResponse(cacheName, cmd, rspList);
        }
        catch (Throwable t) {
            log.cacheViewRollbackFailure(t, committedViewId, cacheName);
        }
        if (includeCoordinator || validTargets.contains(this.self)) {
            try {
                this.handleRollbackView(cacheName, newViewId, committedViewId);
            }
            catch (Throwable t) {
                log.cacheViewRollbackFailure(t, committedViewId, cacheName);
            }
        }
    }

    private void clusterCommitView(String cacheName, int viewId, List<Address> targets, boolean includeCoordinator) {
        CacheViewInfo cacheViewInfo = (CacheViewInfo)this.viewsInfo.get(cacheName);
        ArrayList<Address> validTargets = new ArrayList<Address>(targets);
        validTargets.removeAll(cacheViewInfo.getPendingChanges().getLeavers());
        log.tracef("%s: Committing cache view %d on members %s", cacheName, viewId, targets);
        try {
            CacheViewControlCommand cmd = new CacheViewControlCommand(cacheName, CacheViewControlCommand.Type.COMMIT_VIEW, this.self, viewId);
            Map<Address, Response> rspList = this.transport.invokeRemotely(validTargets, cmd, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, this.timeout, false, null, false);
            this.checkRemoteResponse(cacheName, cmd, rspList);
        }
        catch (Throwable t) {
            log.cacheViewCommitFailure(t, viewId, cacheName);
        }
        if (includeCoordinator || validTargets.contains(this.self)) {
            try {
                this.handleCommitView(cacheName, viewId);
            }
            catch (Throwable t) {
                log.cacheViewCommitFailure(t, viewId, cacheName);
            }
        }
    }

    @Override
    public void handleRequestJoin(Address sender, String cacheName) {
        log.debugf("%s: Node %s is joining", cacheName, sender);
        CacheViewInfo cacheViewInfo = this.getCacheViewInfo(cacheName);
        cacheViewInfo.getPendingChanges().requestJoin(sender);
        this.viewTriggerThread.wakeUp();
    }

    private CacheViewInfo getCacheViewInfo(String cacheName) {
        CacheViewInfo oldInfo;
        CacheViewInfo cacheViewInfo = (CacheViewInfo)this.viewsInfo.get(cacheName);
        if (cacheViewInfo == null && (oldInfo = this.viewsInfo.putIfAbsent(cacheName, cacheViewInfo = new CacheViewInfo(cacheName, CacheView.EMPTY_CACHE_VIEW))) != null) {
            cacheViewInfo = oldInfo;
        }
        return cacheViewInfo;
    }

    @Override
    public void handleRequestLeave(Address sender, String cacheName) {
        this.handleLeavers(Collections.singleton(sender), cacheName);
        if (this.isRunning()) {
            this.viewTriggerThread.wakeUp();
        }
    }

    private void handleLeavers(Collection<Address> leavers, String cacheName) {
        CacheViewListener cacheViewListener;
        CacheViewInfo cacheViewInfo = (CacheViewInfo)this.viewsInfo.get(cacheName);
        if (cacheViewInfo == null) {
            return;
        }
        log.tracef("%s: Received leave request from nodes %s", cacheName, leavers);
        if (this.isCoordinator) {
            cacheViewInfo.getPendingChanges().requestLeave(leavers);
        }
        if ((cacheViewListener = cacheViewInfo.getListener()) != null) {
            cacheViewListener.updateLeavers(cacheViewInfo.getPendingChanges().getLeavers());
        }
    }

    @Override
    public void handlePrepareView(String cacheName, CacheView pendingView, CacheView committedView) throws Exception {
        CacheViewInfo cacheViewInfo = (CacheViewInfo)this.viewsInfo.get(cacheName);
        if (cacheViewInfo == null) {
            throw new IllegalStateException(String.format("Received prepare request for cache %s, which is not running", cacheName));
        }
        CacheView lastCommittedView = cacheViewInfo.getCommittedView();
        boolean isLocal = pendingView.contains(this.self);
        if (isLocal || this.isCoordinator) {
            log.tracef("%s: Preparing cache view %s, committed view is %s", cacheName, pendingView, committedView);
            if (lastCommittedView.getViewId() > 0 && lastCommittedView.getViewId() != committedView.getViewId()) {
                log.prepareViewIdMismatch(lastCommittedView, committedView);
            }
            cacheViewInfo.prepareView(pendingView);
        }
        if (isLocal) {
            CacheViewListener cacheViewListener = cacheViewInfo.getListener();
            if (cacheViewListener != null) {
                cacheViewListener.prepareView(pendingView, lastCommittedView);
            } else {
                log.tracef("%s: Received cache view prepare request after the local node has already shut down", cacheName);
            }
        }
    }

    @Override
    public void handleCommitView(String cacheName, int viewId) {
        CacheViewInfo cacheViewInfo = (CacheViewInfo)this.viewsInfo.get(cacheName);
        if (cacheViewInfo == null) {
            log.tracef("Ignoring view commit for unknown cache %s", cacheName);
            return;
        }
        if (cacheViewInfo.hasPendingView()) {
            log.debugf("%s: Committing cache view %d", cacheName, viewId);
            cacheViewInfo.commitView(viewId);
            CacheView committedView = cacheViewInfo.getCommittedView();
            cacheViewInfo.getPendingChanges().resetChanges(committedView);
            CacheViewListener cacheViewListener = cacheViewInfo.getListener();
            boolean isLocal = committedView.contains(this.self);
            if (isLocal && cacheViewListener != null) {
                cacheViewListener.updateLeavers(cacheViewInfo.getPendingChanges().getLeavers());
                cacheViewListener.commitView(viewId);
            }
        } else {
            log.debugf("%s: We don't have a pending view, ignoring commit", cacheName);
        }
    }

    @Override
    public void handleRollbackView(String cacheName, int newViewId, int committedViewId) {
        CacheViewInfo cacheViewInfo = (CacheViewInfo)this.viewsInfo.get(cacheName);
        if (cacheViewInfo == null) {
            log.tracef("Ignoring cache view rollback for unknown cache %s", cacheName);
            return;
        }
        if (cacheViewInfo.hasPendingView()) {
            log.debugf("%s: Rolling back to cache view %d, new view id is %d", cacheName, committedViewId, newViewId);
            cacheViewInfo.rollbackView(newViewId, committedViewId);
            cacheViewInfo.getPendingChanges().resetChanges(cacheViewInfo.getCommittedView());
            CacheViewListener cacheViewListener = cacheViewInfo.getListener();
            if (cacheViewListener != null) {
                cacheViewListener.rollbackView(committedViewId);
            }
        } else {
            log.debugf("%s: We don't have a pending view, ignoring rollback", cacheName);
        }
    }

    @Override
    public Map<String, CacheView> handleRecoverViews() {
        HashMap<String, CacheView> result = new HashMap<String, CacheView>();
        for (CacheViewInfo cacheViewInfo : this.viewsInfo.values()) {
            if (cacheViewInfo.getCommittedView().contains(this.self)) {
                result.put(cacheViewInfo.getCacheName(), cacheViewInfo.getCommittedView());
                continue;
            }
            if (cacheViewInfo.getListener() == null) continue;
            result.put(cacheViewInfo.getCacheName(), CacheView.EMPTY_CACHE_VIEW);
        }
        return result;
    }

    private void handleNewView(List<Address> newMembers, boolean mergeView, boolean initialView) {
        boolean wasCoordinator = this.isCoordinator;
        this.coordinator = this.transport.getCoordinator();
        this.isCoordinator = this.transport.isCoordinator();
        if (this.isCoordinator && (mergeView || !wasCoordinator && !initialView)) {
            this.shouldRecoverViews = true;
            log.tracef("Node %s has become the coordinator", this.self);
        }
        this.members = newMembers;
        this.viewTriggerThread.wakeUp();
    }

    private void checkRemoteResponse(String cacheName, CacheViewControlCommand cmd, Map<Address, Response> rspList) {
        boolean success = true;
        for (Map.Entry<Address, Response> response : rspList.entrySet()) {
            if (response.getValue() == null || response.getValue().isSuccessful()) continue;
            success = false;
            log.debugf("%s: Received unsuccessful response from node %s: %s", cacheName, response.getKey(), response.getValue());
        }
        if (!success) {
            throw new CacheException(String.format("Error executing command %s remotely", cmd));
        }
    }

    private void recoverViews() {
        try {
            log.debugf("Node %s is the new coordinator, recovering cache views", this.self);
            final HashMap<Address, Map> recoveryInfo = new HashMap<Address, Map>();
            recoveryInfo.put(this.self, this.handleRecoverViews());
            CacheViewControlCommand cmd = new CacheViewControlCommand(DUMMY_CACHE_NAME_FOR_GLOBAL_COMMANDS, CacheViewControlCommand.Type.RECOVER_VIEW, this.self);
            Map<Address, Response> rspList = this.transport.invokeRemotely(null, cmd, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, this.timeout, true, null, false);
            this.checkRemoteResponse(null, cmd, rspList);
            for (Map.Entry<Address, Response> e : rspList.entrySet()) {
                SuccessfulResponse value = (SuccessfulResponse)e.getValue();
                recoveryInfo.put(e.getKey(), (Map)value.getResponseValue());
            }
            HashSet cacheNames = new HashSet();
            for (Map m : recoveryInfo.values()) {
                cacheNames.addAll(m.keySet());
            }
            for (final String cacheName : cacheNames) {
                CacheViewInfo cacheViewInfo = this.getCacheViewInfo(cacheName);
                ArrayList<Address> recoveredMembers = new ArrayList<Address>(recoveryInfo.size());
                ArrayList<Address> recoveredJoiners = new ArrayList<Address>(recoveryInfo.size());
                for (Map.Entry nodeRecoveryInfo : recoveryInfo.entrySet()) {
                    Address node = (Address)nodeRecoveryInfo.getKey();
                    CacheView lastCommittedView = (CacheView)((Map)nodeRecoveryInfo.getValue()).get(cacheName);
                    if (lastCommittedView == null) continue;
                    if (lastCommittedView.contains(node)) {
                        recoveredMembers.add(node);
                        continue;
                    }
                    recoveredJoiners.add(node);
                }
                Collections.sort(recoveredMembers, new Comparator<Address>(){

                    @Override
                    public int compare(Address o1, Address o2) {
                        return ((CacheView)((Map)recoveryInfo.get(o2)).get(cacheName)).getViewId() - ((CacheView)((Map)recoveryInfo.get(o1)).get(cacheName)).getViewId();
                    }
                });
                log.tracef("%s: Recovered members (including joiners) are %s", cacheName, recoveredMembers);
                int partitionCount = 0;
                ArrayList membersToProcess = new ArrayList(recoveredMembers);
                ArrayList<CacheView> partitions = new ArrayList<CacheView>(2);
                while (!membersToProcess.isEmpty()) {
                    Address node = (Address)membersToProcess.get(0);
                    CacheView committedView = (CacheView)((Map)recoveryInfo.get(node)).get(cacheName);
                    int highestViewId = committedView.getViewId();
                    if (partitionCount == 0) {
                        cacheViewInfo.getPendingChanges().updateLatestViewId(highestViewId + 1);
                    }
                    ArrayList<Address> partitionMembers = new ArrayList<Address>(committedView.getMembers());
                    partitionMembers.retainAll(membersToProcess);
                    membersToProcess.removeAll(committedView.getMembers());
                    if (partitionMembers.isEmpty()) continue;
                    int minViewId = Integer.MAX_VALUE;
                    for (Address partitionMember : partitionMembers) {
                        CacheView pmCommittedView = (CacheView)((Map)recoveryInfo.get(partitionMember)).get(cacheName);
                        int pmViewId = pmCommittedView.getViewId();
                        if (pmViewId >= minViewId) continue;
                        minViewId = pmViewId;
                    }
                    if (minViewId != highestViewId) {
                        log.tracef("Found partition %d (%s) that should have committed view id %d but not all of them do (min view id %d), committing the view", new Object[]{partitionCount, partitionMembers, highestViewId, minViewId});
                        this.clusterCommitView(cacheName, highestViewId, partitionMembers, false);
                    } else {
                        log.tracef("Found partition %d (%s) that has committed view id %d, sending a rollback command to clear any pending prepare", partitionCount, partitionMembers, highestViewId);
                        this.clusterRollbackView(cacheName, highestViewId, partitionMembers, false);
                    }
                    partitions.add(new CacheView(highestViewId, partitionMembers));
                    ++partitionCount;
                }
                log.debugf("Recovered partitions after merge for cache %s: %s", cacheName, partitions);
                cacheViewInfo.getPendingChanges().recoveredViews(recoveredMembers, recoveredJoiners);
            }
        }
        catch (Exception e) {
            log.error("Error recovering views from the cluster members", e);
            return;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Listener
    public class ViewListener {
        @Merged
        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            CacheViewsManagerImpl.this.handleNewView(e.getNewMembers(), e.isMergeView(), e.getViewId() == 0);
        }
    }

    public class ViewInstallationTask
    implements Callable<Object> {
        private final String cacheName;
        private final CacheView newView;

        public ViewInstallationTask(String cacheName, CacheView newView) {
            this.cacheName = cacheName;
            this.newView = newView;
        }

        @Override
        public Object call() throws Exception {
            try {
                CacheViewsManagerImpl.this.clusterInstallView(this.cacheName, this.newView);
            }
            catch (Throwable t) {
                log.viewInstallationFailure(t, this.cacheName);
            }
            return null;
        }
    }

    public class ViewTriggerThread
    extends Thread {
        private Lock lock;
        private Condition condition;

        public ViewTriggerThread() {
            super("CacheViewTrigger," + CacheViewsManagerImpl.this.self);
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeUp() {
            this.lock.lock();
            try {
                log.tracef("Waking up cache view installer thread", new Object[0]);
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (CacheViewsManagerImpl.this.isRunning()) {
                if (CacheViewsManagerImpl.this.shouldRecoverViews) {
                    CacheViewsManagerImpl.this.recoverViews();
                    CacheViewsManagerImpl.this.shouldRecoverViews = false;
                }
                this.lock.lock();
                try {
                    this.condition.await(CacheViewsManagerImpl.this.viewChangeCooldown, TimeUnit.MILLISECONDS);
                    log.tracef("Woke up, shouldRecoverViews=%s", CacheViewsManagerImpl.this.shouldRecoverViews);
                }
                catch (InterruptedException e) {
                    break;
                }
                finally {
                    this.lock.unlock();
                }
                if (!CacheViewsManagerImpl.this.isCoordinator || !CacheViewsManagerImpl.this.isRunning()) continue;
                for (CacheViewInfo cacheViewInfo : CacheViewsManagerImpl.this.viewsInfo.values()) {
                    List<Address> leavers = MembershipArithmetic.getMembersLeft(cacheViewInfo.getCommittedView().getMembers(), CacheViewsManagerImpl.this.members);
                    if (!leavers.isEmpty()) {
                        CacheViewsManagerImpl.this.handleLeavers(leavers, cacheViewInfo.getCacheName());
                    }
                    if (!CacheViewsManagerImpl.this.isRunning()) {
                        return;
                    }
                    if (CacheViewsManagerImpl.this.shouldRecoverViews) continue block7;
                    try {
                        PendingCacheViewChanges pendingChanges = cacheViewInfo.getPendingChanges();
                        CacheView pendingView = pendingChanges.createPendingView(cacheViewInfo.getCommittedView());
                        if (pendingView == null) continue;
                        CacheViewsManagerImpl.this.cacheViewInstallerExecutor.submit(new ViewInstallationTask(cacheViewInfo.getCacheName(), pendingView));
                    }
                    catch (RuntimeException e) {
                        log.errorTriggeringViewInstallation(e, cacheViewInfo.getCacheName());
                    }
                }
            }
        }
    }
}

