/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;

public class ValuesCommand
extends AbstractLocalCommand
implements VisitableCommand {
    private final DataContainer container;

    public ValuesCommand(DataContainer container) {
        this.container = container;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitValuesCommand(ctx, this);
    }

    @Override
    public Collection<Object> perform(InvocationContext ctx) throws Throwable {
        if (this.noTxModifications(ctx)) {
            return new ExpiredFilteredValues(this.container.entrySet());
        }
        return new FilteredValues(this.container, ctx.getLookedUpEntries());
    }

    public String toString() {
        return "ValuesCommand{values=" + this.container.values() + '}';
    }

    public static class ExpiredFilteredValues
    extends AbstractCollection<Object> {
        final Set<InternalCacheEntry> entrySet;

        public ExpiredFilteredValues(Set<InternalCacheEntry> entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Itr();
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Object> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            int s = this.entrySet.size();
            long currentTimeMillis = System.currentTimeMillis();
            for (InternalCacheEntry e : this.entrySet) {
                if (!e.isExpired(currentTimeMillis)) continue;
                --s;
            }
            return s;
        }

        private class Itr
        implements Iterator<Object> {
            private final Iterator<InternalCacheEntry> it;
            private Object next;

            private Itr() {
                this.it = ExpiredFilteredValues.this.entrySet.iterator();
                this.fetchNext();
            }

            private void fetchNext() {
                long currentTimeMillis = System.currentTimeMillis();
                while (this.it.hasNext()) {
                    InternalCacheEntry e = this.it.next();
                    if (e.isExpired(currentTimeMillis)) continue;
                    this.next = e.getValue();
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public Object next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class FilteredValues
    extends AbstractCollection<Object> {
        final Collection<Object> values;
        final Set<InternalCacheEntry> entrySet;
        final Map<Object, CacheEntry> lookedUpEntries;

        FilteredValues(DataContainer container, Map<Object, CacheEntry> lookedUpEntries) {
            this.values = container.values();
            this.entrySet = container.entrySet();
            this.lookedUpEntries = lookedUpEntries;
        }

        @Override
        public int size() {
            long currentTimeMillis = System.currentTimeMillis();
            int size = this.entrySet.size();
            for (InternalCacheEntry internalCacheEntry : this.entrySet) {
                if (!internalCacheEntry.isExpired(currentTimeMillis)) continue;
                --size;
            }
            for (CacheEntry cacheEntry : this.lookedUpEntries.values()) {
                if (cacheEntry.isCreated()) {
                    ++size;
                    continue;
                }
                if (!cacheEntry.isRemoved()) continue;
                --size;
            }
            return Math.max(size, 0);
        }

        @Override
        public boolean contains(Object o) {
            for (CacheEntry e : this.lookedUpEntries.values()) {
                if (!o.equals(e.getValue())) continue;
                return !e.isRemoved();
            }
            return this.values.contains(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return new Itr();
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Object> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private class Itr
        implements Iterator<Object> {
            private final Iterator<CacheEntry> it1;
            private final Iterator<InternalCacheEntry> it2;
            private boolean atIt1;
            private Object next;

            Itr() {
                this.it1 = FilteredValues.this.lookedUpEntries.values().iterator();
                this.it2 = FilteredValues.this.entrySet.iterator();
                this.atIt1 = true;
                this.fetchNext();
            }

            private void fetchNext() {
                boolean found;
                if (this.atIt1) {
                    found = false;
                    while (this.it1.hasNext()) {
                        CacheEntry e = this.it1.next();
                        if (!e.isCreated()) continue;
                        this.next = e.getValue();
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.atIt1 = false;
                    }
                }
                if (!this.atIt1) {
                    found = false;
                    long currentTimeMillis = System.currentTimeMillis();
                    while (this.it2.hasNext()) {
                        InternalCacheEntry ice = this.it2.next();
                        Object key = ice.getKey();
                        CacheEntry e = FilteredValues.this.lookedUpEntries.get(key);
                        if (ice.isExpired(currentTimeMillis)) continue;
                        if (e == null) {
                            this.next = ice.getValue();
                            found = true;
                            break;
                        }
                        if (e.isChanged()) {
                            this.next = e.getValue();
                            found = true;
                            break;
                        }
                        if (!e.isRemoved()) continue;
                    }
                    if (!found) {
                        this.next = null;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public Object next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

