/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.DataContainerConfiguration;
import org.infinispan.configuration.cache.DeadlockDetectionConfiguration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InvocationBatchingConfiguration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LoadersConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.StoreAsBinaryConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.UnsafeConfiguration;
import org.infinispan.configuration.cache.VersioningConfiguration;

public class Configuration {
    private final String name;
    private final ClassLoader classLoader;
    private final ClusteringConfiguration clusteringConfiguration;
    private final CustomInterceptorsConfiguration customInterceptorsConfiguration;
    private final DataContainerConfiguration dataContainerConfiguration;
    private final DeadlockDetectionConfiguration deadlockDetectionConfiguration;
    private final EvictionConfiguration evictionConfiguration;
    private final ExpirationConfiguration expirationConfiguration;
    private final IndexingConfiguration indexingConfiguration;
    private final InvocationBatchingConfiguration invocationBatchingConfiguration;
    private final JMXStatisticsConfiguration jmxStatisticsConfiguration;
    private final LoadersConfiguration loadersConfiguration;
    private final LockingConfiguration lockingConfiguration;
    private final StoreAsBinaryConfiguration storeAsBinaryConfiguration;
    private final TransactionConfiguration transactionConfiguration;
    private final VersioningConfiguration versioningConfiguration;
    private final UnsafeConfiguration unsafeConfiguration;

    Configuration(String name, ClusteringConfiguration clusteringConfiguration, CustomInterceptorsConfiguration customInterceptorsConfiguration, DataContainerConfiguration dataContainerConfiguration, DeadlockDetectionConfiguration deadlockDetectionConfiguration, EvictionConfiguration evictionConfiguration, ExpirationConfiguration expirationConfiguration, IndexingConfiguration indexingConfiguration, InvocationBatchingConfiguration invocationBatchingConfiguration, JMXStatisticsConfiguration jmxStatisticsConfiguration, LoadersConfiguration loadersConfiguration, LockingConfiguration lockingConfiguration, StoreAsBinaryConfiguration storeAsBinaryConfiguration, TransactionConfiguration transactionConfiguration, UnsafeConfiguration unsafeConfiguration, VersioningConfiguration versioningConfiguration, ClassLoader cl) {
        this.name = name;
        this.clusteringConfiguration = clusteringConfiguration;
        this.customInterceptorsConfiguration = customInterceptorsConfiguration;
        this.dataContainerConfiguration = dataContainerConfiguration;
        this.deadlockDetectionConfiguration = deadlockDetectionConfiguration;
        this.evictionConfiguration = evictionConfiguration;
        this.expirationConfiguration = expirationConfiguration;
        this.indexingConfiguration = indexingConfiguration;
        this.invocationBatchingConfiguration = invocationBatchingConfiguration;
        this.jmxStatisticsConfiguration = jmxStatisticsConfiguration;
        this.loadersConfiguration = loadersConfiguration;
        this.lockingConfiguration = lockingConfiguration;
        this.storeAsBinaryConfiguration = storeAsBinaryConfiguration;
        this.transactionConfiguration = transactionConfiguration;
        this.unsafeConfiguration = unsafeConfiguration;
        this.versioningConfiguration = versioningConfiguration;
        this.classLoader = cl;
    }

    public String name() {
        return this.name;
    }

    @Deprecated
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public ClusteringConfiguration clustering() {
        return this.clusteringConfiguration;
    }

    public CustomInterceptorsConfiguration customInterceptors() {
        return this.customInterceptorsConfiguration;
    }

    public DataContainerConfiguration dataContainer() {
        return this.dataContainerConfiguration;
    }

    public DeadlockDetectionConfiguration deadlockDetection() {
        return this.deadlockDetectionConfiguration;
    }

    public EvictionConfiguration eviction() {
        return this.evictionConfiguration;
    }

    public ExpirationConfiguration expiration() {
        return this.expirationConfiguration;
    }

    public IndexingConfiguration indexing() {
        return this.indexingConfiguration;
    }

    public InvocationBatchingConfiguration invocationBatching() {
        return this.invocationBatchingConfiguration;
    }

    public JMXStatisticsConfiguration jmxStatistics() {
        return this.jmxStatisticsConfiguration;
    }

    public LoadersConfiguration loaders() {
        return this.loadersConfiguration;
    }

    public LockingConfiguration locking() {
        return this.lockingConfiguration;
    }

    public StoreAsBinaryConfiguration storeAsBinary() {
        return this.storeAsBinaryConfiguration;
    }

    public TransactionConfiguration transaction() {
        return this.transactionConfiguration;
    }

    public UnsafeConfiguration unsafe() {
        return this.unsafeConfiguration;
    }

    public VersioningConfiguration versioningConfiguration() {
        return this.versioningConfiguration;
    }

    public boolean stateTransferEnabled() {
        return this.clustering().stateRetrieval().fetchInMemoryState() || this.loaders().fetchPersistentState() != false;
    }

    @Deprecated
    public boolean onePhaseCommit() {
        return this.clusteringConfiguration.cacheMode().isSynchronous();
    }
}

