/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EvictionConfigurationBuilder
extends AbstractConfigurationChildBuilder<EvictionConfiguration> {
    private static final Log log = LogFactory.getLog(EvictionConfigurationBuilder.class);
    private int maxEntries = -1;
    private EvictionStrategy strategy = EvictionStrategy.NONE;
    private EvictionThreadPolicy threadPolicy = EvictionThreadPolicy.DEFAULT;

    EvictionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public EvictionConfigurationBuilder strategy(EvictionStrategy evictionStrategy) {
        this.strategy = evictionStrategy;
        return this;
    }

    public EvictionConfigurationBuilder threadPolicy(EvictionThreadPolicy policy) {
        this.threadPolicy = policy;
        return this;
    }

    public EvictionConfigurationBuilder maxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    @Override
    void validate() {
        if (!this.strategy.isEnabled() && this.getBuilder().loaders().passivation()) {
            log.passivationWithoutEviction();
        }
        if (this.strategy.isEnabled() && this.maxEntries <= 0) {
            throw new ConfigurationException("Eviction maxEntries value cannot be less than or equal to zero if eviction is enabled");
        }
    }

    @Override
    EvictionConfiguration create() {
        return new EvictionConfiguration(this.maxEntries, this.strategy, this.threadPolicy);
    }
}

