/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;

public class LockingConfigurationBuilder
extends AbstractConfigurationChildBuilder<LockingConfiguration> {
    private int concurrencyLevel = 32;
    IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
    private long lockAcquisitionTimeout = TimeUnit.SECONDS.toMillis(10L);
    private boolean useLockStriping = false;
    boolean writeSkewCheck = false;

    protected LockingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public LockingConfigurationBuilder concurrencyLevel(int i) {
        this.concurrencyLevel = i;
        return this;
    }

    public LockingConfigurationBuilder isolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public LockingConfigurationBuilder lockAcquisitionTimeout(long l) {
        this.lockAcquisitionTimeout = l;
        return this;
    }

    public LockingConfigurationBuilder useLockStriping(boolean b) {
        this.useLockStriping = b;
        return this;
    }

    public LockingConfigurationBuilder writeSkewCheck(boolean b) {
        this.writeSkewCheck = b;
        return this;
    }

    @Override
    void validate() {
        if (this.writeSkewCheck) {
            if (this.isolationLevel != IsolationLevel.REPEATABLE_READ) {
                throw new ConfigurationException("Write-skew checking only allowed with REPEATABLE_READ isolation level");
            }
            if (this.transaction().lockingMode != LockingMode.OPTIMISTIC) {
                throw new ConfigurationException("Write-skew checking only allowed with OPTIMISTIC transactions");
            }
            if (!this.versioning().enabled || this.versioning().scheme != VersioningScheme.SIMPLE) {
                throw new ConfigurationException("Write-skew checking requires versioning to be enabled and versioning scheme 'SIMPLE' to be configured");
            }
            if (this.clustering().cacheMode() != CacheMode.DIST_SYNC && this.clustering().cacheMode() != CacheMode.REPL_SYNC && this.clustering().cacheMode() != CacheMode.LOCAL) {
                throw new ConfigurationException("Write-skew checking is only supported in REPL_SYNC, DIST_SYNC and LOCAL modes.  " + (Object)((Object)this.clustering().cacheMode()) + " cannot be used with write-skew checking");
            }
        }
    }

    @Override
    LockingConfiguration create() {
        return new LockingConfiguration(this.concurrencyLevel, this.isolationLevel, this.lockAcquisitionTimeout, this.useLockStriping, this.writeSkewCheck);
    }
}

