/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;

class VirtualAddress
implements Address {
    private final Address realAddress;
    private final int id;

    public VirtualAddress(Address realAddress, int id) {
        if (realAddress == null) {
            throw new IllegalArgumentException(Util.formatString("readAddress must not be null", new Object[0]));
        }
        this.realAddress = realAddress;
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Address getRealAddress() {
        return this.realAddress;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.realAddress.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualAddress) {
            VirtualAddress that = (VirtualAddress)obj;
            return this.realAddress.equals(that.realAddress) && this.id == that.id;
        }
        return false;
    }

    public String toString() {
        return Util.formatString("%s-%d", this.realAddress, this.id);
    }
}

