/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.EntryWrappingInterceptor;

public class VersionedEntryWrappingInterceptor
extends EntryWrappingInterceptor {
    private VersionGenerator versionGenerator;

    @Inject
    public void initialize(VersionGenerator versionGenerator) {
        this.versionGenerator = versionGenerator;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = super.visitPrepareCommand(ctx, command);
        EntryVersionsMap newVersionData = this.cll.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, ctx, (VersionedPrepareCommand)command);
        return newVersionData == null ? retval : newVersionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            if (ctx.isOriginLocal()) {
                ((VersionedCommitCommand)command).setUpdatedVersions(ctx.getCacheTransaction().getUpdatedEntryVersions());
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.log.fatal("Commit command is " + command);
            if (!ctx.isOriginLocal()) {
                ctx.getCacheTransaction().setUpdatedEntryVersions(((VersionedCommitCommand)command).getUpdatedVersions());
            }
            this.commitContextEntries(ctx);
        }
    }

    @Override
    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, boolean skipOwnershipCheck) {
        if (ctx.isInTxScope()) {
            EntryVersion version = (EntryVersion)((TxInvocationContext)ctx).getCacheTransaction().getUpdatedEntryVersions().get(entry.getKey());
            this.cll.commitEntry(entry, version, skipOwnershipCheck);
        } else {
            this.cll.commitEntry(entry, entry.getVersion(), skipOwnershipCheck);
        }
    }
}

