/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Set;
import org.infinispan.CacheException;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.concurrent.TimeoutException;

public class AbstractTxLockingInterceptor
extends AbstractLockingInterceptor {
    protected TransactionTable txTable;

    @Inject
    public void setDependencies(TransactionTable txTable) {
        this.txTable = txTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        ctx.setFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.CACHE_MODE_LOCAL);
        try {
            this.lockKey(ctx, command.getKey());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            Object object = super.visitCommitCommand(ctx, command);
            return object;
        }
        finally {
            if (this.releaseLockOnTxCompletion(ctx)) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    protected final void abortIfRemoteTransactionInvalid(TxInvocationContext ctx, AbstractTransactionBoundaryCommand c) {
        if (!ctx.isOriginLocal()) {
            Address origin = c.getGlobalTransaction().getAddress();
            if (!this.transport.getMembers().contains(origin)) {
                throw new CacheException("Member " + origin + " no longer in cluster. Forcing tx rollback for " + c.getGlobalTransaction());
            }
        }
    }

    protected final Object invokeNextAndCommitIf1Pc(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object result = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit() && this.releaseLockOnTxCompletion(ctx)) {
            this.lockManager.unlockAll(ctx);
        }
        return result;
    }

    protected final void lockAndRegisterBackupLock(TxInvocationContext ctx, Object key) throws InterruptedException {
        if (this.cdl.localNodeIsPrimaryOwner(key)) {
            this.lockKeyAndCheckOwnership(ctx, key);
        } else if (this.cdl.localNodeIsOwner(key)) {
            ctx.getCacheTransaction().addBackupLockForKey(key);
        }
    }

    protected final void lockKeyAndCheckOwnership(InvocationContext ctx, Object key) throws InterruptedException {
        boolean checkForPendingLocks = false;
        if (!ctx.isInTxScope()) {
            this.lockManager.acquireLock(ctx, key);
            return;
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        Integer viewId = txContext.getCacheTransaction().getViewId();
        if (viewId != null) {
            checkForPendingLocks = viewId > this.txTable.getMinViewId();
        }
        this.log.tracef("Locking key %s, checking for pending locks? %s", key, checkForPendingLocks);
        if (!checkForPendingLocks) {
            this.lockManager.acquireLock(ctx, key);
        } else {
            Set<CacheTransaction> tx = this.txTable.getTransactionsStartedBefore(viewId);
            long expectedEndTime = this.nowMillis() + this.configuration.getLockAcquisitionTimeout();
            for (CacheTransaction ct : tx) {
                long remaining = expectedEndTime - this.nowMillis();
                if (remaining >= 0L && ct.waitForLockRelease(key, remaining)) continue;
                throw this.newTimeoutException(key, txContext);
            }
            long remaining = expectedEndTime - this.nowMillis();
            if (remaining < 0L) {
                throw this.newTimeoutException(key, txContext);
            }
            this.log.tracef("Finished waiting for other potential lockers, trying to acquire the lock on %s", key);
            this.lockManager.acquireLock(ctx, key, remaining);
        }
    }

    private TimeoutException newTimeoutException(Object key, TxInvocationContext txContext) {
        return new TimeoutException("Could not acquire lock on " + key + " on behalf of transaction " + txContext.getGlobalTransaction() + ". Lock is being held by " + this.lockManager.getOwner(key));
    }

    private boolean releaseLockOnTxCompletion(TxInvocationContext ctx) {
        return ctx.isOriginLocal() || this.configuration.isSecondPhaseAsync();
    }

    private long nowMillis() {
        return System.nanoTime() / 1000000L;
    }
}

