/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.infinispan.CacheException;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.container.EntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;

public class OptimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    final LockAquisitionVisitor lockAquisitionVisitor = new LockAquisitionVisitor();
    private static final Comparator<Object> keyComparator = new Comparator<Object>(){
        private final MurmurHash3 hash = new MurmurHash3();

        @Override
        public int compare(Object o1, Object o2) {
            return this.hash.hash(o1) - this.hash.hash(o2);
        }
    };
    EntryFactory entryFactory;

    @Inject
    public void setDependencies(EntryFactory entryFactory) {
        this.entryFactory = entryFactory;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        this.abortIfRemoteTransactionInvalid(ctx, command);
        if (command.writesToASingleKey()) {
            this.log.trace("Not using lock reordering as we have a single key.");
            this.acquireLocksVisitingCommands(ctx, command);
        } else {
            LockReorderingVisitor lre = new LockReorderingVisitor(command.getModifications());
            if (!lre.hasClear) {
                this.log.tracef("Using lock reordering, order is: %s", lre.orderedKeys);
                this.acquireAllLocks(ctx, lre.orderedKeys.iterator());
                ctx.addAllAffectedKeys(lre.orderedKeys);
            } else {
                this.log.trace("Not using lock reordering as the prepare contains a clear command.");
                this.acquireLocksVisitingCommands(ctx, command);
            }
        }
        return this.invokeNextAndCommitIf1Pc(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        try {
            for (Object key : this.dataContainer.keySet()) {
                this.entryFactory.wrapEntryForClear(ctx, key);
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new CacheException("Explicit locking is not allowed with optimistic caches!");
    }

    private void acquireAllLocks(TxInvocationContext ctx, Iterator<Object> orderedKeys) throws InterruptedException {
        while (orderedKeys.hasNext()) {
            this.lockAndRegisterBackupLock(ctx, orderedKeys.next());
        }
    }

    private void acquireLocksVisitingCommands(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        for (WriteCommand wc : command.getModifications()) {
            wc.acceptVisitor(ctx, this.lockAquisitionVisitor);
        }
    }

    static /* synthetic */ Comparator access$300() {
        return keyComparator;
    }

    private final class LockReorderingVisitor
    extends AbstractVisitor {
        private boolean hasClear;
        private final SortedSet<Object> orderedKeys = new TreeSet<Object>(OptimisticLockingInterceptor.access$300());

        public LockReorderingVisitor(WriteCommand[] modifications) throws Throwable {
            for (WriteCommand wc : modifications) {
                wc.acceptVisitor(null, this);
            }
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.orderedKeys.add(command.getKey());
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            return this.orderedKeys.addAll(command.getAffectedKeys());
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.orderedKeys.add(command.getKey());
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.orderedKeys.add(command.getKey());
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (OptimisticLockingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                Object[] compositeKeys = command.getCompositeKeys();
                this.orderedKeys.addAll(Arrays.asList(compositeKeys));
            }
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            this.hasClear = true;
            return null;
        }

        @Override
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            throw new IllegalStateException("Visitable command which require lock acquisition is ignored! " + command);
        }
    }

    private final class LockAquisitionVisitor
    extends AbstractVisitor {
        private LockAquisitionVisitor() {
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            for (Object key : OptimisticLockingInterceptor.this.dataContainer.keySet()) {
                OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, key);
                txC.addAffectedKey(key);
            }
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            for (Object key : command.getMap().keySet()) {
                OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, key);
                txC.addAffectedKey(key);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, command.getKey());
            txC.addAffectedKey(command.getKey());
            return null;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, command.getKey());
            txC.addAffectedKey(command.getKey());
            return null;
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (OptimisticLockingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                Object[] compositeKeys;
                for (Object key : compositeKeys = command.getCompositeKeys()) {
                    OptimisticLockingInterceptor.this.lockAndRegisterBackupLock((TxInvocationContext)ctx, key);
                }
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, command.getKey());
            txC.addAffectedKey(command.getKey());
            return null;
        }
    }
}

