/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.infinispan.CacheException;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicHashMapDelta;
import org.infinispan.atomic.ClearOperation;
import org.infinispan.atomic.PutOperation;
import org.infinispan.atomic.RemoveOperation;
import org.infinispan.cacheviews.CacheView;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commons.hash.MurmurHash2;
import org.infinispan.commons.hash.MurmurHash2Compat;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.config.AdvancedExternalizerConfig;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.distribution.RemoteTransactionLogDetails;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.TopologyAwareConsistentHash;
import org.infinispan.distribution.ch.UnionConsistentHash;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.exts.ArrayListExternalizer;
import org.infinispan.marshall.exts.CacheRpcCommandExternalizer;
import org.infinispan.marshall.exts.LinkedListExternalizer;
import org.infinispan.marshall.exts.MapExternalizer;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.marshall.exts.SetExternalizer;
import org.infinispan.marshall.exts.SingletonListExternalizer;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.ExtendedResponse;
import org.infinispan.remoting.responses.RequestIgnoredResponse;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.InDoubtTxInfoImpl;
import org.infinispan.transaction.xa.recovery.RecoveryAwareDldGlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareGlobalTransaction;
import org.infinispan.transaction.xa.recovery.SerializableXid;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.Immutables;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

@Scope(value=Scopes.GLOBAL)
public class ExternalizerTable
implements ObjectTable {
    private static final Log log = LogFactory.getLog(ExternalizerTable.class);
    private final Set<AdvancedExternalizer> internalExternalizers = new HashSet<AdvancedExternalizer>();
    private final Map<Class<?>, ExternalizerAdapter> writers = new WeakHashMap();
    private final Map<Integer, ExternalizerAdapter> readers = new HashMap<Integer, ExternalizerAdapter>();
    private volatile boolean started;
    private RemoteCommandsFactory cmdFactory;
    private GlobalComponentRegistry gcr;

    private void initInternalExternalizers() {
        this.internalExternalizers.add(new ArrayListExternalizer());
        this.internalExternalizers.add(new LinkedListExternalizer());
        this.internalExternalizers.add(new MapExternalizer());
        this.internalExternalizers.add(new SetExternalizer());
        this.internalExternalizers.add(new SingletonListExternalizer());
        this.internalExternalizers.add(new GlobalTransaction.Externalizer());
        this.internalExternalizers.add(new RecoveryAwareGlobalTransaction.Externalizer());
        this.internalExternalizers.add(new DldGlobalTransaction.Externalizer());
        this.internalExternalizers.add(new RecoveryAwareDldGlobalTransaction.Externalizer());
        this.internalExternalizers.add(new JGroupsAddress.Externalizer());
        this.internalExternalizers.add(new Immutables.ImmutableMapWrapperExternalizer());
        this.internalExternalizers.add(new MarshalledValue.Externalizer());
        this.internalExternalizers.add(new TransactionLog.LogEntry.Externalizer());
        this.internalExternalizers.add(new ExtendedResponse.Externalizer());
        this.internalExternalizers.add(new SuccessfulResponse.Externalizer());
        this.internalExternalizers.add(new ExceptionResponse.Externalizer());
        this.internalExternalizers.add(new RequestIgnoredResponse.Externalizer());
        this.internalExternalizers.add(new UnsuccessfulResponse.Externalizer());
        this.internalExternalizers.add(new UnsureResponse.Externalizer());
        this.internalExternalizers.add(new ReplicableCommandExternalizer());
        this.internalExternalizers.add(new CacheRpcCommandExternalizer());
        this.internalExternalizers.add(new ImmortalCacheEntry.Externalizer());
        this.internalExternalizers.add(new MortalCacheEntry.Externalizer());
        this.internalExternalizers.add(new TransientCacheEntry.Externalizer());
        this.internalExternalizers.add(new TransientMortalCacheEntry.Externalizer());
        this.internalExternalizers.add(new ImmortalCacheValue.Externalizer());
        this.internalExternalizers.add(new MortalCacheValue.Externalizer());
        this.internalExternalizers.add(new TransientCacheValue.Externalizer());
        this.internalExternalizers.add(new TransientMortalCacheValue.Externalizer());
        this.internalExternalizers.add(new AtomicHashMap.Externalizer());
        this.internalExternalizers.add(new Bucket.Externalizer());
        this.internalExternalizers.add(new AtomicHashMapDelta.Externalizer());
        this.internalExternalizers.add(new PutOperation.Externalizer());
        this.internalExternalizers.add(new RemoveOperation.Externalizer());
        this.internalExternalizers.add(new ClearOperation.Externalizer());
        this.internalExternalizers.add(new DefaultConsistentHash.Externalizer());
        this.internalExternalizers.add(new UnionConsistentHash.Externalizer());
        this.internalExternalizers.add(new JGroupsTopologyAwareAddress.Externalizer());
        this.internalExternalizers.add(new TopologyAwareConsistentHash.Externalizer());
        this.internalExternalizers.add(new ByteArrayKey.Externalizer());
        this.internalExternalizers.add(new RemoteTransactionLogDetails.Externalizer());
        this.internalExternalizers.add(new SerializableXid.XidExternalizer());
        this.internalExternalizers.add(new InDoubtTxInfoImpl.Externalizer());
        this.internalExternalizers.add(new MurmurHash2.Externalizer());
        this.internalExternalizers.add(new MurmurHash2Compat.Externalizer());
        this.internalExternalizers.add(new MurmurHash3.Externalizer());
        this.internalExternalizers.add(new CacheView.Externalizer());
    }

    void addInternalExternalizer(AdvancedExternalizer ext) {
        this.internalExternalizers.add(ext);
    }

    @Inject
    public void inject(RemoteCommandsFactory cmdFactory, GlobalComponentRegistry gcr) {
        this.cmdFactory = cmdFactory;
        this.gcr = gcr;
    }

    @Start(priority=7)
    public void start() {
        this.initInternalExternalizers();
        this.loadInternalMarshallables(this.cmdFactory, this.gcr);
        this.loadForeignMarshallables(this.gcr.getGlobalConfiguration());
        this.started = true;
        if (log.isTraceEnabled()) {
            log.tracef("Constant object table was started and contains these externalizer readers: %s", this.readers);
            log.tracef("The externalizer writers collection contains: %s", this.writers);
        }
    }

    @Stop(priority=13)
    public void stop() {
        this.internalExternalizers.clear();
        this.writers.clear();
        this.readers.clear();
        this.started = false;
        if (log.isTraceEnabled()) {
            log.trace("Externalizer reader and writer maps have been cleared and constant object table was stopped");
        }
    }

    public ObjectTable.Writer getObjectWriter(Object o) throws IOException {
        Class<?> clazz = o.getClass();
        ObjectTable.Writer writer = this.writers.get(clazz);
        if (writer == null && Thread.currentThread().isInterrupted()) {
            throw new IOException(new InterruptedException(String.format("Cache manager is shutting down, so type write externalizer for type=%s cannot be resolved. Interruption being pushed up.", clazz.getName())));
        }
        return writer;
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        ExternalizerAdapter adapter;
        int readerIndex = input.readUnsignedByte();
        if (readerIndex == 255) {
            readerIndex = this.generateForeignReaderIndex(UnsignedNumeric.readUnsignedInt((ObjectInput)input));
        }
        if ((adapter = this.readers.get(readerIndex)) == null) {
            if (!this.started) {
                if (log.isTraceEnabled()) {
                    log.tracef("Either the marshaller has stopped or hasn't started. Read externalizers are not propery populated: %s", this.readers);
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException(String.format("Cache manager is shutting down, so type (id=%d) cannot be resolved. Interruption being pushed up.", readerIndex), new InterruptedException());
                }
                throw new CacheException(String.format("Cache manager is either starting up or shutting down but it's not interrupted, so type (id=%d) cannot be resolved.", readerIndex));
            }
            if (log.isTraceEnabled()) {
                log.tracef("Unknown type. Input stream has %s to read", input.available());
                log.tracef("Check contents of read externalizers: %s", this.readers);
            }
            throw new CacheException(String.format("Type of data read is unknown. Id=%d is not amongst known reader indexes.", readerIndex));
        }
        return adapter.readObject(input);
    }

    boolean isMarshallableCandidate(Object o) {
        return this.writers.containsKey(o.getClass());
    }

    int getExternalizerId(Object o) {
        return this.writers.get(o.getClass()).getExternalizerId();
    }

    private void loadInternalMarshallables(RemoteCommandsFactory cmdFactory, GlobalComponentRegistry gcr) {
        for (AdvancedExternalizer ext : this.internalExternalizers) {
            if (ext instanceof ReplicableCommandExternalizer) {
                ((ReplicableCommandExternalizer)ext).inject(cmdFactory, gcr);
            }
            if (ext instanceof CacheRpcCommandExternalizer) {
                ((CacheRpcCommandExternalizer)ext).inject(cmdFactory, gcr);
            }
            if (ext instanceof MarshalledValue.Externalizer) {
                ((MarshalledValue.Externalizer)ext).inject(gcr);
            }
            int id = this.checkInternalIdLimit(ext.getId(), ext);
            this.updateExtReadersWritersWithTypes(new ExternalizerAdapter(id, ext));
        }
    }

    private void updateExtReadersWritersWithTypes(ExternalizerAdapter adapter) {
        this.updateExtReadersWritersWithTypes(adapter, adapter.id);
    }

    private void updateExtReadersWritersWithTypes(ExternalizerAdapter adapter, int readerIndex) {
        Set typeClasses = adapter.externalizer.getTypeClasses();
        if (typeClasses.size() > 0) {
            for (Class typeClass : typeClasses) {
                this.updateExtReadersWriters(adapter, typeClass, readerIndex);
            }
        } else {
            throw new ConfigurationException(String.format("AdvancedExternalizer's getTypeClasses for externalizer %s must return a non-empty set", adapter.externalizer.getClass().getName()));
        }
    }

    private void loadForeignMarshallables(GlobalConfiguration globalCfg) {
        if (log.isTraceEnabled()) {
            log.trace("Loading user defined externalizers");
        }
        List<AdvancedExternalizerConfig> configs = globalCfg.getExternalizers();
        for (AdvancedExternalizerConfig config : configs) {
            AdvancedExternalizer ext = config.getAdvancedExternalizer() != null ? config.getAdvancedExternalizer() : (AdvancedExternalizer)Util.getInstance(config.getExternalizerClass(), globalCfg.getClassLoader());
            Integer id = ext.getId();
            if (config.getId() == null && id == null) {
                throw new ConfigurationException(String.format("No advanced externalizer identifier set for externalizer %s", ext.getClass().getName()));
            }
            if (config.getId() != null) {
                id = config.getId();
            }
            id = this.checkForeignIdLimit(id, ext);
            this.updateExtReadersWritersWithTypes(new ForeignExternalizerAdapter(id, ext), this.generateForeignReaderIndex(id));
        }
    }

    private void updateExtReadersWriters(ExternalizerAdapter adapter, Class typeClass, int readerIndex) {
        this.writers.put(typeClass, adapter);
        ExternalizerAdapter prevReader = this.readers.put(readerIndex, adapter);
        if (prevReader != null && !prevReader.equals(adapter)) {
            throw new ConfigurationException(String.format("Duplicate id found! AdvancedExternalizer id=%d for %s is shared by another externalizer (%s). Reader index is %d", adapter.id, typeClass, prevReader.externalizer.getClass().getName(), readerIndex));
        }
        if (log.isTraceEnabled()) {
            log.tracef("Loaded externalizer %s for %s with id %s and reader index %s", new Object[]{adapter.externalizer.getClass().getName(), typeClass, adapter.id, readerIndex});
        }
    }

    private int checkInternalIdLimit(int id, AdvancedExternalizer ext) {
        if (id >= 255) {
            throw new ConfigurationException(String.format("Internal %s externalizer is using an id(%d) that exceeed the limit. It needs to be smaller than %d", ext, id, 255));
        }
        return id;
    }

    private int checkForeignIdLimit(int id, AdvancedExternalizer ext) {
        if (id < 0) {
            throw new ConfigurationException(String.format("Foreign %s externalizer is using a negative id(%d). Only positive id values are allowed.", ext, id));
        }
        return id;
    }

    private int generateForeignReaderIndex(int foreignId) {
        return Integer.MIN_VALUE | foreignId;
    }

    static class ForeignExternalizerAdapter
    extends ExternalizerAdapter {
        final int foreignId;

        ForeignExternalizerAdapter(int foreignId, AdvancedExternalizer externalizer) {
            super(255, externalizer);
            this.foreignId = foreignId;
        }

        @Override
        int getExternalizerId() {
            return this.foreignId;
        }

        @Override
        public void writeObject(Marshaller output, Object object) throws IOException {
            output.write(this.id);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, this.foreignId);
            this.externalizer.writeObject((ObjectOutput)output, object);
        }
    }

    static class ExternalizerAdapter
    implements ObjectTable.Writer {
        final int id;
        final AdvancedExternalizer externalizer;

        ExternalizerAdapter(int id, AdvancedExternalizer externalizer) {
            this.id = id;
            this.externalizer = externalizer;
        }

        public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
            return this.externalizer.readObject((ObjectInput)input);
        }

        public void writeObject(Marshaller output, Object object) throws IOException {
            output.write(this.id);
            this.externalizer.writeObject((ObjectOutput)output, object);
        }

        int getExternalizerId() {
            return this.id;
        }

        public String toString() {
            return this.externalizer.getClass().getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalizerAdapter that = (ExternalizerAdapter)o;
            if (this.id != that.id) {
                return false;
            }
            return !(this.externalizer != null ? !this.externalizer.getClass().equals(that.externalizer.getClass()) : that.externalizer != null);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.externalizer.getClass() != null ? this.externalizer.getClass().hashCode() : 0);
            return result;
        }
    }
}

