/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.NamedCacheNotFoundException;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;

public abstract class AbstractTransport
implements Transport {
    protected GlobalConfiguration configuration;

    @Override
    public void setConfiguration(GlobalConfiguration globalConfiguration) {
        this.configuration = globalConfiguration;
    }

    protected final boolean shouldThrowException(Exception ce) {
        if (!this.configuration.isStrictPeerToPeer()) {
            if (ce instanceof NamedCacheNotFoundException) {
                return false;
            }
            if (ce.getCause() != null && ce.getCause() instanceof NamedCacheNotFoundException) {
                return false;
            }
        }
        return true;
    }

    protected boolean parseResponseAndAddToResponseList(Object responseObject, Throwable exception, Map<Address, Response> responseListToAddTo, boolean wasSuspected, boolean wasReceived, Address sender, boolean usedResponseFilter, boolean ignoreLeavers) throws Exception {
        Log log = this.getLog();
        boolean invalidResponse = true;
        if (!wasSuspected && wasReceived) {
            invalidResponse = false;
            if (exception != null) {
                log.tracef(exception, "Unexpected exception from %s", sender);
                throw new CacheException("Remote (" + sender + ") failed unexpectedly", exception);
            }
            if (responseObject instanceof Response) {
                Exception e;
                Response response = (Response)responseObject;
                if (response instanceof ExceptionResponse && !((e = ((ExceptionResponse)response).getException()) instanceof RpcException)) {
                    if (this.shouldThrowException(e)) {
                        throw e;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Received exception from sender" + sender, e);
                    }
                }
                responseListToAddTo.put(sender, response);
            } else if (responseObject != null) {
                Class<?> responseClass = responseObject != null ? responseObject.getClass() : null;
                log.tracef("Unexpected response object type from %s: %s", sender, responseClass);
                throw new CacheException(String.format("Unexpected response object type from %s: %s", sender, responseClass));
            }
        } else if (wasSuspected) {
            if (!ignoreLeavers) {
                throw new SuspectException("Suspected member: " + sender, sender);
            }
            log.tracef("Target node %s left during remote call, ignoring", sender);
        } else if (!usedResponseFilter) {
            throw new TimeoutException("Replication timeout for " + sender);
        }
        return invalidResponse;
    }
}

