/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.StaleTransactionCleanupService;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.synchronization.SynchronizationAdapter;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener(sync=false)
public class TransactionTable {
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private final ConcurrentMap<Transaction, LocalTransaction> localTransactions = new ConcurrentHashMap<Transaction, LocalTransaction>();
    private final ConcurrentMap<GlobalTransaction, RemoteTransaction> remoteTransactions = new ConcurrentHashMap<GlobalTransaction, RemoteTransaction>();
    private final StaleTransactionCleanupService cleanupService = new StaleTransactionCleanupService(this);
    protected Configuration configuration;
    protected InvocationContextContainer icc;
    protected TransactionCoordinator txCoordinator;
    protected TransactionFactory txFactory;
    protected RpcManager rpcManager;
    protected CommandsFactory commandsFactory;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private EmbeddedCacheManager cm;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    protected ClusteringDependentLogic clusteringLogic;
    private int minTxViewId = -1;
    protected final Object minViewIdInvariant = new Object();

    @Inject
    public void initialize(RpcManager rpcManager, Configuration configuration, InvocationContextContainer icc, InterceptorChain invoker, CacheNotifier notifier, TransactionFactory gtf, EmbeddedCacheManager cm, TransactionCoordinator txCoordinator, TransactionSynchronizationRegistry transactionSynchronizationRegistry, CommandsFactory commandsFactory, ClusteringDependentLogic clusteringDependentLogic) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icc = icc;
        this.invoker = invoker;
        this.notifier = notifier;
        this.txFactory = gtf;
        this.cm = cm;
        this.txCoordinator = txCoordinator;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.commandsFactory = commandsFactory;
        this.clusteringLogic = clusteringDependentLogic;
    }

    @Start
    private void start() {
        this.cleanupService.start(this.configuration, this.rpcManager, this.invoker);
        this.cm.addListener(this.cleanupService);
        this.cm.addListener(this);
        this.notifier.addListener(this.cleanupService);
        if (!this.isStandaloneCache()) {
            this.minTxViewId = this.getCurrentViewId();
            log.debugf("Min view id set to %s", this.minTxViewId);
        }
    }

    @Stop
    private void stop() {
        this.notifier.removeListener(this.cleanupService);
        this.cm.removeListener(this.cleanupService);
        this.cleanupService.stop();
        this.cm.removeListener(this);
        this.shutDownGracefully();
    }

    public Set<Object> getLockedKeysForRemoteTransaction(GlobalTransaction gtx) {
        RemoteTransaction transaction = (RemoteTransaction)this.remoteTransactions.get(gtx);
        if (transaction == null) {
            return Collections.emptySet();
        }
        return transaction.getLockedKeys();
    }

    public void remoteTransactionPrepared(GlobalTransaction gtx) {
    }

    public void localTransactionPrepared(LocalTransaction localTransaction) {
    }

    public void enlist(Transaction transaction, LocalTransaction localTransaction) {
        if (!localTransaction.isEnlisted()) {
            SynchronizationAdapter sync = new SynchronizationAdapter(localTransaction, this.txCoordinator, this.commandsFactory, this.rpcManager, this, this.clusteringLogic, this.configuration);
            if (this.transactionSynchronizationRegistry != null) {
                try {
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)sync);
                }
                catch (Exception e) {
                    log.failedSynchronizationRegistration(e);
                    throw new CacheException(e);
                }
            }
            try {
                transaction.registerSynchronization((Synchronization)sync);
            }
            catch (Exception e) {
                log.failedSynchronizationRegistration(e);
                throw new CacheException(e);
            }
            ((SyncLocalTransaction)localTransaction).setEnlisted(true);
        }
    }

    public void failureCompletingTransaction(Transaction tx) {
        LocalTransaction localTransaction = (LocalTransaction)this.localTransactions.get(tx);
        if (localTransaction != null) {
            this.removeLocalTransaction(localTransaction);
        }
    }

    public boolean containsLocalTx(Transaction tx) {
        return tx != null && this.localTransactions.containsKey(tx);
    }

    public Integer getMinViewId() {
        return this.minTxViewId;
    }

    public Set<CacheTransaction> getTransactionsStartedBefore(Integer viewId) {
        HashSet<CacheTransaction> result = new HashSet<CacheTransaction>();
        for (AbstractCacheTransaction ct : this.localTransactions.values()) {
            if (ct.getViewId() == null || ct.getViewId() >= viewId) continue;
            result.add(ct);
        }
        for (AbstractCacheTransaction ct : this.remoteTransactions.values()) {
            if (ct.getViewId() == null || ct.getViewId() >= viewId) continue;
            result.add(ct);
        }
        return result;
    }

    protected void updateStateOnNodesLeaving(Collection<Address> leavers) {
        HashSet<GlobalTransaction> toKill = new HashSet<GlobalTransaction>();
        for (GlobalTransaction gt : this.remoteTransactions.keySet()) {
            if (!leavers.contains(gt.getAddress())) continue;
            toKill.add(gt);
        }
        if (toKill.isEmpty()) {
            log.tracef("No global transactions pertain to originator(s) %s who have left the cluster.", leavers);
        } else {
            log.tracef("%s global transactions pertain to leavers list %s and need to be killed", toKill.size(), leavers);
        }
        for (GlobalTransaction gtx : toKill) {
            log.tracef("Killing remote transaction originating on leaver %s", gtx);
            RollbackCommand rc = new RollbackCommand(this.configuration.getName(), gtx);
            rc.init(this.invoker, this.icc, this);
            try {
                rc.perform(null);
                log.tracef("Rollback of transaction %s complete.", gtx);
            }
            catch (Throwable e) {
                log.unableToRollbackGlobalTx(gtx, e);
            }
        }
        log.trace("Completed cleaning transactions originating on leavers");
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return (RemoteTransaction)this.remoteTransactions.get(txId);
    }

    public void remoteTransactionRollback(GlobalTransaction gtx) {
        RemoteTransaction remove = this.removeRemoteTransaction(gtx);
        log.tracef("Removed local transaction %s? %b", gtx, remove);
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        RemoteTransaction remoteTransaction = modifications == null ? this.txFactory.newRemoteTransaction(globalTx) : this.txFactory.newRemoteTransaction(modifications, globalTx);
        this.updateViewId(remoteTransaction);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    private void registerRemoteTransaction(GlobalTransaction gtx, RemoteTransaction rtx) {
        RemoteTransaction transaction = this.remoteTransactions.put(gtx, rtx);
        if (transaction != null) {
            log.remoteTxAlreadyRegistered();
            throw new IllegalStateException("A remote transaction with the given id was already registered!!!");
        }
        log.trace("Created and registered remote transaction " + rtx);
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, TxInvocationContext ctx) {
        LocalTransaction current = (LocalTransaction)this.localTransactions.get(transaction);
        if (current == null) {
            Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            GlobalTransaction tx = this.txFactory.newGlobalTransaction(localAddress, false);
            current = this.txFactory.newLocalTransaction(transaction, tx, ctx.isImplicitTransaction());
            this.updateViewId(current);
            log.tracef("Created a new tx: %s", current);
            this.localTransactions.put(transaction, current);
            this.notifier.notifyTransactionRegistered(tx, ctx);
        }
        return current;
    }

    public boolean removeLocalTransaction(LocalTransaction localTransaction) {
        return localTransaction != null && this.removeLocalTransactionInternal(localTransaction.getTransaction()) != null;
    }

    public LocalTransaction removeLocalTransaction(Transaction tx) {
        return this.removeLocalTransactionInternal(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final LocalTransaction removeLocalTransactionInternal(Transaction tx) {
        LocalTransaction removed;
        Object object = this.minViewIdInvariant;
        synchronized (object) {
            removed = (LocalTransaction)this.localTransactions.remove(tx);
            if (removed != null) {
                this.recalculateMinViewIdIfNeeded(removed);
                removed.notifyOnTransactionFinished();
            }
        }
        return removed;
    }

    public void remoteTransactionCommitted(GlobalTransaction gtx) {
        if (this.configuration.isSecondPhaseAsync()) {
            this.removeRemoteTransaction(gtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RemoteTransaction removeRemoteTransaction(GlobalTransaction txId) {
        RemoteTransaction result;
        Object object = this.minViewIdInvariant;
        synchronized (object) {
            result = (RemoteTransaction)this.remoteTransactions.remove(txId);
            if (result == null) {
                return null;
            }
            this.recalculateMinViewIdIfNeeded(result);
        }
        log.tracef("Removed %s from transaction table. Transaction %s", txId, result);
        result.notifyOnTransactionFinished();
        return result;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public LocalTransaction getLocalTransaction(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    public Collection<RemoteTransaction> getRemoteTransactions() {
        return this.remoteTransactions.values();
    }

    protected final LocalTransaction getLocalTx(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    private boolean isStandaloneCache() {
        return this.rpcManager == null;
    }

    private int getCurrentViewId() {
        return this.rpcManager.getTransport().getViewId();
    }

    public final Collection<LocalTransaction> getLocalTransactions() {
        return this.localTransactions.values();
    }

    protected final void recalculateMinViewIdIfNeeded(CacheTransaction removeTx) {
        if (this.isStandaloneCache()) {
            return;
        }
        if (removeTx == null) {
            throw new NullPointerException("Cannot pass a null tx here!");
        }
        if (removeTx.getViewId() < this.minTxViewId) {
            throw new IllegalStateException("Cannot have a tx that has a viewId(" + removeTx.getViewId() + ") smaller than min view id (" + this.minTxViewId + ")");
        }
        if (removeTx.getViewId().intValue() != this.getCurrentViewId()) {
            this.calculateMinViewId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ViewChanged
    public void recalculateMinViewIdOnTopologyChange(ViewChangedEvent vce) {
        if (this.rpcManager == null) {
            return;
        }
        log.debugf("View changed, recalculating minViewId", new Object[0]);
        Object object = this.minViewIdInvariant;
        synchronized (object) {
            this.calculateMinViewId();
        }
    }

    private void calculateMinViewId() {
        int minViewId = this.getCurrentViewId();
        for (AbstractCacheTransaction ct : this.localTransactions.values()) {
            if (ct.getViewId() >= minViewId) continue;
            minViewId = ct.getViewId();
            log.tracef("Setting minViewId to %s form local transaction %s", ct.getViewId(), ct);
        }
        for (AbstractCacheTransaction ct : this.remoteTransactions.values()) {
            if (ct.getViewId() >= minViewId) continue;
            minViewId = ct.getViewId();
            log.tracef("Setting minViewId to %s form remote transaction %s", ct.getViewId(), ct);
        }
        log.tracef("Recalculating min view id: existingValue=%s, minViewId=%s", this.minTxViewId, minViewId);
        this.minTxViewId = minViewId;
    }

    private void updateViewId(CacheTransaction current) {
        if (!this.isStandaloneCache()) {
            current.setViewId(this.getCurrentViewId());
        }
    }

    private boolean areTxsOnGoing() {
        return !this.localTransactions.isEmpty() || !this.remoteTransactions.isEmpty();
    }

    private void shutDownGracefully() {
        log.debugf("Wait for on-going transactions to finish for %d seconds.", TimeUnit.MILLISECONDS.toSeconds(this.configuration.getCacheStopTimeout()));
        long failTime = System.currentTimeMillis() + (long)this.configuration.getCacheStopTimeout();
        boolean txsOnGoing = this.areTxsOnGoing();
        while (txsOnGoing && System.currentTimeMillis() < failTime) {
            try {
                Thread.sleep(100L);
                txsOnGoing = this.areTxsOnGoing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debugf("Interrupted waiting for on-going transactions to finish. localTransactions=%s, remoteTransactions%s", this.localTransactions, this.remoteTransactions);
            }
        }
        if (txsOnGoing) {
            log.unfinishedTransactionsRemain(this.localTransactions, this.remoteTransactions);
        } else {
            log.trace("All transactions terminated");
        }
    }
}

