/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.util.Util;

public final class DummyXid
implements Xid {
    private static final AtomicLong GLOBAL_ID_GENERATOR = new AtomicLong(1L);
    private static final AtomicLong BRANCH_QUALIFIER_GENERATOR = new AtomicLong(1L);
    private byte[] globalTransactionId = new byte[64];
    private byte[] branchQualifier = new byte[64];
    private final int cachedHashcode;

    @Override
    public int getFormatId() {
        return 1;
    }

    public DummyXid(UUID transactionManagerId) {
        this.cachedHashcode = this.initializeAndCalculateHash(transactionManagerId);
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    private int initializeAndCalculateHash(UUID transactionManagerId) {
        int hc1 = this.initialize(transactionManagerId, GLOBAL_ID_GENERATOR, this.globalTransactionId);
        return 37 * hc1 + this.initialize(transactionManagerId, BRANCH_QUALIFIER_GENERATOR, this.branchQualifier);
    }

    private int initialize(UUID transactionManagerId, AtomicLong generator, byte[] field) {
        long lsb = transactionManagerId.getLeastSignificantBits();
        long msb = transactionManagerId.getMostSignificantBits();
        long id = generator.getAndIncrement();
        Arrays.fill(field, (byte)0);
        UnsignedNumeric.writeUnsignedLong(field, 0, lsb);
        UnsignedNumeric.writeUnsignedLong(field, 10, msb);
        UnsignedNumeric.writeUnsignedLong(field, 20, id);
        int hash = (int)(lsb ^ lsb >>> 32);
        hash = 37 * hash + (int)(msb ^ msb >>> 32);
        hash = 37 * hash + (int)(id ^ id >>> 32);
        return hash;
    }

    public String toString() {
        return "DummyXid{, globalTransactionId = " + Util.printArray(this.globalTransactionId, false) + ", branchQualifier = " + Util.printArray(this.branchQualifier, false) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)o;
        if (other.getFormatId() != 1) {
            return false;
        }
        if (!Arrays.equals(this.branchQualifier, other.getBranchQualifier())) {
            return false;
        }
        return Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId());
    }

    public int hashCode() {
        return this.cachedHashcode;
    }
}

