/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.util.Map;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.EncoderRegistry;

@Scope(value=Scopes.NAMED_CACHE)
public class EncoderRegistryImpl
implements EncoderRegistry {
    private final Map<Class<? extends Encoder>, Encoder> encoderMap = CollectionFactory.makeConcurrentMap();
    private final Map<Class<? extends Wrapper>, Wrapper> wrapperMap = CollectionFactory.makeConcurrentMap();

    @Override
    public void registerEncoder(Encoder encoder) {
        this.encoderMap.put(encoder.getClass(), encoder);
    }

    @Override
    public void registerWrapper(Wrapper wrapper) {
        this.wrapperMap.put(wrapper.getClass(), wrapper);
    }

    @Override
    public Encoder getEncoder(Class<? extends Encoder> clazz) {
        Encoder encoder = this.encoderMap.get(clazz);
        if (encoder == null) {
            throw new EncodingException("Encoder not found: " + clazz);
        }
        return encoder;
    }

    @Override
    public Wrapper getWrapper(Class<? extends Wrapper> wrapperClass) {
        return this.wrapperMap.get(wrapperClass);
    }
}

