/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.security.GlobalSecurityManager;

@MBean(objectName="GlobalSecurityManager", description="Controls global ACL caches")
public class GlobalSecurityManagerImpl
implements GlobalSecurityManager {
    private static final String ACL_CACHE = "___acl_cache";
    private EmbeddedCacheManager cacheManager;
    private boolean cacheEnabled;

    @Inject
    public void init(EmbeddedCacheManager cacheManager, GlobalConfiguration globalConfiguration, InternalCacheRegistry internalCacheRegistry) {
        this.cacheManager = cacheManager;
        this.registerGlobalACLCacheConfiguration(globalConfiguration, internalCacheRegistry);
    }

    private void registerGlobalACLCacheConfiguration(GlobalConfiguration globalConfiguration, InternalCacheRegistry internalCacheRegistry) {
        long timeout = globalConfiguration.security().securityCacheTimeout();
        if (timeout != 0L) {
            ConfigurationBuilder cfg = new ConfigurationBuilder();
            cfg.simpleCache(true);
            if (timeout > 0L) {
                cfg.expiration().lifespan(timeout);
            }
            internalCacheRegistry.registerInternalCache(ACL_CACHE, cfg.build());
            this.cacheEnabled = true;
        } else {
            this.cacheEnabled = false;
        }
    }

    @Override
    public Cache<?, ?> globalACLCache() {
        if (this.cacheEnabled) {
            return this.cacheManager.getCache(ACL_CACHE);
        }
        return null;
    }

    @Override
    @ManagedOperation(name="Flush ACL Cache", displayName="Flush ACL Cache", description="Flushes the global ACL cache for this node")
    public void flushGlobalACLCache() {
        if (this.cacheEnabled) {
            this.globalACLCache().clear();
        }
    }
}

