/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class CompletableFutures {
    private static final CompletableFuture completedEmptyMapFuture = CompletableFuture.completedFuture(Collections.emptyMap());
    private static final CompletableFuture completedNullFuture = CompletableFuture.completedFuture(null);
    private static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);

    public static <K, V> CompletableFuture<Map<K, V>> completedEmptyMap() {
        return completedEmptyMapFuture;
    }

    public static <T> CompletableFuture<T> completedNull() {
        return completedNullFuture;
    }

    public static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> futures) {
        CompletableFuture<Void> all = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        return all.thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<T> completedExceptionFuture(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    public static boolean await(CompletableFuture<?> future, long time, TimeUnit unit) throws InterruptedException {
        try {
            Objects.requireNonNull(future, "Completable Future must be non-null.").get(time, Objects.requireNonNull(unit, "Time Unit must be non-null"));
            return true;
        }
        catch (ExecutionException e) {
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public static <T> T await(CompletableFuture<T> future) throws ExecutionException, InterruptedException {
        try {
            return Objects.requireNonNull(future, "Completable Future must be non-null.").get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("This should never happen!", e);
        }
    }

    public static CompletionException asCompletionException(Throwable t) {
        if (t instanceof CompletionException) {
            return (CompletionException)t;
        }
        return new CompletionException(t);
    }

    public static void rethrowException(Throwable t) {
        if (t != null) {
            throw CompletableFutures.asCompletionException(t);
        }
    }

    public static Throwable extractException(Throwable t) {
        Throwable cause = t.getCause();
        if (cause != null && t instanceof CompletionException) {
            return cause;
        }
        return t;
    }
}

