/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.commons.util.Util;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.PendingLockListener;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.concurrent.locks.PendingLockPromise;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultPendingLockManager
implements PendingLockManager {
    private static final Log log = LogFactory.getLog(DefaultPendingLockManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int NO_PENDING_CHECK = -2;
    private final Map<GlobalTransaction, PendingLockPromise> pendingLockPromiseMap = new ConcurrentHashMap<GlobalTransaction, PendingLockPromise>();
    private TransactionTable transactionTable;
    private TimeService timeService;
    private ScheduledExecutorService timeoutExecutor;
    private StateTransferManager stateTransferManager;

    @Inject
    public void inject(TransactionTable transactionTable, TimeService timeService, @ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService timeoutExecutor, StateTransferManager stateTransferManager) {
        this.transactionTable = transactionTable;
        this.timeService = timeService;
        this.timeoutExecutor = timeoutExecutor;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public PendingLockPromise checkPendingTransactionsForKey(TxInvocationContext<?> ctx, Object key, long time, TimeUnit unit) {
        GlobalTransaction globalTransaction;
        PendingLockPromise existing;
        if (trace) {
            log.tracef("Checking for pending locks and then locking key %s", Util.toStr((Object)key));
        }
        if ((existing = this.pendingLockPromiseMap.get(globalTransaction = ctx.getGlobalTransaction())) != null) {
            if (trace) {
                log.tracef("PendingLock already exists: %s", existing);
            }
            return existing;
        }
        int txTopologyId = this.getTopologyId(ctx);
        if (txTopologyId != -2) {
            return this.createAndStore(this.getTransactionWithLockedKey(txTopologyId, key, globalTransaction), globalTransaction, time, unit);
        }
        return this.createAndStore(globalTransaction);
    }

    @Override
    public PendingLockPromise checkPendingTransactionsForKeys(TxInvocationContext<?> ctx, Collection<Object> keys, long time, TimeUnit unit) {
        GlobalTransaction globalTransaction;
        PendingLockPromise existing;
        if (trace) {
            log.tracef("Checking for pending locks and then locking keys %s", Util.toStr(keys));
        }
        if ((existing = this.pendingLockPromiseMap.get(globalTransaction = ctx.getGlobalTransaction())) != null) {
            if (trace) {
                log.tracef("PendingLock already exists: %s", existing);
            }
            return existing;
        }
        int txTopologyId = this.getTopologyId(ctx);
        if (txTopologyId != -2) {
            return this.createAndStore(this.getTransactionWithAnyLockedKey(txTopologyId, keys, globalTransaction), globalTransaction, time, unit);
        }
        return this.createAndStore(globalTransaction);
    }

    @Override
    public long awaitPendingTransactionsForKey(TxInvocationContext<?> ctx, Object key, long time, TimeUnit unit) throws InterruptedException {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        PendingLockPromise pendingLockPromise = this.pendingLockPromiseMap.remove(gtx);
        if (trace) {
            log.tracef("Await for pending transactions for transaction %s using %s", gtx, pendingLockPromise);
        }
        if (pendingLockPromise != null) {
            return DefaultPendingLockManager.awaitOn(pendingLockPromise, gtx, time, unit);
        }
        int txTopologyId = this.getTopologyId(ctx);
        if (txTopologyId != -2) {
            return this.checkForPendingLock(key, gtx, txTopologyId, unit.toMillis(time));
        }
        if (trace) {
            log.tracef("Locking key %s, no need to check for pending locks.", Util.toStr((Object)key));
        }
        return unit.toMillis(time);
    }

    @Override
    public long awaitPendingTransactionsForAllKeys(TxInvocationContext<?> ctx, Collection<Object> keys, long time, TimeUnit unit) throws InterruptedException {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        PendingLockPromise pendingLockPromise = this.pendingLockPromiseMap.remove(gtx);
        if (trace) {
            log.tracef("Await for pending transactions for transaction %s using %s", gtx, pendingLockPromise);
        }
        if (pendingLockPromise != null) {
            return DefaultPendingLockManager.awaitOn(pendingLockPromise, gtx, time, unit);
        }
        int txTopologyId = this.getTopologyId(ctx);
        if (txTopologyId != -2) {
            return this.checkForAnyPendingLocks(keys, gtx, txTopologyId, unit.toMillis(time));
        }
        if (trace) {
            log.tracef("Locking keys %s, no need to check for pending locks.", Util.toStr(keys));
        }
        return unit.toMillis(time);
    }

    private PendingLockPromise createAndStore(Collection<PendingTransaction> transactions, GlobalTransaction globalTransaction, long time, TimeUnit unit) {
        if (transactions.isEmpty()) {
            return this.createAndStore(globalTransaction);
        }
        if (trace) {
            log.tracef("Transactions pending for Transaction %s are %s", globalTransaction, transactions);
        }
        PendingLockPromiseImpl pendingLockPromise = new PendingLockPromiseImpl(transactions, this.timeService.expectedEndTime(time, unit));
        PendingLockPromise existing = this.pendingLockPromiseMap.putIfAbsent(globalTransaction, pendingLockPromise);
        if (trace) {
            log.tracef("Stored PendingLock is %s", existing != null ? existing : pendingLockPromise);
        }
        if (existing != null) {
            return existing;
        }
        pendingLockPromise.registerListenerInCacheTransactions();
        if (!pendingLockPromise.isReady()) {
            this.timeoutExecutor.schedule(pendingLockPromise, time, unit);
        }
        return pendingLockPromise;
    }

    private PendingLockPromise createAndStore(GlobalTransaction globalTransaction) {
        if (trace) {
            log.tracef("No transactions pending for Transaction %s", globalTransaction);
        }
        PendingLockPromise existing = this.pendingLockPromiseMap.putIfAbsent(globalTransaction, PendingLockPromise.NO_OP);
        if (trace) {
            log.tracef("Stored PendingLock is %s", existing != null ? existing : PendingLockPromise.NO_OP);
        }
        return existing != null ? existing : PendingLockPromise.NO_OP;
    }

    private int getTopologyId(TxInvocationContext<?> context) {
        int topologyId;
        boolean isFromStateTransfer;
        Object tx = context.getCacheTransaction();
        boolean bl = isFromStateTransfer = context.isOriginLocal() && ((LocalTransaction)tx).isFromStateTransfer();
        if (!isFromStateTransfer && (topologyId = this.stateTransferManager.getCacheTopology().getTopologyId()) != -1 && this.transactionTable.getMinTopologyId() < topologyId) {
            return topologyId;
        }
        return -2;
    }

    private long checkForPendingLock(Object key, GlobalTransaction globalTransaction, int transactionTopologyId, long lockTimeout) throws InterruptedException {
        if (trace) {
            log.tracef("Checking for pending locks and then locking key %s", Util.toStr((Object)key));
        }
        long expectedEndTime = this.timeService.expectedEndTime(lockTimeout, TimeUnit.MILLISECONDS);
        Collection<PendingTransaction> pendingTransactions = this.getTransactionWithLockedKey(transactionTopologyId, key, globalTransaction);
        if (trace) {
            log.tracef("Checking for pending locks: %s", pendingTransactions);
        }
        PendingTransaction lockOwner = this.waitForTransactionsToComplete(pendingTransactions, expectedEndTime);
        if (trace) {
            log.tracef("Finished waiting for other potential lockers. Timed-Out? %b", lockOwner != null);
        }
        if (lockOwner != null) {
            DefaultPendingLockManager.timeout(lockOwner, globalTransaction);
        }
        return this.timeService.remainingTime(expectedEndTime, TimeUnit.MILLISECONDS);
    }

    private long checkForAnyPendingLocks(Collection<Object> keys, GlobalTransaction globalTransaction, int transactionTopologyId, long lockTimeout) throws InterruptedException {
        if (trace) {
            log.tracef("Checking for pending locks and then locking key %s", Util.toStr(keys));
        }
        long expectedEndTime = this.timeService.expectedEndTime(lockTimeout, TimeUnit.MILLISECONDS);
        Collection<PendingTransaction> pendingTransactions = this.getTransactionWithAnyLockedKey(transactionTopologyId, keys, globalTransaction);
        if (trace) {
            log.tracef("Checking for pending locks: %s", pendingTransactions);
        }
        PendingTransaction lockOwner = this.waitForTransactionsToComplete(pendingTransactions, expectedEndTime);
        if (trace) {
            log.tracef("Finished waiting for other potential lockers. Timed-Out? %b", lockOwner != null);
        }
        if (lockOwner != null) {
            DefaultPendingLockManager.timeout(lockOwner, globalTransaction);
        }
        return this.timeService.remainingTime(expectedEndTime, TimeUnit.MILLISECONDS);
    }

    private static void timeout(PendingTransaction lockOwner, GlobalTransaction thisGlobalTransaction) {
        throw new TimeoutException(String.format("Could not acquire lock on %s in behalf of transaction %s. Current owner %s.", lockOwner.key, thisGlobalTransaction, lockOwner.cacheTransaction.getGlobalTransaction()));
    }

    private PendingTransaction waitForTransactionsToComplete(Collection<PendingTransaction> transactionsToCheck, long expectedEndTime) throws InterruptedException {
        if (transactionsToCheck.isEmpty()) {
            return null;
        }
        for (PendingTransaction tx : transactionsToCheck) {
            long remaining = this.timeService.remainingTime(expectedEndTime, TimeUnit.MILLISECONDS);
            if (remaining <= 0L || CompletableFutures.await(tx.keyReleased, remaining, TimeUnit.MILLISECONDS)) continue;
            return tx;
        }
        return null;
    }

    private Collection<PendingTransaction> getTransactionWithLockedKey(int transactionTopologyId, Object key, GlobalTransaction globalTransaction) {
        if (key == null) {
            return Collections.emptyList();
        }
        ArrayList pendingTransactions = new ArrayList();
        this.forEachTransaction(transaction -> {
            CompletableFuture<Void> keyReleasedFuture;
            if (transaction.getTopologyId() < transactionTopologyId && !transaction.getGlobalTransaction().equals(globalTransaction) && (keyReleasedFuture = transaction.getReleaseFutureForKey(key)) != null) {
                pendingTransactions.add(new PendingTransaction((CacheTransaction)transaction, key, keyReleasedFuture));
            }
        });
        return pendingTransactions.isEmpty() ? Collections.emptyList() : pendingTransactions;
    }

    private Collection<PendingTransaction> getTransactionWithAnyLockedKey(int transactionTopologyId, Collection<Object> keys, GlobalTransaction globalTransaction) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList pendingTransactions = new ArrayList();
        this.forEachTransaction(transaction -> {
            KeyValuePair<Object, CompletableFuture<Void>> keyReleaseFuture;
            if (transaction.getTopologyId() < transactionTopologyId && !transaction.getGlobalTransaction().equals(globalTransaction) && (keyReleaseFuture = transaction.getReleaseFutureForKeys(keys)) != null) {
                pendingTransactions.add(new PendingTransaction((CacheTransaction)transaction, keyReleaseFuture.getKey(), keyReleaseFuture.getValue()));
            }
        });
        return pendingTransactions.isEmpty() ? Collections.emptyList() : pendingTransactions;
    }

    private void forEachTransaction(Consumer<CacheTransaction> consumer) {
        Collection<LocalTransaction> localTransactions = this.transactionTable.getLocalTransactions();
        Collection<RemoteTransaction> remoteTransactions = this.transactionTable.getRemoteTransactions();
        int totalSize = localTransactions.size() + remoteTransactions.size();
        if (totalSize == 0) {
            return;
        }
        if (!localTransactions.isEmpty()) {
            localTransactions.forEach(consumer);
        }
        if (!remoteTransactions.isEmpty()) {
            remoteTransactions.forEach(consumer);
        }
    }

    private static long awaitOn(PendingLockPromise pendingLockPromise, GlobalTransaction globalTransaction, long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (pendingLockPromise == PendingLockPromise.NO_OP) {
            return timeUnit.toMillis(timeout);
        }
        assert (pendingLockPromise instanceof PendingLockPromiseImpl);
        ((PendingLockPromiseImpl)pendingLockPromise).await();
        if (pendingLockPromise.hasTimedOut()) {
            DefaultPendingLockManager.timeout(((PendingLockPromiseImpl)pendingLockPromise).getPendingTransaction(), globalTransaction);
        }
        return pendingLockPromise.getRemainingTimeout();
    }

    private class PendingLockPromiseImpl
    implements PendingLockPromise,
    Callable<Void>,
    Runnable {
        private final Collection<PendingTransaction> pendingTransactions;
        private final long expectedEndTime;
        private final CompletableFuture<Void> notifier;
        private volatile PendingTransaction timedOutTransaction;

        private PendingLockPromiseImpl(Collection<PendingTransaction> pendingTransactions, long expectedEndTime) {
            this.pendingTransactions = pendingTransactions;
            this.expectedEndTime = expectedEndTime;
            this.notifier = new CompletableFuture();
        }

        @Override
        public boolean isReady() {
            if (this.timedOutTransaction != null) {
                return true;
            }
            for (PendingTransaction transaction : this.pendingTransactions) {
                if (transaction.keyReleased.isDone()) continue;
                if (DefaultPendingLockManager.this.timeService.remainingTime(this.expectedEndTime, TimeUnit.MILLISECONDS) <= 0L) {
                    this.timedOutTransaction = transaction;
                }
                return this.timedOutTransaction != null;
            }
            return true;
        }

        @Override
        public void addListener(PendingLockListener listener) {
            this.notifier.thenRun(listener::onReady);
        }

        @Override
        public boolean hasTimedOut() {
            return this.timedOutTransaction != null;
        }

        @Override
        public long getRemainingTimeout() {
            return DefaultPendingLockManager.this.timeService.remainingTime(this.expectedEndTime, TimeUnit.MILLISECONDS);
        }

        @Override
        public Void call() throws Exception {
            this.onRelease();
            return null;
        }

        @Override
        public void run() {
            this.onRelease();
        }

        private void onRelease() {
            if (this.isReady()) {
                this.notifier.complete(null);
            }
        }

        private PendingTransaction getPendingTransaction() {
            return this.timedOutTransaction;
        }

        private void registerListenerInCacheTransactions() {
            for (PendingTransaction transaction : this.pendingTransactions) {
                transaction.keyReleased.thenRun(this);
            }
        }

        private void await() throws InterruptedException {
            try {
                this.notifier.get(DefaultPendingLockManager.this.timeService.remainingTime(this.expectedEndTime, TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Should never happen.", e);
            }
            catch (java.util.concurrent.TimeoutException timeoutException) {
                // empty catch block
            }
            this.isReady();
        }
    }

    private static class PendingTransaction {
        private final CacheTransaction cacheTransaction;
        private final Object key;
        private final CompletableFuture<Void> keyReleased;

        private PendingTransaction(CacheTransaction cacheTransaction, Object key, CompletableFuture<Void> keyReleased) {
            this.cacheTransaction = cacheTransaction;
            this.key = key;
            this.keyReleased = Objects.requireNonNull(keyReleased);
        }

        public String toString() {
            return "PendingTransaction{gtx=" + this.cacheTransaction.getGlobalTransaction().globalId() + ", key=" + this.key + '}';
        }
    }
}

