/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.LocalStreamManager;
import org.infinispan.stream.impl.TerminalOperation;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class StreamRequestCommand<K>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 47;
    @Inject
    private LocalStreamManager lsm;
    private Object id;
    private Type type;
    private boolean parallelStream;
    private Set<Integer> segments;
    private Set<K> keys;
    private Set<K> excludedKeys;
    private boolean includeLoader;
    private boolean entryStream;
    private Object terminalOperation;
    private int topologyId = -1;

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public Object getId() {
        return this.id;
    }

    private StreamRequestCommand() {
        super(null);
    }

    public StreamRequestCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StreamRequestCommand(ByteString cacheName, Address origin, Object id, boolean parallelStream, Type type, Set<Integer> segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, boolean entryStream, Object terminalOperation) {
        super(cacheName);
        this.setOrigin(origin);
        this.id = id;
        this.parallelStream = parallelStream;
        this.type = type;
        this.segments = segments;
        this.keys = keys;
        this.excludedKeys = excludedKeys;
        this.includeLoader = includeLoader;
        this.entryStream = entryStream;
        this.terminalOperation = terminalOperation;
    }

    public void inject(LocalStreamManager lsm) {
        this.lsm = lsm;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        switch (this.type) {
            case TERMINAL: {
                this.lsm.streamOperation(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, this.entryStream, (TerminalOperation)this.terminalOperation);
                break;
            }
            case TERMINAL_REHASH: {
                this.lsm.streamOperationRehashAware(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, this.entryStream, (TerminalOperation)this.terminalOperation);
                break;
            }
            case TERMINAL_KEY: {
                this.lsm.streamOperation(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, this.entryStream, (KeyTrackingTerminalOperation)this.terminalOperation);
                break;
            }
            case TERMINAL_KEY_REHASH: {
                this.lsm.streamOperationRehashAware(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, this.entryStream, (KeyTrackingTerminalOperation)this.terminalOperation);
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 47;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        output.writeObject(this.id);
        output.writeBoolean(this.parallelStream);
        MarshallUtil.marshallEnum((Enum)this.type, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.segments, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.excludedKeys, (ObjectOutput)output);
        output.writeBoolean(this.includeLoader);
        output.writeBoolean(this.entryStream);
        output.writeObject(this.terminalOperation);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        this.id = input.readObject();
        this.parallelStream = input.readBoolean();
        this.type = (Type)MarshallUtil.unmarshallEnum((ObjectInput)input, ordinal -> Type.CACHED_VALUES[ordinal]);
        this.segments = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.keys = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.excludedKeys = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.includeLoader = input.readBoolean();
        this.entryStream = input.readBoolean();
        this.terminalOperation = input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StreamRequestCommand{");
        sb.append("type=").append((Object)this.type);
        sb.append(", includeLoader=").append(this.includeLoader);
        sb.append(", terminalOperation=").append(this.terminalOperation);
        sb.append(", topologyId=").append(this.topologyId);
        sb.append(", id=").append(this.id);
        sb.append(", segments=").append(this.segments);
        sb.append(", keys=").append(Util.toStr(this.keys));
        sb.append(", excludedKeys=").append(Util.toStr(this.excludedKeys));
        sb.append('}');
        return sb.toString();
    }

    public static enum Type {
        TERMINAL,
        TERMINAL_REHASH,
        TERMINAL_KEY,
        TERMINAL_KEY_REHASH;

        private static final Type[] CACHED_VALUES;

        static {
            CACHED_VALUES = Type.values();
        }
    }
}

