/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.offheap.Bits;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.TimeService;

public class OffHeapEntryFactoryImpl
implements OffHeapEntryFactory {
    private static final OffHeapMemory MEMORY = OffHeapMemory.INSTANCE;
    private static final byte[] EMPTY_BYTES = new byte[0];
    @Inject
    private Marshaller marshaller;
    @Inject
    private OffHeapMemoryAllocator allocator;
    @Inject
    private TimeService timeService;
    @Inject
    private InternalEntryFactory internalEntryFactory;
    @Inject
    private Configuration configuration;
    private boolean evictionEnabled;
    private static final byte CUSTOM = 1;
    private static final byte HAS_VERSION = 2;
    private static final byte IMMORTAL = 4;
    private static final byte MORTAL = 8;
    private static final byte TRANSIENT = 16;
    private static final byte TRANSIENT_MORTAL = 32;
    private static final int HEADER_LENGTH = 13;

    @Start
    public void start() {
        this.evictionEnabled = this.configuration.memory().isEvictionEnabled();
    }

    @Override
    public long create(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        byte[] metadataBytes;
        byte type;
        boolean shouldWriteMetadataSize = false;
        if (metadata instanceof EmbeddedMetadata) {
            byte[] versionBytes;
            EntryVersion version = metadata.version();
            if (version != null) {
                type = 2;
                shouldWriteMetadataSize = true;
                try {
                    versionBytes = this.marshaller.objectToByteBuffer((Object)version);
                }
                catch (IOException | InterruptedException e) {
                    throw new CacheException((Throwable)e);
                }
            } else {
                type = 0;
                versionBytes = EMPTY_BYTES;
            }
            long lifespan = metadata.lifespan();
            long maxIdle = metadata.maxIdle();
            if (lifespan < 0L && maxIdle < 0L) {
                type = (byte)(type | 4);
                metadataBytes = versionBytes;
            } else if (lifespan > -1L && maxIdle < 0L) {
                type = (byte)(type | 8);
                metadataBytes = new byte[16 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, lifespan);
                Bits.putLong(metadataBytes, 8, this.timeService.wallClockTime());
                System.arraycopy(versionBytes, 0, metadataBytes, 16, versionBytes.length);
            } else if (lifespan < 0L && maxIdle > -1L) {
                type = (byte)(type | 0x10);
                metadataBytes = new byte[16 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, maxIdle);
                Bits.putLong(metadataBytes, 8, this.timeService.wallClockTime());
                System.arraycopy(versionBytes, 0, metadataBytes, 16, versionBytes.length);
            } else {
                type = (byte)(type | 0x20);
                metadataBytes = new byte[32 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, lifespan);
                Bits.putLong(metadataBytes, 8, maxIdle);
                long time = this.timeService.wallClockTime();
                Bits.putLong(metadataBytes, 16, time);
                Bits.putLong(metadataBytes, 24, time);
                System.arraycopy(versionBytes, 0, metadataBytes, 32, versionBytes.length);
            }
        } else {
            type = 1;
            shouldWriteMetadataSize = true;
            try {
                metadataBytes = this.marshaller.objectToByteBuffer((Object)metadata);
            }
            catch (IOException | InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        int keySize = key.getLength();
        int metadataSize = metadataBytes.length;
        int valueSize = value.getLength();
        int offset = this.evictionEnabled ? 16 : 0;
        long totalSize = offset + 8 + 13 + (shouldWriteMetadataSize ? 4 : 0) + keySize + metadataSize + valueSize;
        long memoryAddress = this.allocator.allocate(totalSize);
        MEMORY.putLong(memoryAddress, offset, 0L);
        MEMORY.putByte(memoryAddress, offset += 8, type);
        MEMORY.putInt(memoryAddress, ++offset, key.hashCode());
        MEMORY.putInt(memoryAddress, offset += 4, key.getLength());
        offset += 4;
        if (shouldWriteMetadataSize) {
            MEMORY.putInt(memoryAddress, offset, metadataBytes.length);
            offset += 4;
        }
        MEMORY.putInt(memoryAddress, offset, value.getLength());
        MEMORY.putBytes(key.getBytes(), key.backArrayOffset(), memoryAddress, offset += 4, keySize);
        MEMORY.putBytes(metadataBytes, 0L, memoryAddress, offset += keySize, metadataSize);
        MEMORY.putBytes(value.getBytes(), value.backArrayOffset(), memoryAddress, offset += metadataSize, valueSize);
        assert ((long)(offset += valueSize) == totalSize);
        return memoryAddress;
    }

    @Override
    public long getSize(long entryAddress) {
        int metadataLength;
        int headerOffset = this.evictionEnabled ? 24 : 8;
        byte type = MEMORY.getByte(entryAddress, headerOffset);
        ++headerOffset;
        int keyLength = MEMORY.getInt(entryAddress, headerOffset += 4);
        headerOffset += 4;
        if ((type & 3) != 0) {
            metadataLength = MEMORY.getInt(entryAddress, headerOffset);
            headerOffset += 4;
        } else {
            switch (type) {
                case 8: 
                case 16: {
                    metadataLength = 16;
                    break;
                }
                case 32: {
                    metadataLength = 32;
                    break;
                }
                default: {
                    metadataLength = 0;
                }
            }
        }
        int valueLength = MEMORY.getInt(entryAddress, headerOffset);
        return UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((headerOffset += 4) + keyLength + metadataLength + valueLength);
    }

    @Override
    public long getNext(long entryAddress) {
        return MEMORY.getLong(entryAddress, this.evictionEnabled ? 16L : 0L);
    }

    @Override
    public void setNext(long entryAddress, long value) {
        MEMORY.putLong(entryAddress, this.evictionEnabled ? 16L : 0L, value);
    }

    @Override
    public int getHashCode(long entryAddress) {
        int headerOffset = this.evictionEnabled ? 25 : 9;
        return MEMORY.getInt(entryAddress, headerOffset);
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> fromMemory(long address) {
        long lastUsed;
        long created;
        long maxIdle;
        long lifespan;
        byte[] metadataBytes;
        int offset = this.evictionEnabled ? 24 : 8;
        byte metadataType = MEMORY.getByte(address, offset);
        int hashCode = MEMORY.getInt(address, ++offset);
        byte[] keyBytes = new byte[MEMORY.getInt(address, offset += 4)];
        offset += 4;
        switch (metadataType) {
            case 4: {
                metadataBytes = EMPTY_BYTES;
                break;
            }
            case 8: {
                metadataBytes = new byte[16];
                break;
            }
            case 16: {
                metadataBytes = new byte[16];
                break;
            }
            case 32: {
                metadataBytes = new byte[32];
                break;
            }
            default: {
                metadataBytes = new byte[MEMORY.getInt(address, offset)];
                offset += 4;
            }
        }
        byte[] valueBytes = new byte[MEMORY.getInt(address, offset)];
        MEMORY.getBytes(address, offset += 4, keyBytes, 0L, keyBytes.length);
        MEMORY.getBytes(address, offset += keyBytes.length, metadataBytes, 0L, metadataBytes.length);
        MEMORY.getBytes(address, offset += metadataBytes.length, valueBytes, 0L, valueBytes.length);
        offset += valueBytes.length;
        if ((metadataType & 1) == 1) {
            Metadata metadata;
            try {
                metadata = (Metadata)this.marshaller.objectFromByteBuffer(metadataBytes);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
            return this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), new WrappedByteArray(valueBytes), metadata);
        }
        offset = 0;
        boolean hasVersion = (metadataType & 2) == 2;
        switch (metadataType & 0xFC) {
            case 4: {
                lifespan = -1L;
                maxIdle = -1L;
                created = -1L;
                lastUsed = -1L;
                break;
            }
            case 8: {
                maxIdle = -1L;
                lifespan = Bits.getLong(metadataBytes, offset);
                created = Bits.getLong(metadataBytes, offset += 8);
                lastUsed = -1L;
                break;
            }
            case 16: {
                lifespan = -1L;
                maxIdle = Bits.getLong(metadataBytes, offset);
                created = -1L;
                lastUsed = Bits.getLong(metadataBytes, offset += 8);
                break;
            }
            case 32: {
                lifespan = Bits.getLong(metadataBytes, offset);
                maxIdle = Bits.getLong(metadataBytes, offset += 8);
                created = Bits.getLong(metadataBytes, offset += 8);
                lastUsed = Bits.getLong(metadataBytes, offset += 8);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + metadataType);
            }
        }
        if (hasVersion) {
            try {
                EntryVersion version = (EntryVersion)this.marshaller.objectFromByteBuffer(metadataBytes, offset, metadataBytes.length - offset);
                return this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), new WrappedByteArray(valueBytes), version, created, lifespan, lastUsed, maxIdle);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), new WrappedByteArray(valueBytes), (Metadata)null, created, lifespan, lastUsed, maxIdle);
    }

    @Override
    public boolean equalsKey(long address, WrappedBytes wrappedBytes) {
        int headerOffset = this.evictionEnabled ? 24 : 8;
        byte type = MEMORY.getByte(address, headerOffset);
        int hashCode = wrappedBytes.hashCode();
        if (hashCode != MEMORY.getInt(address, ++headerOffset)) {
            return false;
        }
        int keyLength = MEMORY.getInt(address, headerOffset += 4);
        if (keyLength != wrappedBytes.getLength()) {
            return false;
        }
        headerOffset += 4;
        if (OffHeapEntryFactoryImpl.requiresMetadataSize(type)) {
            headerOffset += 4;
        }
        headerOffset += 4;
        for (int i = 0; i < keyLength; ++i) {
            byte b = MEMORY.getByte(address, headerOffset + i);
            if (b == wrappedBytes.getByte(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isExpired(long address) {
        int offset = this.evictionEnabled ? 24 : 8;
        byte metadataType = MEMORY.getByte(address, offset);
        if ((metadataType & 4) != 0) {
            return false;
        }
        ++offset;
        int keyLength = MEMORY.getInt(address, offset += 4);
        offset += 4;
        long now = this.timeService.wallClockTime();
        if ((metadataType & 1) == 1) {
            return false;
        }
        offset += 4 + keyLength;
        if ((metadataType & 2) != 0) {
            offset += 4;
        }
        switch (metadataType & 0xFC) {
            case 8: {
                byte[] metadataBytes = new byte[16];
                MEMORY.getBytes(address, offset, metadataBytes, 0L, metadataBytes.length);
                return ExpiryHelper.isExpiredMortal(Bits.getLong(metadataBytes, 0), Bits.getLong(metadataBytes, 8), now);
            }
            case 16: {
                byte[] metadataBytes = new byte[16];
                MEMORY.getBytes(address, offset, metadataBytes, 0L, metadataBytes.length);
                return ExpiryHelper.isExpiredTransient(Bits.getLong(metadataBytes, 0), Bits.getLong(metadataBytes, 8), now);
            }
            case 32: {
                byte[] metadataBytes = new byte[32];
                MEMORY.getBytes(address, offset, metadataBytes, 0L, metadataBytes.length);
                long lifespan = Bits.getLong(metadataBytes, 0);
                long maxIdle = Bits.getLong(metadataBytes, 8);
                long created = Bits.getLong(metadataBytes, 16);
                long lastUsed = Bits.getLong(metadataBytes, 24);
                return ExpiryHelper.isExpiredTransientMortal(maxIdle, lastUsed, lifespan, created, now);
            }
        }
        return false;
    }

    private static boolean requiresMetadataSize(byte type) {
        return (type & 3) != 0;
    }

    @Override
    public long calculateSize(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        long totalSize = this.evictionEnabled ? 24L : 8L;
        totalSize += 13L;
        totalSize += (long)(key.getLength() + value.getLength());
        long metadataSize = 0L;
        if (metadata instanceof EmbeddedMetadata) {
            EntryVersion version = metadata.version();
            if (version != null) {
                try {
                    metadataSize += (long)this.marshaller.objectToByteBuffer((Object)version).length;
                }
                catch (IOException | InterruptedException e) {
                    throw new CacheException((Throwable)e);
                }
                metadataSize += 4L;
            }
            if (metadata.maxIdle() >= 0L) {
                metadataSize += 16L;
            }
            if (metadata.lifespan() >= 0L) {
                metadataSize += 16L;
            }
        } else {
            metadataSize += 4L;
            try {
                metadataSize += (long)this.marshaller.objectToByteBuffer((Object)metadata).length;
            }
            catch (IOException | InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(totalSize + metadataSize);
    }
}

