/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComponentsJmxRegistration {
    private static final Log log = LogFactory.getLog(ComponentsJmxRegistration.class);
    private MBeanServer mBeanServer;
    private String jmxDomain;
    private String groupName;
    private Set<AbstractComponentRegistry.Component> components;
    public static String COMPONENT_KEY = "component";
    public static String NAME_KEY = "name";

    public ComponentsJmxRegistration(MBeanServer mBeanServer, Set<AbstractComponentRegistry.Component> components, String groupName) {
        this.mBeanServer = mBeanServer;
        this.components = components;
        this.groupName = groupName;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public void registerMBeans() throws CacheException {
        try {
            List<ResourceDMBean> resourceDMBeans = this.getResourceDMBeansFromComponents();
            for (ResourceDMBean resource : resourceDMBeans) {
                JmxUtil.registerMBean(resource, this.getObjectName(resource), this.mBeanServer);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while registering mbeans", (Throwable)e);
        }
    }

    public void unregisterMBeans() throws CacheException {
        log.trace("Unregistering jmx resources..");
        try {
            List<ResourceDMBean> resourceDMBeans = this.getResourceDMBeansFromComponents();
            for (ResourceDMBean resource : resourceDMBeans) {
                JmxUtil.unregisterMBean(this.getObjectName(resource), this.mBeanServer);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while unregistering mbeans", (Throwable)e);
        }
    }

    private List<ResourceDMBean> getResourceDMBeansFromComponents() throws NoSuchFieldException, ClassNotFoundException {
        ArrayList<ResourceDMBean> resourceDMBeans = new ArrayList<ResourceDMBean>(this.components.size());
        for (AbstractComponentRegistry.Component component : this.components) {
            ComponentMetadata md = component.getMetadata();
            if (!md.isManageable()) continue;
            ResourceDMBean resourceDMBean = new ResourceDMBean(component.getInstance(), md.toManageableComponentMetadata());
            resourceDMBeans.add(resourceDMBean);
        }
        return resourceDMBeans;
    }

    private ObjectName getObjectName(ResourceDMBean resource) throws Exception {
        return this.getObjectName(resource.getObjectName());
    }

    protected ObjectName getObjectName(String resourceName) throws Exception {
        return new ObjectName(ComponentsJmxRegistration.getObjectName(this.jmxDomain, this.groupName, resourceName));
    }

    public static String getObjectName(String jmxDomain, String groupName, String resourceName) {
        return jmxDomain + ":" + groupName + "," + COMPONENT_KEY + "=" + resourceName;
    }
}

