/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupReceiverRepository;
import org.infinispan.xsite.XSiteReplicateCommand;

@Scope(value=Scopes.GLOBAL)
public class GlobalInboundInvocationHandler
implements InboundInvocationHandler {
    private static final Log log = LogFactory.getLog(GlobalInboundInvocationHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    @ComponentName(value="org.infinispan.executors.remote")
    private ExecutorService remoteCommandsExecutor;
    @Inject
    private BackupReceiverRepository backupReceiverRepository;
    @Inject
    private GlobalComponentRegistry globalComponentRegistry;

    private static Response shuttingDownResponse() {
        return CacheNotFoundResponse.INSTANCE;
    }

    private static ExceptionResponse exceptionHandlingCommand(Throwable throwable) {
        return new ExceptionResponse((Exception)((Object)new CacheException("Problems invoking command.", throwable)));
    }

    @Override
    public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        command.setOrigin(origin);
        try {
            if (command.getCommandId() == 30) {
                reply.reply(null);
            } else if (command instanceof CacheRpcCommand) {
                this.handleCacheRpcCommand(origin, (CacheRpcCommand)command, reply, order);
            } else {
                this.handleReplicableCommand(origin, command, reply, order);
            }
        }
        catch (Throwable t) {
            log.exceptionHandlingCommand(command, t);
            reply.reply(GlobalInboundInvocationHandler.exceptionHandlingCommand(t));
        }
    }

    @Override
    public void handleFromRemoteSite(String origin, XSiteReplicateCommand command, Reply reply, DeliverOrder order) {
        if (trace) {
            log.tracef("Handling command %s from remote site %s", command, origin);
        }
        BackupReceiver receiver = this.backupReceiverRepository.getBackupReceiver(origin, command.getCacheName().toString());
        if (order.preserveOrder()) {
            this.runXSiteReplicableCommand(command, receiver, reply);
        } else {
            this.remoteCommandsExecutor.execute(() -> this.runXSiteReplicableCommand(command, receiver, reply));
        }
    }

    private void handleCacheRpcCommand(Address origin, CacheRpcCommand command, Reply reply, DeliverOrder mode) {
        ByteString cacheName;
        ComponentRegistry cr;
        if (trace) {
            log.tracef("Attempting to execute CacheRpcCommand: %s [sender=%s]", command, origin);
        }
        if ((cr = this.globalComponentRegistry.getNamedComponentRegistry(cacheName = command.getCacheName())) == null) {
            if (trace) {
                log.tracef("Silently ignoring that %s cache is not defined", cacheName);
            }
            reply.reply(CacheNotFoundResponse.INSTANCE);
            return;
        }
        this.initializeCacheRpcCommand(command, cr);
        PerCacheInboundInvocationHandler handler = cr.getPerCacheInboundInvocationHandler();
        handler.handle(command, reply, mode);
    }

    private void initializeCacheRpcCommand(CacheRpcCommand command, ComponentRegistry componentRegistry) {
        CommandsFactory commandsFactory = componentRegistry.getCommandsFactory();
        commandsFactory.initializeReplicableCommand(command, true);
    }

    private void runXSiteReplicableCommand(XSiteReplicateCommand command, BackupReceiver receiver, Reply reply) {
        try {
            Object returnValue = command.performInLocalSite(receiver);
            reply.reply(SuccessfulResponse.create(returnValue));
        }
        catch (InterruptedException e) {
            log.shutdownHandlingCommand(command);
            reply.reply(GlobalInboundInvocationHandler.shuttingDownResponse());
        }
        catch (Throwable throwable) {
            log.exceptionHandlingCommand(command, throwable);
            reply.reply(GlobalInboundInvocationHandler.exceptionHandlingCommand(throwable));
        }
    }

    private void handleReplicableCommand(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        if (trace) {
            log.tracef("Attempting to execute non-CacheRpcCommand: %s [sender=%s]", command, origin);
        }
        if (order.preserveOrder() || !command.canBlock()) {
            this.runReplicableCommand(command, reply, order.preserveOrder());
        } else {
            this.remoteCommandsExecutor.execute(() -> this.runReplicableCommand(command, reply, order.preserveOrder()));
        }
    }

    private void runReplicableCommand(ReplicableCommand command, Reply reply, boolean preserveOrder) {
        try {
            this.invokeReplicableCommand(command, reply, preserveOrder);
        }
        catch (Throwable throwable) {
            if (throwable.getCause() != null && throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof InterruptedException || throwable instanceof IllegalLifecycleStateException) {
                log.shutdownHandlingCommand(command);
                reply.reply(GlobalInboundInvocationHandler.shuttingDownResponse());
            }
            log.exceptionHandlingCommand(command, throwable);
            reply.reply(GlobalInboundInvocationHandler.exceptionHandlingCommand(throwable));
        }
    }

    private void invokeReplicableCommand(ReplicableCommand command, Reply reply, boolean preserveOrder) throws Throwable {
        this.globalComponentRegistry.wireDependencies(command);
        CompletableFuture<Object> future = command.invokeAsync();
        if (preserveOrder) {
            Object retVal2 = future.join();
            this.sendResponse(reply, retVal2);
        } else {
            future.whenComplete((retVal, throwable) -> this.sendResponse(reply, retVal));
        }
    }

    private void sendResponse(Reply reply, Object retVal) {
        Response response = retVal == null || retVal instanceof Response ? (Response)retVal : SuccessfulResponse.create(retVal);
        reply.reply(response);
    }
}

