/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.atomic.impl.AtomicKeySetImpl;
import org.infinispan.atomic.impl.TransactionHelper;
import org.infinispan.commons.CacheException;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class FineGrainedAtomicMapProxyImpl<K, V, MK>
extends AbstractMap<K, V>
implements FineGrainedAtomicMap<K, V> {
    private static Log log = LogFactory.getLog(FineGrainedAtomicMap.class);
    private final Cache<Object, Object> cache;
    private final FunctionalMap.ReadOnlyMap<Object, Object> ro;
    private final FunctionalMap.ReadWriteMap<Object, Object> rw;
    private final MK group;
    private final InvocationContextFactory icf;
    private final EntryFactory entryFactory;
    private final TransactionHelper txHelper;

    public FineGrainedAtomicMapProxyImpl(Cache<Object, Object> cache, FunctionalMap.ReadOnlyMap<Object, Object> ro, FunctionalMap.ReadWriteMap<Object, Object> rw, MK group, InvocationContextFactory icf, EntryFactory entryFactory) {
        this.cache = cache;
        this.ro = ro;
        this.rw = rw;
        this.group = group;
        this.icf = icf;
        this.entryFactory = entryFactory;
        this.txHelper = new TransactionHelper(cache.getAdvancedCache());
    }

    public static <K, V, MK> FineGrainedAtomicMap<K, V> newInstance(Cache<Object, Object> cache, MK group, boolean createIfAbsent) {
        if (!cache.getCacheConfiguration().clustering().hash().groups().enabled()) {
            throw log.atomicFineGrainedNeedsGroups();
        }
        if (!cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            throw log.atomicFineGrainedNeedsTransactions();
        }
        FunctionalMapImpl<Object, Object> fmap = FunctionalMapImpl.create(cache.getAdvancedCache());
        FunctionalMap.ReadOnlyMap<Object, Object> ro = ReadOnlyMapImpl.create(fmap);
        FunctionalMap rw = ReadWriteMapImpl.create(fmap).withParams(new Param[]{Param.LockingMode.SKIP});
        InvocationContextFactory icf = cache.getAdvancedCache().getComponentRegistry().getComponent(InvocationContextFactory.class);
        EntryFactory entryFactory = cache.getAdvancedCache().getComponentRegistry().getComponent(EntryFactory.class);
        Set keys = (Set)FineGrainedAtomicMapProxyImpl.wait(ro.eval(group, AtomicKeySetImpl.ReadAll.instance()));
        if (keys != null) {
            InvocationContext ctx = icf.createInvocationContext(false, 1);
            if (ctx.isInTxScope() && ctx.lookupEntry(group) == null) {
                ImmortalCacheEntry entry = new ImmortalCacheEntry(group, AtomicKeySetImpl.create(cache.getName(), group, keys));
                entryFactory.wrapExternalEntry(ctx, group, entry, true, false);
            }
            return new FineGrainedAtomicMapProxyImpl<K, V, MK>(cache, ro, (FunctionalMap.ReadWriteMap<Object, Object>)rw, group, icf, entryFactory);
        }
        if (createIfAbsent) {
            FineGrainedAtomicMapProxyImpl.wait(rw.eval(group, new AtomicKeySetImpl.Touch(ByteString.fromString(cache.getName()))));
            return new FineGrainedAtomicMapProxyImpl<K, V, MK>(cache, ro, (FunctionalMap.ReadWriteMap<Object, Object>)rw, group, icf, entryFactory);
        }
        return null;
    }

    public static void removeMap(Cache<Object, Object> cache, Object group) {
        FunctionalMapImpl<Object, Object> fmap = FunctionalMapImpl.create(cache.getAdvancedCache());
        FunctionalMap rw = ReadWriteMapImpl.create(fmap).withParams(new Param[]{Param.LockingMode.SKIP});
        new TransactionHelper(cache.getAdvancedCache()).run(() -> FineGrainedAtomicMapProxyImpl.lambda$removeMap$0((FunctionalMap.ReadWriteMap)rw, group, cache));
    }

    private static <T> T wait(CompletableFuture<? extends T> cf) {
        try {
            return cf.join();
        }
        catch (CompletionException ce) {
            Throwable e = ce.getCause();
            while (e instanceof CacheException && e.getCause() != null) {
                e = e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw ce;
        }
    }

    private static <K> void removeAll(Cache<Object, Object> cache, Object group, Set<K> keys) {
        ArrayList<CompletableFuture> cfs = new ArrayList<CompletableFuture>(keys.size());
        AdvancedCache<Object, Object> noReturn = cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
        for (K key : keys) {
            cfs.add(noReturn.removeAsync(new AtomicKeySetImpl.Key<Object, K>(group, key)));
        }
        FineGrainedAtomicMapProxyImpl.wait(CompletableFuture.allOf(cfs.toArray(new CompletableFuture[cfs.size()])));
    }

    private Set<K> keys() {
        Set keys = (Set)FineGrainedAtomicMapProxyImpl.wait(this.ro.eval(this.group, AtomicKeySetImpl.ReadAll.instance()));
        if (keys == null) {
            throw log.atomicMapDoesNotExist();
        }
        InvocationContext ctx = this.icf.createInvocationContext(false, 1);
        if (ctx.isInTxScope() && ctx.lookupEntry(this.group) == null) {
            ImmortalCacheEntry entry = new ImmortalCacheEntry(this.group, AtomicKeySetImpl.create(this.cache.getName(), this.group, keys));
            this.entryFactory.wrapExternalEntry(ctx, this.group, entry, true, false);
        }
        return keys;
    }

    private Set<AtomicKeySetImpl.Key<MK, K>> atomicKeys(Set<K> keys) {
        return keys.stream().map(k -> new AtomicKeySetImpl.Key<MK, Object>(this.group, k)).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(new AtomicKeySetImpl.Key<MK, Object>(this.group, key));
    }

    @Override
    public V get(Object key) {
        return (V)this.cache.get(new AtomicKeySetImpl.Key<MK, Object>(this.group, key));
    }

    @Override
    public V put(K key, V value) {
        return (V)this.txHelper.run(() -> {
            Object prev = this.cache.put(new AtomicKeySetImpl.Key<MK, Object>(this.group, key), value);
            FineGrainedAtomicMapProxyImpl.wait(this.rw.eval(this.group, new AtomicKeySetImpl.Add<Object>(key)));
            return prev;
        });
    }

    @Override
    public V remove(Object key) {
        return (V)this.txHelper.run(() -> {
            Object prev = this.cache.remove(new AtomicKeySetImpl.Key<MK, Object>(this.group, key));
            FineGrainedAtomicMapProxyImpl.wait(this.rw.eval(this.group, new AtomicKeySetImpl.Remove<Object>(key)));
            return prev;
        });
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.txHelper.run(() -> {
            this.cache.putAll(m.entrySet().stream().collect(Collectors.toMap(e -> new AtomicKeySetImpl.Key(this.group, e.getKey()), Map.Entry::getValue)));
            FineGrainedAtomicMapProxyImpl.wait(this.rw.eval(this.group, new AtomicKeySetImpl.AddAll(m.keySet())));
            return null;
        });
    }

    @Override
    public void clear() {
        this.txHelper.run(() -> {
            Set keys = (Set)FineGrainedAtomicMapProxyImpl.wait(this.rw.eval(this.group, AtomicKeySetImpl.RemoveAll.instance()));
            FineGrainedAtomicMapProxyImpl.removeAll(this.cache, this.group, keys);
            return null;
        });
    }

    @Override
    public Set<K> keySet() {
        Set<K> keys = this.keys();
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        Stream entryStream = this.cache.getAdvancedCache().getAll(this.atomicKeys(keys)).entrySet().stream();
        return entryStream.filter(e -> e.getValue() != null).map(e -> ((AtomicKeySetImpl.Key)e.getKey()).key()).collect(Collectors.toSet());
    }

    @Override
    public Collection<V> values() {
        Set<K> keys = this.keys();
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<Object> valuesStream = this.cache.getAdvancedCache().getAll(this.atomicKeys(keys)).values().stream().filter(Objects::nonNull);
        return valuesStream.collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keys = this.keys();
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        Stream<Map.Entry> entryStream = this.cache.getAdvancedCache().getAll(this.atomicKeys(keys)).entrySet().stream().filter(e -> e.getValue() != null);
        return entryStream.collect(Collectors.toMap(e -> ((AtomicKeySetImpl.Key)e.getKey()).key(), e1 -> e1.getValue())).entrySet();
    }

    @Override
    public String toString() {
        return "FineGrainedAtomicMapProxyImpl{group=" + this.group + "}";
    }

    private static /* synthetic */ Object lambda$removeMap$0(FunctionalMap.ReadWriteMap rw, Object group, Cache cache) {
        Set keys = (Set)FineGrainedAtomicMapProxyImpl.wait(rw.eval(group, AtomicKeySetImpl.RemoveMap.instance()));
        if (keys != null) {
            FineGrainedAtomicMapProxyImpl.removeAll(cache, group, keys);
        }
        return null;
    }
}

