/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.ConcatIterator;
import org.infinispan.commons.util.FlattenSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.AbstractInternalDataContainer;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;

public class DefaultSegmentedDataContainer<K, V>
extends AbstractInternalDataContainer<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    protected final AtomicReferenceArray<ConcurrentMap<K, InternalCacheEntry<K, V>>> maps;
    protected final Supplier<ConcurrentMap<K, InternalCacheEntry<K, V>>> mapSupplier;
    protected boolean shouldStopSegments;

    public DefaultSegmentedDataContainer(Supplier<ConcurrentMap<K, InternalCacheEntry<K, V>>> mapSupplier, int numSegments) {
        this.maps = new AtomicReferenceArray(numSegments);
        this.mapSupplier = Objects.requireNonNull(mapSupplier);
    }

    @Start
    public void start() {
        for (int i = 0; i < this.maps.length(); ++i) {
            this.startNewMap(i);
        }
        this.shouldStopSegments = this.configuration.clustering().cacheMode().isDistributed();
    }

    @Stop(priority=9999)
    public void stop() {
        for (int i = 0; i < this.maps.length(); ++i) {
            this.stopMap(i, false);
        }
    }

    @Override
    public int getSegmentForKey(Object key) {
        return this.keyPartitioner.getSegment(key);
    }

    @Override
    public ConcurrentMap<K, InternalCacheEntry<K, V>> getMapForSegment(int segment) {
        return this.maps.get(segment);
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator(IntSet segments) {
        return new AbstractInternalDataContainer.EntryIterator(this.iteratorIncludingExpired(segments));
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator() {
        return new AbstractInternalDataContainer.EntryIterator(this.iteratorIncludingExpired());
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator(IntSet segments) {
        return this.filterExpiredEntries(this.spliteratorIncludingExpired(segments));
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator() {
        return this.filterExpiredEntries(this.spliteratorIncludingExpired());
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired(IntSet segments) {
        ArrayList valueIterables = new ArrayList(segments.size());
        segments.forEach(s -> {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(s);
            if (map != null) {
                valueIterables.add(map.values());
            }
        });
        return new ConcatIterator(valueIterables);
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        ArrayList valueIterables = new ArrayList(this.maps.length() + 1);
        for (int i = 0; i < this.maps.length(); ++i) {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(i);
            if (map == null) continue;
            valueIterables.add(map.values());
        }
        return new ConcatIterator(valueIterables);
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired(IntSet segments) {
        int[] segmentArray = segments.toIntArray();
        return new FlattenSpliterator(i -> {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(segmentArray[i]);
            if (map == null) {
                return Collections.emptyList();
            }
            return map.values();
        }, segmentArray.length, 4353);
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        return new FlattenSpliterator(i -> {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(i);
            if (map == null) {
                return Collections.emptyList();
            }
            return map.values();
        }, this.maps.length(), 4353);
    }

    @Override
    public int sizeIncludingExpired(IntSet segment) {
        int size = 0;
        PrimitiveIterator.OfInt iter = segment.iterator();
        while (iter.hasNext()) {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(iter.nextInt());
            if ((size += map != null ? map.size() : 0) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    @Override
    public int sizeIncludingExpired() {
        int size = 0;
        for (int i = 0; i < this.maps.length(); ++i) {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(i);
            if (map == null || (size += map.size()) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.maps.length(); ++i) {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(i);
            if (map == null) continue;
            map.clear();
        }
    }

    @Override
    public void forEach(IntSet segments, Consumer<? super InternalCacheEntry<K, V>> action) {
        Predicate expiredPredicate = this.expiredIterationPredicate(this.timeService.wallClockTime());
        BiConsumer<Object, InternalCacheEntry> biConsumer = (k, ice) -> {
            if (expiredPredicate.test(ice)) {
                action.accept((Object)ice);
            }
        };
        segments.forEach(s -> {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(s);
            if (map != null) {
                map.forEach(biConsumer);
            }
        });
    }

    @Override
    public void addSegments(IntSet segments) {
        if (this.shouldStopSegments) {
            if (trace) {
                log.tracef("Ensuring segments %s are started", (Object)segments);
            }
            segments.forEach(this::startNewMap);
        }
    }

    @Override
    public void removeSegments(IntSet segments) {
        if (this.shouldStopSegments) {
            if (trace) {
                log.tracef("Removing segments: %s from container", (Object)segments);
            }
            PrimitiveIterator.OfInt segmentIterator = segments.iterator();
            while (segmentIterator.hasNext()) {
                int segment = segmentIterator.nextInt();
                this.stopMap(segment, true);
            }
        }
    }

    private void startNewMap(int segment) {
        ConcurrentMap<K, InternalCacheEntry<K, V>> newMap;
        if (this.maps.get(segment) == null && !this.maps.compareAndSet(segment, null, newMap = this.mapSupplier.get()) && newMap instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)newMap)).close();
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    private void stopMap(int segment, boolean notifyListener) {
        ConcurrentMap map = this.maps.getAndSet(segment, null);
        if (map != null) {
            if (notifyListener && !map.isEmpty()) {
                this.listeners.forEach(c -> c.accept(map.values()));
            }
            if (map instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)map)).close();
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
            }
        }
    }
}

