/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.function.BiFunction;
import org.infinispan.atomic.CopyableDeltaAware;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;

public final class ApplyDelta<K>
implements BiFunction<Object, EntryView.ReadWriteEntryView<K, Object>, Object> {
    private final Marshaller marshaller;

    public ApplyDelta(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public Object apply(Object d, EntryView.ReadWriteEntryView<K, Object> view) {
        if (!(d instanceof Delta)) {
            throw new IllegalArgumentException("Expected delta, argument is " + d);
        }
        Delta delta = (Delta)d;
        if (view.find().isPresent()) {
            DeltaAware deltaAware;
            Object value = view.find().get();
            if (value instanceof CopyableDeltaAware) {
                deltaAware = ((CopyableDeltaAware)value).copy();
            } else if (value instanceof DeltaAware) {
                try {
                    byte[] bytes = this.marshaller.objectToByteBuffer(value);
                    deltaAware = (DeltaAware)this.marshaller.objectFromByteBuffer(bytes);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CacheException("Object copy interrupted", (Throwable)e);
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new CacheException("Cannot copy " + value, (Throwable)e);
                }
            } else {
                throw new IllegalArgumentException("Cache contains " + value + " which does not implement DeltaAware");
            }
            view.set((Object)delta.merge(deltaAware), new MetaParam.Writable[0]);
            return value;
        }
        view.set((Object)delta.merge(null), new MetaParam.Writable[0]);
        return null;
    }

    @Deprecated
    public static class Externalizer
    implements AdvancedExternalizer<ApplyDelta> {
        private final GlobalComponentRegistry gcr;

        public Externalizer(GlobalComponentRegistry gcr) {
            this.gcr = gcr;
        }

        public Set<Class<? extends ApplyDelta>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{ApplyDelta.class});
        }

        public Integer getId() {
            return 117;
        }

        public void writeObject(ObjectOutput output, ApplyDelta object) throws IOException {
        }

        public ApplyDelta readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new ApplyDelta(this.gcr.getComponent(Marshaller.class));
        }
    }
}

