/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.util.Collections;
import java.util.Set;

public class SubjectACL {
    private final Set<String> roles;
    private final int mask;

    public SubjectACL(Set<String> roles, int mask) {
        this.roles = Collections.unmodifiableSet(roles);
        this.mask = mask;
    }

    public int getMask() {
        return this.mask;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean containsRole(String role) {
        return this.roles.contains(role);
    }

    public boolean matches(int permissionMask) {
        return (this.mask & permissionMask) == permissionMask;
    }

    public String toString() {
        return "SubjectACL [roles=" + this.roles + ", mask=" + this.mask + "]";
    }
}

