/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.infinispan.Cache;
import org.infinispan.cdi.ContextInputCache;
import org.infinispan.cdi.util.BeanManagerProvider;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.spi.MapReduceTaskLifecycle;

public class CDIMapReduceTaskLifecycle
implements MapReduceTaskLifecycle {
    @Override
    public <KIn, VIn, KOut, VOut> void onPreExecute(Mapper<KIn, VIn, KOut, VOut> mapper, Cache<KIn, VIn> inputCache) {
        BeanManager bm = BeanManagerProvider.getInstance().getBeanManager();
        ContextInputCache.set(inputCache);
        Class<?> clazz = mapper.getClass();
        AnnotatedType type = bm.createAnnotatedType(clazz);
        InjectionTarget it = bm.createInjectionTarget(type);
        CreationalContext ctx = bm.createCreationalContext(null);
        it.inject(mapper, ctx);
        it.postConstruct(mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <KIn, VIn, KOut, VOut> void onPostExecute(Mapper<KIn, VIn, KOut, VOut> mapper) {
        try {
            BeanManager bm = BeanManagerProvider.getInstance().getBeanManager();
            Class<?> clazz = mapper.getClass();
            AnnotatedType type = bm.createAnnotatedType(clazz);
            InjectionTarget it = bm.createInjectionTarget(type);
            it.preDestroy(mapper);
            it.dispose(mapper);
        }
        finally {
            ContextInputCache.clean();
        }
    }

    @Override
    public <KOut, VOut> void onPreExecute(Reducer<KOut, VOut> reducer, Cache<?, ?> cache) {
        BeanManager bm = BeanManagerProvider.getInstance().getBeanManager();
        Class<?> clazz = reducer.getClass();
        AnnotatedType type = bm.createAnnotatedType(clazz);
        InjectionTarget it = bm.createInjectionTarget(type);
        CreationalContext ctx = bm.createCreationalContext(null);
        it.inject(reducer, ctx);
        it.postConstruct(reducer);
    }

    @Override
    public <KOut, VOut> void onPostExecute(Reducer<KOut, VOut> reducer) {
        BeanManager bm = BeanManagerProvider.getInstance().getBeanManager();
        Class<?> clazz = reducer.getClass();
        AnnotatedType type = bm.createAnnotatedType(clazz);
        InjectionTarget it = bm.createInjectionTarget(type);
        it.preDestroy(reducer);
        it.dispose(reducer);
    }
}

