/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachemanagerlistener;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.Transaction;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.MergeEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.impl.EventImpl;
import org.infinispan.notifications.impl.AbstractListenerImpl;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheManagerNotifierImpl
extends AbstractListenerImpl<Event, ListenerInvocation<Event>>
implements CacheManagerNotifier {
    private static final Log log = LogFactory.getLog(CacheManagerNotifierImpl.class);
    private static final Map<Class<? extends Annotation>, Class<?>> allowedListeners = new HashMap(4);
    final List<ListenerInvocation<Event>> cacheStartedListeners = new CopyOnWriteArrayList<ListenerInvocation<Event>>();
    final List<ListenerInvocation<Event>> cacheStoppedListeners = new CopyOnWriteArrayList<ListenerInvocation<Event>>();
    final List<ListenerInvocation<Event>> viewChangedListeners = new CopyOnWriteArrayList<ListenerInvocation<Event>>();
    final List<ListenerInvocation<Event>> mergeListeners = new CopyOnWriteArrayList<ListenerInvocation<Event>>();
    private EmbeddedCacheManager cacheManager;

    public CacheManagerNotifierImpl() {
        this.listenersMap.put(CacheStarted.class, this.cacheStartedListeners);
        this.listenersMap.put(CacheStopped.class, this.cacheStoppedListeners);
        this.listenersMap.put(ViewChanged.class, this.viewChangedListeners);
        this.listenersMap.put(Merged.class, this.mergeListeners);
    }

    @Inject
    public void injectCacheManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void notifyViewChange(List<Address> members, List<Address> oldMembers, Address myAddress, int viewId) {
        if (!this.viewChangedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setLocalAddress(myAddress);
            e.setMergeView(false);
            e.setViewId(viewId);
            e.setNewMembers(members);
            e.setOldMembers(oldMembers);
            e.setCacheManager(this.cacheManager);
            e.setType(Event.Type.VIEW_CHANGED);
            for (ListenerInvocation<Event> listener : this.viewChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyMerge(List<Address> members, List<Address> oldMembers, Address myAddress, int viewId, List<List<Address>> subgroupsMerged) {
        if (!this.mergeListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setLocalAddress(myAddress);
            e.setViewId(viewId);
            e.setMergeView(true);
            e.setNewMembers(members);
            e.setOldMembers(oldMembers);
            e.setCacheManager(this.cacheManager);
            e.setSubgroupsMerged(subgroupsMerged);
            e.setType(Event.Type.MERGED);
            for (ListenerInvocation<Event> listener : this.mergeListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheStarted(String cacheName) {
        if (!this.cacheStartedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCacheName(cacheName);
            e.setCacheManager(this.cacheManager);
            e.setType(Event.Type.CACHE_STARTED);
            for (ListenerInvocation<Event> listener : this.cacheStartedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheStopped(String cacheName) {
        if (!this.cacheStoppedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCacheName(cacheName);
            e.setCacheManager(this.cacheManager);
            e.setType(Event.Type.CACHE_STOPPED);
            for (ListenerInvocation<Event> listener : this.cacheStoppedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void addListener(Object listener) {
        this.validateAndAddListenerInvocation(listener, new DefaultBuilder());
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations(Listener l) {
        return allowedListeners;
    }

    @Override
    protected final Transaction suspendIfNeeded() {
        return null;
    }

    @Override
    protected final void resumeIfNeeded(Transaction transaction) {
    }

    static {
        allowedListeners.put(CacheStarted.class, CacheStartedEvent.class);
        allowedListeners.put(CacheStopped.class, CacheStoppedEvent.class);
        allowedListeners.put(ViewChanged.class, ViewChangedEvent.class);
        allowedListeners.put(Merged.class, MergeEvent.class);
    }

    protected class DefaultBuilder
    extends AbstractListenerImpl.AbstractInvocationBuilder {
        protected DefaultBuilder() {
            super(CacheManagerNotifierImpl.this);
        }

        public ListenerInvocation<Event> build() {
            return new AbstractListenerImpl.ListenerInvocationImpl<Event>(CacheManagerNotifierImpl.this, this.target, this.method, this.sync, this.classLoader, this.subject);
        }
    }
}

