/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.TimeoutValidationResponseFilter;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class KeysValidateFilter
implements TimeoutValidationResponseFilter {
    private static final Log log = LogFactory.getLog(KeysValidateFilter.class);
    private final Address localAddress;
    private final Set<Object> keysAwaitingValidation;
    private boolean selfDelivered;

    public KeysValidateFilter(Address localAddress, Set<Object> keysAwaitingValidation) {
        this.localAddress = localAddress;
        this.keysAwaitingValidation = new HashSet<Object>(keysAwaitingValidation);
        this.selfDelivered = false;
    }

    @Override
    public synchronized boolean isAcceptable(Response response, Address sender) {
        if (sender.equals(this.localAddress)) {
            this.selfDelivered = true;
        }
        if (response instanceof SuccessfulResponse) {
            Object retVal = ((SuccessfulResponse)response).getResponseValue();
            if (retVal instanceof Collection) {
                this.keysAwaitingValidation.removeAll((Collection)retVal);
                if (log.isTraceEnabled()) {
                    log.tracef("Received keys validated: %s. Awaiting validation of %s. Self Delivered? %s", retVal, (Object)this.keysAwaitingValidation, (Object)this.selfDelivered);
                }
            } else if (retVal instanceof EntryVersionsMap) {
                this.keysAwaitingValidation.removeAll(((EntryVersionsMap)retVal).keySet());
                if (log.isTraceEnabled()) {
                    log.tracef("Received keys validated: %s. Awaiting validation of %s. Self Delivered? %s", (Object)((EntryVersionsMap)retVal).keySet(), (Object)this.keysAwaitingValidation, (Object)this.selfDelivered);
                }
            } else {
                log.unexpectedResponse(retVal.getClass().toString(), "Collection or EntryVersionMap");
            }
        }
        return true;
    }

    @Override
    public synchronized boolean needMoreResponses() {
        return !this.selfDelivered || !this.keysAwaitingValidation.isEmpty();
    }

    @Override
    public synchronized void validate() throws TimeoutException {
        if (!this.selfDelivered) {
            throw new TimeoutException("Timeout waiting for member " + this.localAddress);
        }
        if (!this.keysAwaitingValidation.isEmpty()) {
            throw new TimeoutException("Timeout waiting for the validation of keys: " + this.keysAwaitingValidation);
        }
    }
}

