/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.iq80.leveldb.impl;

import infinispan.org.iq80.leveldb.impl.FileChannelLogWriter;
import infinispan.org.iq80.leveldb.impl.Iq80DBFactory;
import infinispan.org.iq80.leveldb.impl.LogWriter;
import infinispan.org.iq80.leveldb.impl.MMapLogWriter;
import infinispan.org.iq80.leveldb.util.PureJavaCrc32C;
import infinispan.org.iq80.leveldb.util.Slice;
import java.io.File;
import java.io.IOException;

public final class Logs {
    private Logs() {
    }

    public static LogWriter createLogWriter(File file, long fileNumber) throws IOException {
        if (Iq80DBFactory.USE_MMAP) {
            return new MMapLogWriter(file, fileNumber);
        }
        return new FileChannelLogWriter(file, fileNumber);
    }

    public static int getChunkChecksum(int chunkTypeId, Slice slice) {
        return Logs.getChunkChecksum(chunkTypeId, slice.getRawArray(), slice.getRawOffset(), slice.length());
    }

    public static int getChunkChecksum(int chunkTypeId, byte[] buffer, int offset, int length) {
        PureJavaCrc32C crc32C = new PureJavaCrc32C();
        crc32C.update(chunkTypeId);
        crc32C.update(buffer, offset, length);
        return crc32C.getMaskedValue();
    }
}

