/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.DataContainerConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.DataContainer;

public class DataContainerConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<DataContainerConfiguration> {
    private AttributeSet attributes = DataContainerConfiguration.attributeDefinitionSet();

    DataContainerConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public DataContainerConfigurationBuilder dataContainer(DataContainer dataContainer) {
        this.attributes.attribute(DataContainerConfiguration.DATA_CONTAINER).set(dataContainer);
        return this;
    }

    public DataContainerConfigurationBuilder addProperty(String key, String value) {
        TypedProperties properties = this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        properties.put(key, value);
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set(TypedProperties.toTypedProperties(properties));
        return this;
    }

    public DataContainerConfigurationBuilder withProperties(Properties props) {
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set(TypedProperties.toTypedProperties(props));
        return this;
    }

    public <K> DataContainerConfigurationBuilder keyEquivalence(Equivalence<K> keyEquivalence) {
        this.attributes.attribute(DataContainerConfiguration.KEY_EQUIVALENCE).set(keyEquivalence);
        return this;
    }

    public <V> DataContainerConfigurationBuilder valueEquivalence(Equivalence<V> valueEquivalence) {
        this.attributes.attribute(DataContainerConfiguration.VALUE_EQUIVALENCE).set(valueEquivalence);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public DataContainerConfiguration create() {
        return new DataContainerConfiguration(this.attributes.protect());
    }

    public DataContainerConfigurationBuilder read(DataContainerConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "DataContainerConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

