/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class ExpirationConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ExpirationConfiguration> {
    private final AttributeSet attributes = ExpirationConfiguration.attributeDefinitionSet();

    ExpirationConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public ExpirationConfigurationBuilder lifespan(long l) {
        this.attributes.attribute(ExpirationConfiguration.LIFESPAN).set(l);
        return this;
    }

    public ExpirationConfigurationBuilder lifespan(long l, TimeUnit unit) {
        return this.lifespan(unit.toMillis(l));
    }

    public ExpirationConfigurationBuilder maxIdle(long l) {
        this.attributes.attribute(ExpirationConfiguration.MAX_IDLE).set(l);
        return this;
    }

    public ExpirationConfigurationBuilder maxIdle(long l, TimeUnit unit) {
        return this.maxIdle(unit.toMillis(l));
    }

    public ExpirationConfigurationBuilder enableReaper() {
        this.attributes.attribute(ExpirationConfiguration.REAPER_ENABLED).set(true);
        return this;
    }

    public ExpirationConfigurationBuilder reaperEnabled(boolean enabled) {
        this.attributes.attribute(ExpirationConfiguration.REAPER_ENABLED).set(enabled);
        return this;
    }

    public ExpirationConfigurationBuilder disableReaper() {
        this.attributes.attribute(ExpirationConfiguration.REAPER_ENABLED).set(false);
        return this;
    }

    public ExpirationConfigurationBuilder wakeUpInterval(long l) {
        this.attributes.attribute(ExpirationConfiguration.WAKEUP_INTERVAL).set(l);
        return this;
    }

    public ExpirationConfigurationBuilder wakeUpInterval(long l, TimeUnit unit) {
        return this.wakeUpInterval(unit.toMillis(l));
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public ExpirationConfiguration create() {
        return new ExpirationConfiguration(this.attributes.protect());
    }

    public ExpirationConfigurationBuilder read(ExpirationConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.attributes;
    }
}

