/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;

public class HashConfiguration {
    public static final AttributeDefinition<ConsistentHashFactory> CONSISTENT_HASH_FACTORY = AttributeDefinition.builder("consistentHashFactory", null, ConsistentHashFactory.class).immutable().build();
    public static final AttributeDefinition<Hash> HASH = AttributeDefinition.builder("hash", MurmurHash3.getInstance()).copier(IdentityAttributeCopier.INSTANCE).immutable().build();
    public static final AttributeDefinition<Integer> NUM_OWNERS = AttributeDefinition.builder("numOwners", 2).immutable().build();
    public static final AttributeDefinition<Integer> NUM_SEGMENTS = AttributeDefinition.builder("numSegments", 60).immutable().build();
    public static final AttributeDefinition<Float> CAPACITY_FACTOR = AttributeDefinition.builder("capacityFactor", Float.valueOf(1.0f)).immutable().build();
    private final Attribute<ConsistentHashFactory> consistentHashFactory;
    private final Attribute<Hash> hash;
    private final Attribute<Integer> numOwners;
    private final Attribute<Integer> numSegments;
    private final Attribute<Float> capacityFactor;
    private final GroupsConfiguration groupsConfiguration;
    private final StateTransferConfiguration stateTransferConfiguration;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(HashConfiguration.class, CONSISTENT_HASH_FACTORY, HASH, NUM_OWNERS, NUM_SEGMENTS, CAPACITY_FACTOR);
    }

    HashConfiguration(AttributeSet attributes, GroupsConfiguration groupsConfiguration, StateTransferConfiguration stateTransferConfiguration) {
        this.attributes = attributes.checkProtection();
        this.groupsConfiguration = groupsConfiguration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.consistentHashFactory = attributes.attribute(CONSISTENT_HASH_FACTORY);
        this.hash = attributes.attribute(HASH);
        this.numOwners = attributes.attribute(NUM_OWNERS);
        this.numSegments = attributes.attribute(NUM_SEGMENTS);
        this.capacityFactor = attributes.attribute(CAPACITY_FACTOR);
    }

    @Deprecated
    public ConsistentHash consistentHash() {
        return null;
    }

    public ConsistentHashFactory<?> consistentHashFactory() {
        return this.consistentHashFactory.get();
    }

    public Hash hash() {
        return this.hash.get();
    }

    public int numOwners() {
        return this.numOwners.get();
    }

    @Deprecated
    public int numVirtualNodes() {
        return 1;
    }

    public int numSegments() {
        return this.numSegments.get();
    }

    @Deprecated
    public boolean rehashEnabled() {
        return this.stateTransferConfiguration.fetchInMemoryState();
    }

    @Deprecated
    public long rehashRpcTimeout() {
        return this.stateTransferConfiguration.timeout();
    }

    @Deprecated
    public long rehashWait() {
        return this.stateTransferConfiguration.timeout();
    }

    public float capacityFactor() {
        return this.capacityFactor.get().floatValue();
    }

    public GroupsConfiguration groups() {
        return this.groupsConfiguration;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "HashConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashConfiguration other = (HashConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

