/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ExpirationManagerImpl<K, V>
implements ExpirationManager<K, V> {
    private static final Log log = LogFactory.getLog(ExpirationManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    ScheduledFuture<?> expirationTask;
    private ScheduledExecutorService executor;
    private Configuration configuration;
    private PersistenceManager persistenceManager;
    private DataContainer<K, V> dataContainer;
    private CacheNotifier<K, V> cacheNotifier;
    private TimeService timeService;
    private boolean enabled;
    private String cacheName;

    @Inject
    public void initialize(@ComponentName(value="org.infinispan.executors.expiration") ScheduledExecutorService executor, Cache<K, V> cache, Configuration cfg, DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, CacheNotifier<K, V> cacheNotifier, TimeService timeService) {
        this.initialize(executor, cache.getName(), cfg, dataContainer, persistenceManager, cacheNotifier, timeService);
    }

    void initialize(ScheduledExecutorService executor, String cacheName, Configuration cfg, DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, CacheNotifier<K, V> cacheNotifier, TimeService timeService) {
        this.executor = executor;
        this.configuration = cfg;
        this.cacheName = cacheName;
        this.dataContainer = dataContainer;
        this.persistenceManager = persistenceManager;
        this.cacheNotifier = cacheNotifier;
        this.timeService = timeService;
    }

    @Start(priority=55)
    public void start() {
        this.enabled = this.configuration.expiration().reaperEnabled();
        if (this.enabled) {
            long expWakeUpInt = this.configuration.expiration().wakeUpInterval();
            if (expWakeUpInt <= 0L) {
                log.notStartingEvictionThread();
                this.enabled = false;
            } else {
                this.expirationTask = this.executor.scheduleWithFixedDelay(new ScheduledTask(), expWakeUpInt, expWakeUpInt, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void processExpiration() {
        long start = 0L;
        if (!Thread.currentThread().isInterrupted()) {
            try {
                if (trace) {
                    log.trace("Purging data container of expired entries");
                    start = this.timeService.time();
                }
                this.dataContainer.purgeExpired();
                if (trace) {
                    log.tracef("Purging data container completed in %s", (Object)Util.prettyPrintTime(this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
                }
            }
            catch (Exception e) {
                log.exceptionPurgingDataContainer(e);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.persistenceManager.purgeExpired();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Stop(priority=5)
    public void stop() {
        if (this.expirationTask != null) {
            this.expirationTask.cancel(true);
        }
    }

    class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogFactory.pushNDC(ExpirationManagerImpl.this.cacheName, trace);
            try {
                ExpirationManagerImpl.this.processExpiration();
            }
            finally {
                LogFactory.popNDC(trace);
            }
        }
    }
}

