/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.Externalizable;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.commons.util.Util;
import org.infinispan.io.GridFilesystem;
import org.infinispan.io.ModularArithmetic;

public class GridFile
extends File {
    private static final long serialVersionUID = 552534285862004134L;
    private static final Metadata ROOT_DIR_METADATA = new Metadata(0, 0L, 0, 2);
    private static final char SEPARATOR_CHAR = '/';
    private static final String SEPARATOR = "/";
    private final AdvancedCache<String, Metadata> metadataCache;
    private final GridFilesystem fs;
    private final String path;
    private int chunkSize;

    GridFile(String pathname, Cache<String, Metadata> metadataCache, int chunkSize, GridFilesystem fs) {
        super(pathname);
        this.fs = fs;
        this.path = GridFile.formatPath(pathname);
        this.metadataCache = metadataCache.getAdvancedCache();
        this.chunkSize = ModularArithmetic.CANNOT_ASSUME_DENOM_IS_POWER_OF_TWO ? chunkSize : Util.findNextHighestPowerOfTwo(chunkSize);
        this.initChunkSizeFromMetadata();
    }

    GridFile(String parent, String child, Cache<String, Metadata> metadataCache, int chunkSize, GridFilesystem fs) {
        this(parent + File.separator + child, metadataCache, chunkSize, fs);
    }

    GridFile(File parent, String child, Cache<String, Metadata> metadataCache, int chunkSize, GridFilesystem fs) {
        this(parent.getPath(), child, metadataCache, chunkSize, fs);
    }

    @Override
    public String getName() {
        return GridFile.filename(this.getPath());
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getAbsolutePath() {
        return this.convertToAbsolute(this.getPath());
    }

    @Override
    public File getAbsoluteFile() {
        return new GridFile(this.getAbsolutePath(), this.metadataCache, this.getChunkSize(), this.fs);
    }

    @Override
    public String getCanonicalPath() throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public File getCanonicalFile() throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isAbsolute() {
        return this.getPath().startsWith(SEPARATOR);
    }

    @Override
    public boolean renameTo(File dest) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void deleteOnExit() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private String convertToAbsolute(String path) {
        if (!path.startsWith(SEPARATOR)) {
            return SEPARATOR + path;
        }
        return path;
    }

    private static String formatPath(String path) {
        int index;
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')) != null && path.endsWith(SEPARATOR) && (index = path.lastIndexOf(SEPARATOR)) != -1) {
            path = path.substring(0, index);
        }
        return path;
    }

    @Override
    public long length() {
        Metadata metadata = this.getMetadata();
        if (metadata != null) {
            return metadata.length;
        }
        return 0L;
    }

    private Metadata getMetadata() {
        if (this.isRootDir()) {
            return ROOT_DIR_METADATA;
        }
        return (Metadata)this.metadataCache.get(this.getAbsolutePath());
    }

    private boolean isRootDir() {
        return SEPARATOR.equals(this.getAbsolutePath());
    }

    void setLength(int newLength) {
        Metadata metadata = this.getMetadata();
        if (metadata == null) {
            throw new IllegalStateException("metadata for " + this.getAbsolutePath() + " not found.");
        }
        metadata.setLength(newLength);
        metadata.setModificationTime(System.currentTimeMillis());
        this.metadataCache.put(this.getAbsolutePath(), metadata);
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (this.exists()) {
            return false;
        }
        if (!this.checkParentDirs(this.getAbsolutePath(), false)) {
            throw new IOException("Cannot create file " + this.getAbsolutePath() + " (parent dir does not exist)");
        }
        this.metadataCache.put(this.getAbsolutePath(), new Metadata(0, System.currentTimeMillis(), this.chunkSize, 1));
        return true;
    }

    @Override
    public boolean delete() {
        if (!this.exists()) {
            return false;
        }
        if (this.isDirectory() && this.hasChildren()) {
            return false;
        }
        this.fs.remove(this.getAbsolutePath());
        this.metadataCache.remove(this.getAbsolutePath());
        return true;
    }

    private boolean hasChildren() {
        File[] files = this.listFiles();
        return files != null && files.length > 0;
    }

    @Override
    public boolean mkdir() {
        return this.mkdir(false);
    }

    @Override
    public boolean mkdirs() {
        return this.mkdir(true);
    }

    private boolean mkdir(boolean alsoCreateParentDirs) {
        try {
            boolean parentsExist = this.checkParentDirs(this.getAbsolutePath(), alsoCreateParentDirs);
            if (!parentsExist) {
                return false;
            }
            this.metadataCache.put(this.getAbsolutePath(), new Metadata(0, System.currentTimeMillis(), this.chunkSize, 2));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean exists() {
        return this.getMetadata() != null;
    }

    @Override
    public String getParent() {
        return GridFile.formatPath(super.getParent());
    }

    @Override
    public File getParentFile() {
        String parentPath = this.getParent();
        if (parentPath == null) {
            return null;
        }
        return new GridFile(parentPath, this.metadataCache, this.chunkSize, this.fs);
    }

    @Override
    public long lastModified() {
        Metadata metadata = this.getMetadata();
        return metadata == null ? 0L : metadata.getModificationTime();
    }

    @Override
    public boolean setLastModified(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        Metadata metadata = this.getMetadata();
        if (metadata == null) {
            return false;
        }
        metadata.setModificationTime(time);
        this.metadataCache.put(this.getAbsolutePath(), metadata);
        return true;
    }

    @Override
    public String[] list() {
        return this.list(null);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        return this._list(filter);
    }

    @Override
    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        return this._listFiles(filter);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        return this._listFiles(filter);
    }

    @Override
    public boolean isDirectory() {
        Metadata metadata = this.getMetadata();
        return metadata != null && metadata.isDirectory();
    }

    @Override
    public boolean isFile() {
        Metadata metadata = this.getMetadata();
        return metadata != null && metadata.isFile();
    }

    protected void initChunkSizeFromMetadata() {
        Metadata metadata = this.getMetadata();
        if (metadata != null) {
            this.chunkSize = metadata.getChunkSize();
        }
    }

    protected File[] _listFiles(Object filter) {
        String[] filenames = this._list(filter);
        return this.convertFilenamesToFiles(filenames);
    }

    private File[] convertFilenamesToFiles(String[] files) {
        if (files == null) {
            return null;
        }
        File[] retval = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            retval[i] = new GridFile(this, files[i], this.metadataCache, this.chunkSize, this.fs);
        }
        return retval;
    }

    protected String[] _list(Object filter) {
        if (!this.isDirectory()) {
            return null;
        }
        CloseableIteratorSet paths = this.metadataCache.keySet();
        LinkedList<String> list = new LinkedList<String>();
        for (String path : paths) {
            if (!GridFile.isChildOf(this.getAbsolutePath(), path) || filter instanceof FilenameFilter && !((FilenameFilter)filter).accept(this, GridFile.filename(path)) || filter instanceof FileFilter && !((FileFilter)filter).accept(new File(path))) continue;
            list.add(GridFile.filename(path));
        }
        return list.toArray(new String[list.size()]);
    }

    protected static boolean isChildOf(String parent, String child) {
        if (parent == null || child == null) {
            return false;
        }
        if (!child.startsWith(parent.endsWith(SEPARATOR) ? parent : parent + SEPARATOR)) {
            return false;
        }
        if (child.length() <= parent.length()) {
            return false;
        }
        int from = parent.equals(SEPARATOR) ? parent.length() : parent.length() + 1;
        String[] comps = org.jgroups.util.Util.components(child.substring(from), SEPARATOR);
        return comps != null && comps.length <= 1;
    }

    protected static String filename(String fullPath) {
        String[] comps = org.jgroups.util.Util.components(fullPath, SEPARATOR);
        return comps != null ? comps[comps.length - 1] : "";
    }

    protected boolean checkParentDirs(String path, boolean createIfAbsent) throws IOException {
        String[] components = org.jgroups.util.Util.components(path, SEPARATOR);
        if (components == null) {
            return false;
        }
        if (components.length == 1) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < components.length - 1; ++i) {
            String tmp = components[i];
            if (!tmp.equals(SEPARATOR)) {
                if (first) {
                    first = false;
                } else {
                    sb.append(SEPARATOR);
                }
            }
            sb.append(tmp);
            String comp = sb.toString();
            if (comp.equals(SEPARATOR)) continue;
            Metadata val = this.exists(comp);
            if (val != null) {
                if (!val.isFile()) continue;
                throw new IOException(String.format("cannot create %s as component %s is a file", path, comp));
            }
            if (createIfAbsent) {
                this.metadataCache.put(comp, new Metadata(0, System.currentTimeMillis(), this.chunkSize, 2));
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GridFile) {
            return this.compareTo((GridFile)obj) == 0;
        }
        return false;
    }

    @Override
    public boolean canRead() {
        return this.isFile();
    }

    @Override
    public boolean canWrite() {
        return this.isFile();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public int compareTo(File file) {
        return this.getAbsolutePath().compareTo(file.getAbsolutePath());
    }

    @Override
    public int hashCode() {
        return this.getAbsolutePath().hashCode();
    }

    @Override
    public String toString() {
        return "GridFile{path='" + this.path + '\'' + '}';
    }

    @Override
    public URL toURL() throws MalformedURLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public URI toURI() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean setReadOnly() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean setWritable(boolean writable) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean setReadable(boolean readable) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean setExecutable(boolean executable) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public long getTotalSpace() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public long getFreeSpace() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public long getUsableSpace() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private Metadata exists(String key) {
        return (Metadata)this.metadataCache.get(key);
    }

    public static class Metadata
    implements Externalizable {
        public static final byte FILE = 1;
        public static final byte DIR = 2;
        private int length = 0;
        private long modificationTime = 0L;
        private int chunkSize;
        private byte flags;

        public Metadata() {
            this.chunkSize = 1;
            this.flags = 0;
        }

        public Metadata(int length, long modificationTime, int chunkSize, byte flags) {
            this.length = length;
            this.modificationTime = modificationTime;
            this.chunkSize = ModularArithmetic.CANNOT_ASSUME_DENOM_IS_POWER_OF_TWO ? chunkSize : Util.findNextHighestPowerOfTwo(chunkSize);
            this.flags = flags;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public long getModificationTime() {
            return this.modificationTime;
        }

        public void setModificationTime(long modificationTime) {
            this.modificationTime = modificationTime;
        }

        public int getChunkSize() {
            return this.chunkSize;
        }

        public boolean isFile() {
            return org.jgroups.util.Util.isFlagSet(this.flags, (byte)1);
        }

        public boolean isDirectory() {
            return org.jgroups.util.Util.isFlagSet(this.flags, (byte)2);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getType());
            if (this.isFile()) {
                sb.append(", len=" + org.jgroups.util.Util.printBytes(this.length) + ", chunkSize=" + this.chunkSize);
            }
            sb.append(", modTime=").append(new Date(this.modificationTime));
            return sb.toString();
        }

        private String getType() {
            if (this.isFile()) {
                return "file";
            }
            if (this.isDirectory()) {
                return "dir";
            }
            return "n/a";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.length);
            out.writeLong(this.modificationTime);
            out.writeInt(this.chunkSize);
            out.writeByte(this.flags);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.length = in.readInt();
            this.modificationTime = in.readLong();
            this.chunkSize = in.readInt();
            this.flags = in.readByte();
        }
    }
}

