/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResolver;
import javax.interceptor.InvocationContext;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractCacheRemoveAllInterceptor
implements Serializable {
    private static final long serialVersionUID = -8763819640664021763L;
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    public AbstractCacheRemoveAllInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    public Object cacheRemoveAll(InvocationContext invocationContext) throws Exception {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Interception of method named '%s'", (Object)invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheRemoveAll cacheRemoveAll = (CacheRemoveAll)cacheKeyInvocationContext.getCacheAnnotation();
        Cache cache = this.cacheResolver.resolveCache(cacheKeyInvocationContext);
        if (!cacheRemoveAll.afterInvocation()) {
            cache.clear();
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Clear cache '%s' before method invocation", (Object)cache.getName());
            }
        }
        Object result = invocationContext.proceed();
        if (cacheRemoveAll.afterInvocation()) {
            cache.clear();
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Clear cache '%s' after method invocation", (Object)cache.getName());
            }
        }
        return result;
    }

    protected abstract Log getLog();
}

