/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;

public class DistributionResponseGenerator
implements ResponseGenerator {
    DistributionManager distributionManager;

    @Inject
    public void inject(DistributionManager distributionManager) {
        this.distributionManager = distributionManager;
    }

    @Override
    public Response getResponse(CacheRpcCommand command, Object returnValue) {
        if (returnValue instanceof Response) {
            return (Response)returnValue;
        }
        if (command.getCommandId() == 16) {
            ClusteredGetCommand clusteredGet = (ClusteredGetCommand)command;
            if (returnValue == null && this.distributionManager.isAffectedByRehash(clusteredGet.getKey())) {
                return UnsureResponse.INSTANCE;
            }
            return SuccessfulResponse.create(returnValue);
        }
        if (command instanceof SingleRpcCommand) {
            SingleRpcCommand src = (SingleRpcCommand)command;
            ReplicableCommand c = src.getCommand();
            byte commandId = c.getCommandId();
            if (c instanceof WriteCommand) {
                if (returnValue == null) {
                    return null;
                }
                WriteCommand wc = (WriteCommand)c;
                return this.handleWriteCommand(wc, returnValue);
            }
            if (commandId == 30 || commandId == 31 || commandId == 19) {
                return SuccessfulResponse.create(returnValue);
            }
            if (c.isReturnValueExpected()) {
                if (returnValue == null) {
                    return null;
                }
                return SuccessfulResponse.create(returnValue);
            }
        } else if (command.isReturnValueExpected()) {
            return SuccessfulResponse.create(returnValue);
        }
        return null;
    }

    protected Response handleWriteCommand(WriteCommand wc, Object returnValue) {
        return wc.isReturnValueExpected() ? SuccessfulResponse.create(returnValue) : null;
    }
}

