/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class ClearCommand
extends AbstractTopologyAffectedCommand
implements WriteCommand {
    public static final byte COMMAND_ID = 5;
    private CacheNotifier<Object, Object> notifier;
    private DataContainer<?, ?> dataContainer;

    public ClearCommand() {
    }

    public ClearCommand(CacheNotifier<Object, Object> notifier, DataContainer<?, ?> dataContainer, long flagsBitSet) {
        this.notifier = notifier;
        this.dataContainer = dataContainer;
        this.setFlagsBitSet(flagsBitSet);
    }

    public void init(CacheNotifier<Object, Object> notifier, DataContainer<?, ?> dataContainer) {
        this.notifier = notifier;
        this.dataContainer = dataContainer;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitClearCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        this.dataContainer.iterator().forEachRemaining(e -> this.notifier.notifyCacheEntryRemoved(e.getKey(), e.getValue(), e.getMetadata(), true, ctx, this));
        return null;
    }

    @Override
    public byte getCommandId() {
        return 5;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setFlagsBitSet(input.readLong());
    }

    public String toString() {
        return "ClearCommand{flags=" + this.printFlags() + "}";
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return Collections.emptySet();
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClearCommand that = (ClearCommand)o;
        if (this.getTopologyId() != that.getTopologyId()) {
            return false;
        }
        return this.getFlagsBitSet() == that.getFlagsBitSet();
    }

    public int hashCode() {
        int result = this.getTopologyId();
        long flags = this.getFlagsBitSet();
        result = 31 * result + (int)(flags ^ flags >>> 32);
        return result;
    }
}

