/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.jmx.MBeanServerLookup;

public class GlobalJmxStatisticsConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalJmxStatisticsConfiguration> {
    private final AttributeSet attributes = GlobalJmxStatisticsConfiguration.attributeDefinitionSet();

    GlobalJmxStatisticsConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public GlobalJmxStatisticsConfigurationBuilder withProperties(Properties properties) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.PROPERTIES).set(new TypedProperties(properties));
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder addProperty(String key, String value) {
        TypedProperties properties = this.attributes.attribute(GlobalJmxStatisticsConfiguration.PROPERTIES).get();
        properties.put(key, value);
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.PROPERTIES).set(TypedProperties.toTypedProperties(properties));
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder jmxDomain(String jmxDomain) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.JMX_DOMAIN).set(jmxDomain);
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder allowDuplicateDomains(Boolean allowDuplicateDomains) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.ALLOW_DUPLICATE_DOMAINS).set(allowDuplicateDomains);
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder cacheManagerName(String cacheManagerName) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.CACHE_MANAGER_NAME).set(cacheManagerName);
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder mBeanServerLookup(MBeanServerLookup mBeanServerLookupInstance) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.MBEAN_SERVER_LOOKUP).set(mBeanServerLookupInstance);
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder disable() {
        this.enabled(false);
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder enable() {
        this.enabled(true);
        return this;
    }

    public GlobalJmxStatisticsConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(GlobalJmxStatisticsConfiguration.ENABLED).set(enabled);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public GlobalJmxStatisticsConfiguration create() {
        return new GlobalJmxStatisticsConfiguration(this.attributes.protect());
    }

    public GlobalJmxStatisticsConfigurationBuilder read(GlobalJmxStatisticsConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "GlobalJmxStatisticsConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

