/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedRepeatableReadEntry
extends RepeatableReadEntry
implements Versioned {
    private static final Log log = LogFactory.getLog(VersionedRepeatableReadEntry.class);
    private static final boolean trace = log.isTraceEnabled();

    public VersionedRepeatableReadEntry(Object key, Object value, Metadata metadata) {
        super(key, value, metadata);
    }

    public boolean performWriteSkewCheck(DataContainer container, PersistenceManager persistenceManager, TxInvocationContext ctx, EntryVersion versionSeen, VersionGenerator versionGenerator, TimeService timeService) {
        EntryVersion prevVersion;
        if (versionSeen == null) {
            if (trace) {
                log.tracef("Perform write skew check for key %s but the key was not read. Skipping check!", (Object)Util.toStr(this.key));
            }
            return true;
        }
        if (ctx.isOriginLocal()) {
            prevVersion = this.getCurrentEntryVersion(container, persistenceManager, ctx, versionGenerator, timeService);
        } else {
            prevVersion = (EntryVersion)((AbstractCacheTransaction)ctx.getCacheTransaction()).getVersionsRead().get(this.key);
            if (prevVersion == null) {
                prevVersion = this.getCurrentEntryVersion(container, persistenceManager, ctx, versionGenerator, timeService);
            }
        }
        if (prevVersion.compareTo(this.metadata.version()) != InequalVersionComparisonResult.EQUAL) {
            if (trace) {
                log.tracef("Updating version in metadata %s -> %s", (Object)this.metadata.version(), (Object)prevVersion);
            }
            this.metadata = this.metadata.builder().version(prevVersion).build();
        }
        InequalVersionComparisonResult result = prevVersion.compareTo(versionSeen);
        if (trace) {
            log.tracef("Comparing versions %s and %s for key %s: %s", new Object[]{prevVersion, versionSeen, this.key, result});
        }
        return InequalVersionComparisonResult.EQUAL == result;
    }

    private EntryVersion getCurrentEntryVersion(DataContainer container, PersistenceManager persistenceManager, TxInvocationContext ctx, VersionGenerator versionGenerator, TimeService timeService) {
        EntryVersion prevVersion;
        InternalCacheEntry ice = PersistenceUtil.loadAndStoreInDataContainer(container, persistenceManager, this.getKey(), ctx, timeService, null);
        if (ice == null) {
            if (trace) {
                log.tracef("No entry for key %s found in data container", (Object)Util.toStr(this.key));
            }
            prevVersion = versionGenerator.nonExistingVersion();
        } else {
            prevVersion = ice.getMetadata().version();
            if (prevVersion == null) {
                throw new IllegalStateException("Entries cannot have null versions!");
            }
        }
        return prevVersion;
    }

    @Override
    public EntryVersion getVersion() {
        return this.metadata.version();
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.metadata = this.metadata.builder().version(version).build();
    }

    @Override
    public VersionedRepeatableReadEntry clone() {
        return (VersionedRepeatableReadEntry)super.clone();
    }
}

