/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import org.infinispan.marshall.core.BytesObjectInput;
import org.infinispan.marshall.core.BytesObjectOutput;
import org.jboss.marshalling.util.IdentityIntMap;

final class Primitives {
    static final int ID_BYTE_ARRAY = 1;
    static final int ID_STRING = 2;
    static final int ID_BOOLEAN_OBJ = 16;
    static final int ID_BYTE_OBJ = 17;
    static final int ID_CHAR_OBJ = 18;
    static final int ID_DOUBLE_OBJ = 19;
    static final int ID_FLOAT_OBJ = 20;
    static final int ID_INT_OBJ = 21;
    static final int ID_LONG_OBJ = 22;
    static final int ID_SHORT_OBJ = 23;
    static final int ID_BOOLEAN_ARRAY = 24;
    static final int ID_CHAR_ARRAY = 25;
    static final int ID_DOUBLE_ARRAY = 26;
    static final int ID_FLOAT_ARRAY = 27;
    static final int ID_INT_ARRAY = 28;
    static final int ID_LONG_ARRAY = 29;
    static final int ID_SHORT_ARRAY = 30;
    static final int ID_ARRAY_EMPTY = 40;
    static final int ID_ARRAY_SMALL = 41;
    static final int ID_ARRAY_MEDIUM = 42;
    static final int ID_ARRAY_LARGE = 43;
    static final int SMALL_ARRAY_MIN = 1;
    static final int SMALL_ARRAY_MAX = 256;
    static final int MEDIUM_ARRAY_MIN = 257;
    static final int MEDIUM_ARRAY_MAX = 65792;
    static final IdentityIntMap<Class<?>> PRIMITIVES = new IdentityIntMap(0.375f);

    private Primitives() {
    }

    static void writePrimitive(Object obj, BytesObjectOutput out, int id) throws IOException {
        out.writeByte(id);
        Primitives.writeRawPrimitive(obj, out, id);
    }

    static void writeRawPrimitive(Object obj, BytesObjectOutput out, int id) throws IOException {
        switch (id) {
            case 1: {
                Primitives.writeByteArray((byte[])obj, out);
                break;
            }
            case 2: {
                out.writeString((String)obj);
                break;
            }
            case 16: {
                out.writeBoolean((Boolean)obj);
                break;
            }
            case 17: {
                out.writeByte(((Byte)obj).byteValue());
                break;
            }
            case 18: {
                out.writeChar(((Character)obj).charValue());
                break;
            }
            case 19: {
                out.writeDouble((Double)obj);
                break;
            }
            case 20: {
                out.writeFloat(((Float)obj).floatValue());
                break;
            }
            case 21: {
                out.writeInt((Integer)obj);
                break;
            }
            case 22: {
                out.writeLong((Long)obj);
                break;
            }
            case 23: {
                out.writeShort(((Short)obj).shortValue());
                break;
            }
            case 24: {
                Primitives.writeBooleanArray((boolean[])obj, out);
                break;
            }
            case 25: {
                Primitives.writeCharArray((char[])obj, out);
                break;
            }
            case 26: {
                Primitives.writeDoubleArray((double[])obj, out);
                break;
            }
            case 27: {
                Primitives.writeFloatArray((float[])obj, out);
                break;
            }
            case 28: {
                Primitives.writeIntArray((int[])obj, out);
                break;
            }
            case 29: {
                Primitives.writeLongArray((long[])obj, out);
                break;
            }
            case 30: {
                Primitives.writeShortArray((short[])obj, out);
                break;
            }
            default: {
                throw new IOException("Unknown primitive type: " + obj);
            }
        }
    }

    static Object readPrimitive(BytesObjectInput in) throws IOException, ClassNotFoundException {
        int subId = in.readUnsignedByte();
        return Primitives.readRawPrimitive(in, subId);
    }

    static Object readRawPrimitive(BytesObjectInput in, int subId) throws IOException {
        switch (subId) {
            case 1: {
                return Primitives.readByteArray(in);
            }
            case 2: {
                return in.readString();
            }
            case 16: {
                return in.readBoolean();
            }
            case 17: {
                return in.readByte();
            }
            case 18: {
                return Character.valueOf(in.readChar());
            }
            case 19: {
                return in.readDouble();
            }
            case 20: {
                return Float.valueOf(in.readFloat());
            }
            case 21: {
                return in.readInt();
            }
            case 22: {
                return in.readLong();
            }
            case 23: {
                return in.readShort();
            }
            case 24: {
                return Primitives.readBooleanArray(in);
            }
            case 25: {
                return Primitives.readCharArray(in);
            }
            case 26: {
                return Primitives.readDoubleArray(in);
            }
            case 27: {
                return Primitives.readFloatArray(in);
            }
            case 28: {
                return Primitives.readIntArray(in);
            }
            case 29: {
                return Primitives.readLongArray(in);
            }
            case 30: {
                return Primitives.readShortArray(in);
            }
        }
        throw new IOException("Unknown primitive sub id: " + Integer.toHexString(subId));
    }

    private static void writeByteArray(byte[] obj, BytesObjectOutput out) {
        int len = obj.length;
        if (len == 0) {
            out.writeByte(40);
        } else if (len <= 256) {
            out.writeByte(41);
            out.writeByte(len - 1);
            out.write(obj, 0, len);
        } else if (len <= 65792) {
            out.writeByte(42);
            out.writeShort(len - 257);
            out.write(obj, 0, len);
        } else {
            out.writeByte(43);
            out.writeInt(len);
            out.write(obj, 0, len);
        }
    }

    private static void writeBooleanArray(boolean[] obj, BytesObjectOutput out) {
        int len = obj.length;
        if (len == 0) {
            out.writeByte(40);
        } else if (len <= 256) {
            out.writeByte(41);
            out.writeByte(len - 1);
            Primitives.writeBooleans(obj, out);
        } else if (len <= 65792) {
            out.writeByte(42);
            out.writeShort(len - 257);
            Primitives.writeBooleans(obj, out);
        } else {
            out.writeByte(43);
            out.writeInt(len);
            Primitives.writeBooleans(obj, out);
        }
    }

    private static void writeBooleans(boolean[] obj, BytesObjectOutput out) {
        int len = obj.length;
        int bc = len & 0xFFFFFFF8;
        int i = 0;
        while (i < bc) {
            out.write((obj[i++] ? 1 : 0) | (obj[i++] ? 2 : 0) | (obj[i++] ? 4 : 0) | (obj[i++] ? 8 : 0) | (obj[i++] ? 16 : 0) | (obj[i++] ? 32 : 0) | (obj[i++] ? 64 : 0) | (obj[i++] ? 128 : 0));
        }
        if (bc < len) {
            int o = 0;
            int bit = 1;
            for (int i2 = bc; i2 < len; ++i2) {
                if (obj[i2]) {
                    o |= bit;
                }
                bit <<= 1;
            }
            out.writeByte(o);
        }
    }

    private static void writeCharArray(char[] obj, BytesObjectOutput out) {
        int len = obj.length;
        if (len == 0) {
            out.writeByte(40);
        } else if (len <= 256) {
            out.writeByte(41);
            out.writeByte(len - 1);
            for (char v : obj) {
                out.writeChar(v);
            }
        } else if (len <= 65792) {
            out.writeByte(42);
            out.writeShort(len - 257);
            for (char v : obj) {
                out.writeChar(v);
            }
        } else {
            out.writeByte(43);
            out.writeInt(len);
            for (char v : obj) {
                out.writeChar(v);
            }
        }
    }

    private static void writeDoubleArray(double[] obj, BytesObjectOutput out) {
        int len = obj.length;
        if (len == 0) {
            out.writeByte(40);
        } else if (len <= 256) {
            out.writeByte(41);
            out.writeByte(len - 1);
            for (double v : obj) {
                out.writeDouble(v);
            }
        } else if (len <= 65792) {
            out.writeByte(42);
            out.writeShort(len - 257);
            for (double v : obj) {
                out.writeDouble(v);
            }
        } else {
            out.writeByte(43);
            out.writeInt(len);
            for (double v : obj) {
                out.writeDouble(v);
            }
        }
    }

    private static void writeFloatArray(float[] obj, BytesObjectOutput out) {
        int len = obj.length;
        if (len == 0) {
            out.writeByte(40);
        } else if (len <= 256) {
            out.writeByte(41);
            out.writeByte(len - 1);
            for (float v : obj) {
                out.writeFloat(v);
            }
        } else if (len <= 65792) {
            out.writeByte(42);
            out.writeShort(len - 257);
            for (float v : obj) {
                out.writeFloat(v);
            }
        } else {
            out.writeByte(43);
            out.writeInt(len);
            for (float v : obj) {
                out.writeFloat(v);
            }
        }
    }

    private static void writeIntArray(int[] obj, BytesObjectOutput out) {
        int len = obj.length;
        if (len == 0) {
            out.writeByte(40);
        } else if (len <= 256) {
            out.writeByte(41);
            out.writeByte(len - 1);
            for (int v : obj) {
                out.writeInt(v);
            }
        } else if (len <= 65792) {
            out.writeByte(42);
            out.writeShort(len - 257);
            for (int v : obj) {
                out.writeInt(v);
            }
        } else {
            out.writeByte(43);
            out.writeInt(len);
            for (int v : obj) {
                out.writeInt(v);
            }
        }
    }

    private static void writeLongArray(long[] obj, BytesObjectOutput out) {
        int len = obj.length;
        if (len == 0) {
            out.writeByte(40);
        } else if (len <= 256) {
            out.writeByte(41);
            out.writeByte(len - 1);
            for (long v : obj) {
                out.writeLong(v);
            }
        } else if (len <= 65792) {
            out.writeByte(42);
            out.writeShort(len - 257);
            for (long v : obj) {
                out.writeLong(v);
            }
        } else {
            out.writeByte(43);
            out.writeInt(len);
            for (long v : obj) {
                out.writeLong(v);
            }
        }
    }

    private static void writeShortArray(short[] obj, BytesObjectOutput out) {
        int len = obj.length;
        if (len == 0) {
            out.writeByte(40);
        } else if (len <= 256) {
            out.writeByte(41);
            out.writeByte(len - 1);
            for (short v : obj) {
                out.writeShort(v);
            }
        } else if (len <= 65792) {
            out.writeByte(42);
            out.writeShort(len - 257);
            for (short v : obj) {
                out.writeShort(v);
            }
        } else {
            out.writeByte(43);
            out.writeInt(len);
            for (short v : obj) {
                out.writeShort(v);
            }
        }
    }

    private static byte[] readByteArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new byte[0];
            }
            case 41: {
                return Primitives.readFully(Primitives.mkByteArray(in.readUnsignedByte() + 1), in);
            }
            case 42: {
                return Primitives.readFully(Primitives.mkByteArray(in.readUnsignedShort() + 257), in);
            }
            case 43: {
                return Primitives.readFully(new byte[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static byte[] mkByteArray(int len) {
        return new byte[len];
    }

    private static byte[] readFully(byte[] arr, BytesObjectInput in) {
        in.readFully(arr);
        return arr;
    }

    private static boolean[] readBooleanArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new boolean[0];
            }
            case 41: {
                return Primitives.readBooleans(Primitives.mkBooleanArray(in.readUnsignedByte() + 1), in);
            }
            case 42: {
                return Primitives.readBooleans(Primitives.mkBooleanArray(in.readUnsignedShort() + 257), in);
            }
            case 43: {
                return Primitives.readBooleans(new boolean[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static boolean[] mkBooleanArray(int len) {
        return new boolean[len];
    }

    private static boolean[] readBooleans(boolean[] arr, BytesObjectInput in) {
        byte v;
        int len = arr.length;
        int bc = len & 0xFFFFFFF8;
        int i = 0;
        while (i < bc) {
            v = in.readByte();
            arr[i++] = (v & 1) != 0;
            arr[i++] = (v & 2) != 0;
            arr[i++] = (v & 4) != 0;
            arr[i++] = (v & 8) != 0;
            arr[i++] = (v & 0x10) != 0;
            arr[i++] = (v & 0x20) != 0;
            arr[i++] = (v & 0x40) != 0;
            arr[i++] = (v & 0x80) != 0;
        }
        if (bc < len) {
            v = in.readByte();
            switch (len & 7) {
                case 7: {
                    arr[bc + 6] = (v & 0x40) != 0;
                }
                case 6: {
                    arr[bc + 5] = (v & 0x20) != 0;
                }
                case 5: {
                    arr[bc + 4] = (v & 0x10) != 0;
                }
                case 4: {
                    arr[bc + 3] = (v & 8) != 0;
                }
                case 3: {
                    arr[bc + 2] = (v & 4) != 0;
                }
                case 2: {
                    arr[bc + 1] = (v & 2) != 0;
                }
                case 1: {
                    arr[bc] = (v & 1) != 0;
                }
            }
        }
        return arr;
    }

    private static char[] readCharArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new char[0];
            }
            case 41: {
                return Primitives.readChars(Primitives.mkCharArray(in.readUnsignedByte() + 1), in);
            }
            case 42: {
                return Primitives.readChars(Primitives.mkCharArray(in.readUnsignedShort() + 257), in);
            }
            case 43: {
                return Primitives.readChars(new char[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static char[] mkCharArray(int len) {
        return new char[len];
    }

    private static char[] readChars(char[] arr, BytesObjectInput in) {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readChar();
        }
        return arr;
    }

    private static double[] readDoubleArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new double[0];
            }
            case 41: {
                return Primitives.readDoubles(new double[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readDoubles(new double[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readDoubles(new double[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static double[] readDoubles(double[] arr, BytesObjectInput in) {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readDouble();
        }
        return arr;
    }

    private static float[] readFloatArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new float[0];
            }
            case 41: {
                return Primitives.readFloats(new float[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readFloats(new float[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readFloats(new float[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static float[] readFloats(float[] arr, BytesObjectInput in) {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readFloat();
        }
        return arr;
    }

    private static int[] readIntArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new int[0];
            }
            case 41: {
                return Primitives.readInts(new int[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readInts(new int[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readInts(new int[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static int[] readInts(int[] arr, BytesObjectInput in) {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readInt();
        }
        return arr;
    }

    private static long[] readLongArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new long[0];
            }
            case 41: {
                return Primitives.readLongs(new long[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readLongs(new long[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readLongs(new long[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static long[] readLongs(long[] arr, BytesObjectInput in) {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readLong();
        }
        return arr;
    }

    private static short[] readShortArray(BytesObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 40: {
                return new short[0];
            }
            case 41: {
                return Primitives.readShorts(new short[in.readUnsignedByte() + 1], in);
            }
            case 42: {
                return Primitives.readShorts(new short[in.readUnsignedShort() + 257], in);
            }
            case 43: {
                return Primitives.readShorts(new short[in.readInt()], in);
            }
        }
        throw new IOException("Unknown array type: " + Integer.toHexString(type));
    }

    private static short[] readShorts(short[] arr, BytesObjectInput in) {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readShort();
        }
        return arr;
    }

    static {
        PRIMITIVES.put(String.class, 2);
        PRIMITIVES.put(byte[].class, 1);
        PRIMITIVES.put(Boolean.class, 16);
        PRIMITIVES.put(Byte.class, 17);
        PRIMITIVES.put(Character.class, 18);
        PRIMITIVES.put(Double.class, 19);
        PRIMITIVES.put(Float.class, 20);
        PRIMITIVES.put(Integer.class, 21);
        PRIMITIVES.put(Long.class, 22);
        PRIMITIVES.put(Short.class, 23);
        PRIMITIVES.put(boolean[].class, 24);
        PRIMITIVES.put(char[].class, 25);
        PRIMITIVES.put(double[].class, 26);
        PRIMITIVES.put(float[].class, 27);
        PRIMITIVES.put(int[].class, 28);
        PRIMITIVES.put(long[].class, 29);
        PRIMITIVES.put(short[].class, 30);
    }
}

