/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationSerializer;

@BuiltBy(value=RemoteStoreConfigurationBuilder.class)
@ConfigurationFor(value=RemoteStore.class)
@SerializedWith(value=RemoteStoreConfigurationSerializer.class)
public class RemoteStoreConfiguration
extends AbstractStoreConfiguration {
    static final AttributeDefinition<String> BALANCING_STRATEGY = AttributeDefinition.builder("balancingStrategy", RoundRobinBalancingStrategy.class.getName()).immutable().build();
    static final AttributeDefinition<Long> CONNECTION_TIMEOUT = AttributeDefinition.builder("connectionTimeout", 60000L).xmlName("connect-timeout").build();
    static final AttributeDefinition<Boolean> FORCE_RETURN_VALUES = AttributeDefinition.builder("forceReturnValues", false).immutable().build();
    static final AttributeDefinition<Boolean> HOTROD_WRAPPING = AttributeDefinition.builder("hotRodWrapping", false).immutable().xmlName("hotrod-wrapping").build();
    static final AttributeDefinition<Boolean> RAW_VALUES = AttributeDefinition.builder("rawValues", false).immutable().build();
    static final AttributeDefinition<Integer> KEY_SIZE_ESTIMATE = AttributeDefinition.builder("keySizeEstimate", 64).immutable().build();
    static final AttributeDefinition<Integer> VALUE_SIZE_ESTIMATE = AttributeDefinition.builder("valueSizeEstimate", 512).immutable().build();
    static final AttributeDefinition<String> MARSHALLER = AttributeDefinition.builder("marshaller", null, String.class).immutable().build();
    static final AttributeDefinition<ProtocolVersion> PROTOCOL_VERSION = AttributeDefinition.builder("protocolVersion", ProtocolVersion.DEFAULT_PROTOCOL_VERSION).immutable().build();
    static final AttributeDefinition<String> REMOTE_CACHE_NAME = AttributeDefinition.builder("remoteCacheName", "___defaultcache").immutable().xmlName("cache").build();
    static final AttributeDefinition<List<RemoteServerConfiguration>> SERVERS = AttributeDefinition.builder("servers", null, List.class).initializer(() -> new ArrayList()).autoPersist(false).build();
    static final AttributeDefinition<Long> SOCKET_TIMEOUT = AttributeDefinition.builder("socketTimeout", 60000L).build();
    static final AttributeDefinition<Boolean> TCP_NO_DELAY = AttributeDefinition.builder("tcpNoDelay", true).build();
    static final AttributeDefinition<String> TRANSPORT_FACTORY = AttributeDefinition.builder("transportFactory", null, String.class).immutable().build();
    private final Attribute<String> balancingStrategy;
    private final Attribute<Long> connectionTimeout;
    private final Attribute<Boolean> forceReturnValues;
    private final Attribute<Boolean> hotRodWrapping;
    private final Attribute<Boolean> rawValues;
    private final Attribute<Integer> keySizeEstimate;
    private final Attribute<Integer> valueSizeEstimate;
    private final Attribute<String> marshaller;
    private final Attribute<ProtocolVersion> protocolVersion;
    private final Attribute<String> remoteCacheName;
    private final Attribute<List<RemoteServerConfiguration>> servers;
    private final Attribute<Long> socketTimeout;
    private final Attribute<Boolean> tcpNoDelay;
    private final Attribute<String> transportFactory;
    private final ConnectionPoolConfiguration connectionPool;
    private final ExecutorFactoryConfiguration asyncExecutorFactory;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RemoteStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), BALANCING_STRATEGY, CONNECTION_TIMEOUT, FORCE_RETURN_VALUES, HOTROD_WRAPPING, RAW_VALUES, KEY_SIZE_ESTIMATE, MARSHALLER, PROTOCOL_VERSION, REMOTE_CACHE_NAME, SERVERS, SOCKET_TIMEOUT, TCP_NO_DELAY, TRANSPORT_FACTORY, VALUE_SIZE_ESTIMATE);
    }

    public RemoteStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, ExecutorFactoryConfiguration asyncExecutorFactory, ConnectionPoolConfiguration connectionPool) {
        super(attributes, async, singletonStore);
        this.balancingStrategy = attributes.attribute(BALANCING_STRATEGY);
        this.connectionTimeout = attributes.attribute(CONNECTION_TIMEOUT);
        this.forceReturnValues = attributes.attribute(FORCE_RETURN_VALUES);
        this.hotRodWrapping = attributes.attribute(HOTROD_WRAPPING);
        this.rawValues = attributes.attribute(RAW_VALUES);
        this.keySizeEstimate = attributes.attribute(KEY_SIZE_ESTIMATE);
        this.valueSizeEstimate = attributes.attribute(VALUE_SIZE_ESTIMATE);
        this.marshaller = attributes.attribute(MARSHALLER);
        this.protocolVersion = attributes.attribute(PROTOCOL_VERSION);
        this.remoteCacheName = attributes.attribute(REMOTE_CACHE_NAME);
        this.servers = attributes.attribute(SERVERS);
        this.socketTimeout = attributes.attribute(SOCKET_TIMEOUT);
        this.tcpNoDelay = attributes.attribute(TCP_NO_DELAY);
        this.transportFactory = attributes.attribute(TRANSPORT_FACTORY);
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.connectionPool = connectionPool;
    }

    public ExecutorFactoryConfiguration asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public String balancingStrategy() {
        return this.balancingStrategy.get();
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public long connectionTimeout() {
        return this.connectionTimeout.get();
    }

    public boolean forceReturnValues() {
        return this.forceReturnValues.get();
    }

    public boolean hotRodWrapping() {
        return this.hotRodWrapping.get();
    }

    public int keySizeEstimate() {
        return this.keySizeEstimate.get();
    }

    public String marshaller() {
        return this.marshaller.get();
    }

    @Deprecated
    public String protocolVersion() {
        return this.protocolVersion.get().toString();
    }

    public ProtocolVersion protocol() {
        return this.protocolVersion.get();
    }

    public boolean rawValues() {
        return this.rawValues.get();
    }

    public String remoteCacheName() {
        return this.remoteCacheName.get();
    }

    public List<RemoteServerConfiguration> servers() {
        return this.servers.get();
    }

    public long socketTimeout() {
        return this.socketTimeout.get();
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay.get();
    }

    public String transportFactory() {
        return this.transportFactory.get();
    }

    public int valueSizeEstimate() {
        return this.valueSizeEstimate.get();
    }
}

