/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.BitSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.compat.TypeConverter;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.stream.impl.RemovableCloseableIterator;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryStreamSupplier<K, V>
implements AbstractLocalCacheStream.StreamSupplier<CacheEntry<K, V>, Stream<CacheEntry<K, V>>> {
    private static final Log log = LogFactory.getLog(EntryStreamSupplier.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Cache<K, V> cache;
    private final ConsistentHash hash;
    private final Supplier<Stream<CacheEntry<K, V>>> supplier;

    public EntryStreamSupplier(Cache<K, V> cache, ConsistentHash hash, Supplier<Stream<CacheEntry<K, V>>> supplier) {
        this.cache = cache;
        this.hash = hash;
        this.supplier = supplier;
    }

    @Override
    public Stream<CacheEntry<K, V>> buildStream(Set<Integer> segmentsToFilter, Set<?> keysToFilter) {
        Stream<CacheEntry<K, V>> stream;
        if (keysToFilter != null) {
            if (trace) {
                log.tracef("Applying key filtering %s", (Object)keysToFilter);
            }
            AdvancedCache advancedCache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
            TypeConverter typeConverter = advancedCache.getComponentRegistry().getComponent(TypeConverter.class);
            stream = keysToFilter.stream().map(typeConverter::boxKey).map(advancedCache::getCacheEntry).filter(e -> e != null);
        } else {
            stream = this.supplier.get();
        }
        if (segmentsToFilter != null && this.hash != null) {
            if (trace) {
                log.tracef("Applying segment filter %s", (Object)segmentsToFilter);
            }
            BitSet bitSet = new BitSet(this.hash.getNumSegments());
            segmentsToFilter.forEach(bitSet::set);
            stream = stream.filter(k -> bitSet.get(this.hash.getSegment(k.getKey())));
        }
        return stream;
    }

    @Override
    public CloseableIterator<CacheEntry<K, V>> removableIterator(CloseableIterator<CacheEntry<K, V>> realIterator) {
        return new RemovableCloseableIterator<Object, CacheEntry>(realIterator, this.cache, CacheEntry::getKey);
    }
}

