/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.common.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import org.jgroups.JChannel;
import org.jgroups.ping.common.server.AbstractServer;
import org.jgroups.ping.common.server.Server;

public class JDKServer
extends AbstractServer {
    private HttpServer server;

    public JDKServer(int port) {
        super(port);
    }

    @Override
    public synchronized boolean start(JChannel channel) throws Exception {
        boolean started = false;
        if (this.server == null) {
            try {
                InetSocketAddress address = new InetSocketAddress("0.0.0.0", this.port);
                this.server = HttpServer.create(address, 0);
                this.server.setExecutor(Executors.newCachedThreadPool());
                this.server.createContext("/", new Handler(this));
                this.server.start();
                started = true;
            }
            catch (Exception e) {
                this.server = null;
                throw e;
            }
        }
        this.addChannel(channel);
        return started;
    }

    @Override
    public synchronized boolean stop(JChannel channel) {
        boolean stopped = false;
        this.removeChannel(channel);
        if (this.server != null && !this.hasChannels()) {
            try {
                this.server.stop(0);
                stopped = true;
            }
            finally {
                this.server = null;
            }
        }
        return stopped;
    }

    private class Handler
    implements HttpHandler {
        private final Server server;

        private Handler(Server server) {
            this.server = server;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            exchange.sendResponseHeaders(200, 0L);
            try {
                String clusterName = exchange.getRequestHeaders().getFirst("CLUSTER_NAME");
                JChannel channel = this.server.getChannel(clusterName);
                try (InputStream stream = exchange.getRequestBody();){
                    JDKServer.this.handlePingRequest(channel, stream);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

