/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.common.server;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.InputStream;
import org.jgroups.JChannel;
import org.jgroups.ping.common.server.AbstractServer;
import org.jgroups.ping.common.server.Server;

public class UndertowServer
extends AbstractServer {
    private Undertow server;

    public UndertowServer(int port) {
        super(port);
    }

    @Override
    public synchronized boolean start(JChannel channel) throws Exception {
        boolean started = false;
        if (this.server == null) {
            try {
                Undertow.Builder builder = Undertow.builder();
                builder.addHttpListener(this.port, "0.0.0.0");
                builder.setHandler((HttpHandler)new Handler(this));
                this.server = builder.build();
                this.server.start();
                started = true;
            }
            catch (Exception e) {
                this.server = null;
                throw e;
            }
        }
        this.addChannel(channel);
        return started;
    }

    @Override
    public synchronized boolean stop(JChannel channel) {
        boolean stopped = false;
        this.removeChannel(channel);
        if (this.server != null && !this.hasChannels()) {
            try {
                this.server.stop();
                stopped = true;
            }
            finally {
                this.server = null;
            }
        }
        return stopped;
    }

    private class Handler
    implements HttpHandler {
        private final Server server;

        private Handler(Server server) {
            this.server = server;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.isInIoThread()) {
                exchange.dispatch((HttpHandler)this);
                return;
            }
            exchange.startBlocking();
            String clusterName = exchange.getRequestHeaders().getFirst("CLUSTER_NAME");
            JChannel channel = this.server.getChannel(clusterName);
            try (InputStream stream = exchange.getInputStream();){
                UndertowServer.this.handlePingRequest(channel, stream);
            }
        }
    }
}

